/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.defaultHighlighters;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.DefaultHighlighterModel;
import com.jetbrains.rd.ide.model.HighlightInfoModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rdclient.daemon.FrontendMarkupCacheHighlightersIdStorageKt;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendAsyncTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendEmptyTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/defaultHighlighters/FrontendDefaultHighlighterModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "(Lcom/intellij/openapi/editor/colors/EditorColorsManager;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createHighlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "range", "Lcom/intellij/openapi/util/TextRange;", "Lcom/jetbrains/rd/ide/model/DefaultHighlighterModel;", "getInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl;", "initialize", "", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendDefaultHighlighterModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorColorsManager editorColorsManager;
    @NotNull
    private final FrontendTooltipProvider tooltipProvider;

    public FrontendDefaultHighlighterModelHandler(@NotNull EditorColorsManager editorColorsManager, @NotNull FrontendTooltipProvider tooltipProvider) {
        Intrinsics.checkNotNullParameter((Object)editorColorsManager, (String)"editorColorsManager");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        this.editorColorsManager = editorColorsManager;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof DefaultHighlighterModel;
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DefaultHighlighterModel $this$move_u24lambda_u240 = (DefaultHighlighterModel)model;
        boolean bl = false;
        return (HighlighterModel)new DefaultHighlighterModel($this$move_u24lambda_u240.getInfo(), $this$move_u24lambda_u240.getAfterEndOfLine(), $this$move_u24lambda_u240.getNeedsUpdateOnTyping(), $this$move_u24lambda_u240.getErased(), $this$move_u24lambda_u240.getRestrictCalculateTooltip(), $this$move_u24lambda_u240.getLayer(), $this$move_u24lambda_u240.isExactRange(), $this$move_u24lambda_u240.getDocumentVersion(), $this$move_u24lambda_u240.isGreedyToLeft(), $this$move_u24lambda_u240.isGreedyToRight(), $this$move_u24lambda_u240.isThinErrorStripeMark(), $this$move_u24lambda_u240.getTextToHighlight(), $this$move_u24lambda_u240.getTextAttributesKey(), $this$move_u24lambda_u240.getId(), $this$move_u24lambda_u240.getProperties(), startOffset, endOffset);
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        DefaultHighlighterModel cfr_ignored_0 = (DefaultHighlighterModel)model;
        TextRange range2 = new TextRange(highlighter2.getStartOffset(), highlighter2.getEndOffset());
        HighlightInfo info = this.createHighlightInfo(range2, (DefaultHighlighterModel)model);
        info.setHighlighter((RangeHighlighterEx)highlighter2);
        ((RangeHighlighterEx)highlighter2).setAfterEndOfLine(info.isAfterEndOfLine());
        if (((DefaultHighlighterModel)model).getErased()) {
            ((RangeHighlighterEx)highlighter2).setTextAttributes(TextAttributes.ERASE_MARKER);
        }
        ((RangeHighlighterEx)highlighter2).setErrorStripeTooltip((Object)info);
        TextAttributesKeyModel textAttributesKeyModel = model.getTextAttributesKey();
        if (textAttributesKeyModel != null) {
            TextAttributesKeyModel it = textAttributesKeyModel;
            boolean bl = false;
            TextAttributesKey attributesKey = TextAttributesRegistrationHost.Companion.getInstance().getTextAttributesKey(it);
            highlighter2.setTextAttributesKey(attributesKey);
        }
        if (info.getSeverity().compareTo(HighlightSeverity.INFORMATION) > 0) {
            EditorColorsScheme editorColorsScheme = this.editorColorsManager.getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
            Color infoColor = HighlightersUtilKt.getErrorStripeColor(info, editorColorsScheme);
            Color highlighterColor = highlighter2.getErrorStripeMarkColor(this.editorColorsManager.getGlobalScheme());
            if (!Intrinsics.areEqual((Object)infoColor, (Object)highlighterColor)) {
                ((RangeHighlighterEx)highlighter2).setErrorStripeMarkColor(infoColor);
            }
        }
    }

    private final HighlightInfo createHighlightInfo(TextRange range2, DefaultHighlighterModel model) {
        boolean isAfterEOL = model.getAfterEndOfLine();
        Boolean needsUpdate = model.getNeedsUpdateOnTyping();
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = this.getInfoType(model);
        if (highlightInfoTypeImpl == null) {
            FrontendDefaultHighlighterModelHandler $this$createHighlightInfo_u24lambda_u243 = this;
            boolean bl = false;
            TextAttributesKeyModel textAttributesKeyModel = model.getTextAttributesKey();
            if (!(textAttributesKeyModel != null)) {
                boolean bl2 = false;
                String string = "highlighter id: '" + model.getProperties().getAttributeId() + "', range: " + range2 + " can't be used to create HighlightInfo, because textAttributesKey is null";
                throw new IllegalStateException(string.toString());
            }
            TextAttributesKey textAttributesKey = TextAttributesRegistrationHost.Companion.getInstance().getTextAttributesKey(textAttributesKeyModel);
            highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, textAttributesKey);
        }
        HighlightInfoType.HighlightInfoTypeImpl infoType = highlightInfoTypeImpl;
        if (model.getRestrictCalculateTooltip()) {
            return new FrontendEmptyTooltipHighlightInfo(null, (HighlightInfoType)infoType, range2, isAfterEOL, needsUpdate);
        }
        return new FrontendAsyncTooltipHighlightInfo(null, (HighlightInfoType)infoType, range2, isAfterEOL, needsUpdate, FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId((HighlighterModel)model), this.tooltipProvider);
    }

    private final HighlightInfoType.HighlightInfoTypeImpl getInfoType(DefaultHighlighterModel model) {
        HighlightInfoModel highlightInfoModel = model.getInfo();
        if (highlightInfoModel == null) {
            return null;
        }
        HighlightInfoModel infoModel = highlightInfoModel;
        return TextAttributesRegistrationHost.Companion.getInstance().getHighlightInfoType(infoModel.getType());
    }
}

