/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileStructure;

import com.intellij.codeInsight.hint.ShowContainerInfoHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.model.CodeStructureTreeModel;
import com.jetbrains.rd.ide.model.CodeStructureTreeModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CodeStructureTreeNode;
import com.jetbrains.rd.ide.model.CodeStructureTreeNodesList;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import java.awt.EventQueue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J:\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J(\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdclient/fileStructure/FrontendFileStructureHost;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastStructureData", "", "Lcom/jetbrains/rdclient/services/IdeBackend;", "", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;", "structureTree", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getStructureTree", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "bindWithModel", "", "loadStructure", "editor", "Lcom/intellij/openapi/editor/Editor;", "processTree", "tree", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;", "list", "index", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "parent", "updateFileStructureModel", "treeModel", "treeNodes", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileStructureHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileStructureHost.kt\ncom/jetbrains/rdclient/fileStructure/FrontendFileStructureHost\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,199:1\n26#2:200\n1549#3:201\n1620#3,3:202\n37#4,2:205\n10#5:207\n*S KotlinDebug\n*F\n+ 1 FrontendFileStructureHost.kt\ncom/jetbrains/rdclient/fileStructure/FrontendFileStructureHost\n*L\n114#1:200\n132#1:201\n132#1:202,3\n134#1:205,2\n39#1:207\n*E\n"})
public final class FrontendFileStructureHost
extends LifetimedProjectComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<IdeBackend, List<CodeStructureTreeNode>> lastStructureData;
    @NotNull
    private final IOptProperty<ProtocolStructureViewTreeElement> structureTree;
    @NotNull
    private static final Logger LOG;

    public FrontendFileStructureHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.lastStructureData = new LinkedHashMap();
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)((Lifetime)this.getComponentLifetime()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendFileStructureHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.bindWithModel();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.structureTree = (IOptProperty)new OptProperty();
    }

    private final void bindWithModel() {
        IdeBackend backend = IdeBackend.Companion.getInstance(this.getProject());
        CodeStructureTreeModel tree = CodeStructureTreeModel_GeneratedKt.getCodeStructureTreeModel((Solution)backend.getSolution());
        tree.getTreeNodes().advise((Lifetime)this.getComponentLifetime(), (Function1)new Function1<CodeStructureTreeNodesList, Unit>(this, backend, tree){
            final /* synthetic */ FrontendFileStructureHost this$0;
            final /* synthetic */ IdeBackend $backend;
            final /* synthetic */ CodeStructureTreeModel $tree;
            {
                this.this$0 = $receiver;
                this.$backend = $backend;
                this.$tree = $tree;
                super(1);
            }

            public final void invoke(@NotNull CodeStructureTreeNodesList codeStructureTreeNodesList) {
                Intrinsics.checkNotNullParameter((Object)codeStructureTreeNodesList, (String)"<name for destructuring parameter 0>");
                RdDocumentId fileId = codeStructureTreeNodesList.component1();
                List treeNodes = codeStructureTreeNodesList.component2();
                FrontendFileStructureHost.access$getLastStructureData$p(this.this$0).put(this.$backend, treeNodes);
                FrontendFileStructureHost.access$getLOG$cp().trace("Received file structure tree from backend. Number of tree elements is " + treeNodes.size() + ".");
                FrontendFileStructureHost.access$updateFileStructureModel(this.this$0, this.$tree, treeNodes, fileId);
            }
        });
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        FileEditorManagerListener editorListener2 = new FileEditorManagerListener(this, backend, tree){
            final /* synthetic */ FrontendFileStructureHost this$0;
            final /* synthetic */ IdeBackend $backend;
            final /* synthetic */ CodeStructureTreeModel $tree;
            {
                this.this$0 = $receiver;
                this.$backend = $backend;
                this.$tree = $tree;
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FileEditor fileEditor = event.getNewEditor();
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null) {
                    return;
                }
                TextEditor fileEditor2 = textEditor;
                Editor editor2 = fileEditor2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
                if (textControlId == null || (textControlId = textControlId.getDocumentId()) == null) {
                    return;
                }
                TextControlId documentId = textControlId;
                List data = (List)FrontendFileStructureHost.access$getLastStructureData$p(this.this$0).get((Object)((Object)this.$backend));
                if (data != null) {
                    FrontendFileStructureHost.access$updateFileStructureModel(this.this$0, this.$tree, data, (RdDocumentId)documentId);
                }
            }
        };
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)editorListener2);
        ToolWindowManagerListener toolWindowListener2 = new ToolWindowManagerListener(tree){
            final /* synthetic */ CodeStructureTreeModel $tree;
            {
                this.$tree = $tree;
            }

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Structure");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                this.$tree.getToolWindowVisible().set((Object)toolWindow2.isVisible());
            }

            public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager manager) {
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                if (ids.contains("Structure")) {
                    this.stateChanged(manager);
                }
            }
        };
        Topic topic2 = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)toolWindowListener2);
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow("Structure");
        if (toolWindow != null) {
            tree.getToolWindowVisible().set((Object)toolWindow.isVisible());
        }
    }

    public final void loadStructure(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (ShowContainerInfoHandler.getProcessedHint((Editor)editor2) != null) {
            return;
        }
        IdeBackend backend = IdeBackend.Companion.getInstance(this.getProject());
        CodeStructureTreeModel tree = backend.getCodeStructureTreeModel();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)tree.getToolWindowVisible())) || BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)tree.getPopupVisible()))) {
            return;
        }
        tree.getToolWindowVisible().set((Object)true);
        IOptPropertyView iOptPropertyView = (IOptPropertyView)tree.getTreeNodes();
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.syncWaitUntilChanged(iOptPropertyView, duration, false);
        tree.getToolWindowVisible().set((Object)false);
    }

    private final void updateFileStructureModel(CodeStructureTreeModel treeModel, List<CodeStructureTreeNode> treeNodes, RdDocumentId documentId) {
        ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray;
        LOG.trace("Started updating file structure tree...");
        ProtocolStructureViewTreeElement structureTree = new ProtocolStructureViewTreeElement(null, new CodeStructureTreeNode(0, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), false, 0, 0, "loading", null, null), new ProtocolStructureViewTreeElement[0], this.getProject(), null, null);
        structureTree.setDocumentId(documentId);
        if (treeNodes.isEmpty()) {
            boolean $i$f$emptyArray = false;
            protocolStructureViewTreeElementArray = new ProtocolStructureViewTreeElement[]{};
        } else {
            protocolStructureViewTreeElementArray = this.processTree(treeModel, treeNodes, 0, documentId, null).getChildren();
        }
        structureTree.setChildren(protocolStructureViewTreeElementArray);
        LOG.trace("Finished updating file structure tree. Scheduling it for UI tree update...");
        EventQueue.invokeLater(() -> FrontendFileStructureHost.updateFileStructureModel$lambda$0(this, structureTree));
    }

    /*
     * WARNING - void declaration
     */
    private final ProtocolStructureViewTreeElement processTree(CodeStructureTreeModel tree, List<CodeStructureTreeNode> list, int index, RdDocumentId documentId, ProtocolStructureViewTreeElement parent) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        ProtocolStructureViewTreeElement protocolStructureViewTreeElement = new ProtocolStructureViewTreeElement(tree, list.get(index), new ProtocolStructureViewTreeElement[0], this.getProject(), documentId, parent);
        Iterable $this$map$iv = list.get(index).getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.processTree(tree, list, (int)c, documentId, protocolStructureViewTreeElement));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ProtocolStructureViewTreeElement[] children = thisCollection$iv.toArray(new ProtocolStructureViewTreeElement[0]);
        protocolStructureViewTreeElement.setChildren(children);
        return protocolStructureViewTreeElement;
    }

    @NotNull
    public final IOptProperty<ProtocolStructureViewTreeElement> getStructureTree() {
        return this.structureTree;
    }

    private static final void updateFileStructureModel$lambda$0(FrontendFileStructureHost this$0, ProtocolStructureViewTreeElement $structureTree) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$structureTree, (String)"$structureTree");
        this$0.structureTree.set((Object)$structureTree);
        LOG.trace("Finished updating file structure UI tree");
    }

    public static final /* synthetic */ Map access$getLastStructureData$p(FrontendFileStructureHost $this) {
        return $this.lastStructureData;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$updateFileStructureModel(FrontendFileStructureHost $this, CodeStructureTreeModel treeModel, List treeNodes, RdDocumentId documentId) {
        $this.updateFileStructureModel(treeModel, treeNodes, documentId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileStructureHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/fileStructure/FrontendFileStructureHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/fileStructure/FrontendFileStructureHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendFileStructureHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getComponent(FrontendFileStructureHost.class);
            Intrinsics.checkNotNull((Object)object);
            return (FrontendFileStructureHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

