/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.Collections;

public class PyMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file, int caretOffset) {
        if (file instanceof PyFile) {
            ArrayList<PsiElement> array = new ArrayList<PsiElement>();
            PyMethodNavigationOffsetProvider.addNavigationElements(array, (PsiElement)file);
            return MethodUpDownUtil.offsetsFromElements(array);
        }
        return null;
    }

    private static void addNavigationElements(ArrayList<PsiElement> array, PsiElement psiElement) {
        if (psiElement instanceof PyFile) {
            for (PyClass pyClass : ((PyFile)psiElement).getTopLevelClasses()) {
                PyMethodNavigationOffsetProvider.addNavigationElements(array, pyClass);
            }
            for (PyFunction pyFunction : ((PyFile)psiElement).getTopLevelFunctions()) {
                PyMethodNavigationOffsetProvider.addNavigationElements(array, pyFunction);
            }
        } else if (psiElement instanceof PyFunction) {
            array.add(psiElement);
        } else if (psiElement instanceof PyClass) {
            Collections.addAll(array, ((PyClass)psiElement).getMethods());
        }
    }
}

