/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PySuperMethodCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PySuperMethodCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.DEF_KEYWORD)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement nextElement;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement position = parameters.getOriginalPosition();
                PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)position, PyClass.class);
                PsiElement psiElement = nextElement = position != null ? position.getNextSibling() : null;
                if (containingClass == null && position instanceof PsiWhiteSpace) {
                    position = PsiTreeUtil.prevLeaf((PsiElement)position);
                    containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)position, PyClass.class);
                }
                if (containingClass == null) {
                    return;
                }
                HashSet<String> seenNames = new HashSet<String>();
                for (PyFunction function : containingClass.getMethods()) {
                    seenNames.add(function.getName());
                }
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)parameters.getOriginalFile());
                seenNames.addAll(PyNames.getBuiltinMethods(languageLevel).keySet());
                TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(containingClass.getProject(), containingClass.getContainingFile());
                for (PyFunction superMethod : PyPsiRefactoringUtil.getAllSuperMethods(containingClass, typeEvalContext)) {
                    if (!seenNames.add(superMethod.getName())) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(superMethod.getName());
                    if (!(nextElement instanceof PyParameterList)) {
                        boolean copyAnnotations = PyPsiRefactoringUtil.shouldCopyAnnotations(superMethod, parameters.getOriginalFile());
                        PyParameterList parameterList = copyAnnotations ? superMethod.getParameterList() : PySuperMethodCompletionContributor.stripAnnotations(superMethod.getParameterList());
                        builder.append(parameterList.getText());
                        if (superMethod.getAnnotation() != null && copyAnnotations) {
                            builder.append(" ").append(superMethod.getAnnotation().getText()).append(":");
                        } else if (superMethod.getTypeComment() != null) {
                            builder.append(":  ").append(superMethod.getTypeComment().getText());
                        } else {
                            builder.append(":");
                        }
                    }
                    LookupElementBuilder element = LookupElementBuilder.create((String)builder.toString()).withInsertHandler((insertionContext, item) -> {
                        PsiElement patt5258$temp;
                        PsiElement methodName = insertionContext.getFile().findElementAt(insertionContext.getStartOffset());
                        if (methodName == null || !((patt5258$temp = methodName.getParent()) instanceof PyFunction)) {
                            return;
                        }
                        PyFunction insertedMethod = (PyFunction)patt5258$temp;
                        WriteCommandAction.writeCommandAction((PsiFile)insertionContext.getFile(), (PsiFile[])new PsiFile[0]).run(() -> PyClassRefactoringUtil.transplantImportsFromSignature(superMethod, insertedMethod));
                    });
                    result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)element, (TailType)TailTypes.noneType()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static <T extends PsiElement> T stripAnnotations(@NotNull T element) {
        if (element == null) {
            PySuperMethodCompletionContributor.$$$reportNull$$$0(0);
        }
        PsiElement result2 = element.copy();
        result2.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyAnnotation(@NotNull PyAnnotation node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                node.delete();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor$2", "visitPyAnnotation"));
            }
        });
        PsiElement psiElement = result2;
        if (psiElement == null) {
            PySuperMethodCompletionContributor.$$$reportNull$$$0(1);
        }
        return (T)psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stripAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stripAnnotations";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

