/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCandidateHolder
implements Comparable<ImportCandidateHolder> {
    private static final Logger LOG = Logger.getInstance(ImportCandidateHolder.class);
    @NotNull
    private final SmartPsiElementPointer<PsiNamedElement> myImportable;
    @Nullable
    private final SmartPsiElementPointer<PyImportElement> myImportElement;
    @NotNull
    private final SmartPsiElementPointer<PsiFileSystemItem> myFile;
    @Nullable
    private final QualifiedName myPath;
    @NotNull
    private final String myImportableName;
    @Nullable
    private final String myAsName;
    private final int myRelevance;

    public ImportCandidateHolder(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path2, @Nullable String asName) {
        if (importable == null) {
            ImportCandidateHolder.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ImportCandidateHolder.$$$reportNull$$$0(1);
        }
        if (importElement == null && path2 == null) {
            throw new IllegalArgumentException("Either an import path or an existing import should be provided for " + importable);
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)importable.getProject());
        this.myFile = pointerManager.createSmartPsiElementPointer((PsiElement)file);
        this.myImportable = pointerManager.createSmartPsiElementPointer((PsiElement)importable);
        this.myImportableName = PyUtil.getElementNameWithoutExtension(importable);
        assert (this.myImportableName != null);
        this.myImportElement = importElement != null ? pointerManager.createSmartPsiElementPointer((PsiElement)importElement) : null;
        this.myPath = path2;
        this.myAsName = asName;
        this.myRelevance = PyCompletionUtilsKt.computeCompletionWeight((PsiElement)importable, this.myImportableName, this.myPath, null, false);
        LOG.debug("Computed relevance for import item ", new Object[]{this.myImportableName, ": ", this.myRelevance});
    }

    public ImportCandidateHolder(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path2) {
        if (importable == null) {
            ImportCandidateHolder.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ImportCandidateHolder.$$$reportNull$$$0(3);
        }
        this(importable, file, importElement, path2, null);
    }

    @Nullable
    public PsiNamedElement getImportable() {
        return (PsiNamedElement)this.myImportable.getElement();
    }

    @NotNull
    public String getImportableName() {
        String string = this.myImportableName;
        if (string == null) {
            ImportCandidateHolder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement != null ? (PyImportElement)this.myImportElement.getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem getFile() {
        return (PsiFileSystemItem)this.myFile.getElement();
    }

    @Nullable
    public QualifiedName getPath() {
        return this.myPath;
    }

    @NotNull
    public static String getQualifiedName(@NotNull String name2, @Nullable QualifiedName importPath, @Nullable PyImportElement source) {
        if (name2 == null) {
            ImportCandidateHolder.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        if (source != null) {
            PsiElement parent = source.getParent();
            if (parent instanceof PyFromImportStatement) {
                sb.append(name2);
            } else {
                sb.append(source.getVisibleName()).append(".").append(name2);
            }
        } else {
            if (importPath != null && importPath.getComponentCount() > 0) {
                sb.append(importPath).append(".");
            }
            sb.append(name2);
        }
        String string = sb.toString();
        if (string == null) {
            ImportCandidateHolder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getPresentableText() {
        PyImportElement importElement = this.getImportElement();
        StringBuilder sb = new StringBuilder(ImportCandidateHolder.getQualifiedName(this.getImportableName(), this.myPath, importElement));
        PsiElement parent = null;
        if (importElement != null) {
            parent = importElement.getParent();
        }
        if (parent instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)parent;
            sb.append(" from ");
            sb.append(StringUtil.repeat((String)".", (int)fromImportStatement.getRelativeLevel()));
            PyReferenceExpression source = fromImportStatement.getImportSource();
            if (source != null) {
                sb.append(source.asQualifiedName());
            }
        }
        if (this.myAsName != null) {
            sb.append(" as ").append(this.myAsName);
        }
        String string = sb.toString();
        if (string == null) {
            ImportCandidateHolder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ImportCandidateHolder other) {
        if (other == null) {
            ImportCandidateHolder.$$$reportNull$$$0(8);
        }
        if (this.myImportElement != null && other.myImportElement == null) {
            return -1;
        }
        if (this.myImportElement == null && other.myImportElement != null) {
            return 1;
        }
        if (this.myAsName != null && other.myAsName == null) {
            return -1;
        }
        if (this.myAsName == null && other.myAsName != null) {
            return 1;
        }
        int comparedRelevance = Comparator.comparing(ImportCandidateHolder::getRelevance).reversed().compare(this, other);
        if (comparedRelevance != 0) {
            return comparedRelevance;
        }
        QualifiedName myLocalPath = this.getPath();
        QualifiedName otherPath = other.getPath();
        if (this.myImportElement != null) {
            PyImportElement myElement = (PyImportElement)this.myImportElement.getElement();
            PyImportElement otherElement = (PyImportElement)other.myImportElement.getElement();
            if (myElement != null && otherElement != null) {
                myLocalPath = myElement.getImportedQName();
                otherPath = otherElement.getImportedQName();
            }
        }
        return Comparing.compare((Comparable)myLocalPath, (Comparable)otherPath);
    }

    public int getRelevance() {
        return this.myRelevance;
    }

    @Nullable
    public String getAsName() {
        return this.myAsName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

