/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.mlcompletion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.mlcompletion.PyMlCompletionHelpers;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures;", "", "()V", "getElementImportPathFeatures", "Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures$ElementImportPathFeatures;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "getImportPopularityFeature", "", "locationPsi", "Lcom/intellij/psi/PsiElement;", "lookupString", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)Ljava/lang/Integer;", "ElementImportPathFeatures", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyImportCompletionFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyImportCompletionFeatures.kt\ncom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1774#2,4:35\n*S KotlinDebug\n*F\n+ 1 PyImportCompletionFeatures.kt\ncom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures\n*L\n24#1:35,4\n*E\n"})
public final class PyImportCompletionFeatures {
    @NotNull
    public static final PyImportCompletionFeatures INSTANCE = new PyImportCompletionFeatures();

    private PyImportCompletionFeatures() {
    }

    @Nullable
    public final ElementImportPathFeatures getElementImportPathFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        PsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        QualifiedName qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)psiElement2.getContainingFile());
        if (qualifiedName == null) {
            return null;
        }
        QualifiedName importPath = qualifiedName;
        PsiFile psiFile = location.getCompletionParameters().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile caretLocationFile = psiFile;
        boolean isImported = PyCompletionUtilsKt.hasImportsFrom(caretLocationFile, importPath);
        int numComponents = importPath.getComponentCount();
        List list = importPath.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponents(...)");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numPrivateComponents = n;
        return new ElementImportPathFeatures(isImported, numPrivateComponents, numComponents);
    }

    @Nullable
    public final Integer getImportPopularityFeature(@NotNull PsiElement locationPsi, @NotNull String lookupString) {
        Intrinsics.checkNotNullParameter((Object)locationPsi, (String)"locationPsi");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        if (!(locationPsi.getParent() instanceof PyReferenceExpression)) {
            return null;
        }
        if (!(locationPsi.getParent().getParent() instanceof PyImportElement)) {
            return null;
        }
        if (!(locationPsi.getParent().getParent().getParent() instanceof PyImportStatement)) {
            return null;
        }
        return PyMlCompletionHelpers.INSTANCE.getImportPopularity().get(lookupString);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/codeInsight/mlcompletion/PyImportCompletionFeatures$ElementImportPathFeatures;", "", "isImported", "", "numPrivateComponents", "", "numComponents", "(ZII)V", "()Z", "getNumComponents", "()I", "getNumPrivateComponents", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.python.community.impl"})
    public static final class ElementImportPathFeatures {
        private final boolean isImported;
        private final int numPrivateComponents;
        private final int numComponents;

        public ElementImportPathFeatures(boolean isImported, int numPrivateComponents, int numComponents) {
            this.isImported = isImported;
            this.numPrivateComponents = numPrivateComponents;
            this.numComponents = numComponents;
        }

        public final boolean isImported() {
            return this.isImported;
        }

        public final int getNumPrivateComponents() {
            return this.numPrivateComponents;
        }

        public final int getNumComponents() {
            return this.numComponents;
        }

        public final boolean component1() {
            return this.isImported;
        }

        public final int component2() {
            return this.numPrivateComponents;
        }

        public final int component3() {
            return this.numComponents;
        }

        @NotNull
        public final ElementImportPathFeatures copy(boolean isImported, int numPrivateComponents, int numComponents) {
            return new ElementImportPathFeatures(isImported, numPrivateComponents, numComponents);
        }

        public static /* synthetic */ ElementImportPathFeatures copy$default(ElementImportPathFeatures elementImportPathFeatures, boolean bl, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = elementImportPathFeatures.isImported;
            }
            if ((n3 & 2) != 0) {
                n = elementImportPathFeatures.numPrivateComponents;
            }
            if ((n3 & 4) != 0) {
                n2 = elementImportPathFeatures.numComponents;
            }
            return elementImportPathFeatures.copy(bl, n, n2);
        }

        @NotNull
        public String toString() {
            return "ElementImportPathFeatures(isImported=" + this.isImported + ", numPrivateComponents=" + this.numPrivateComponents + ", numComponents=" + this.numComponents + ")";
        }

        public int hashCode() {
            int n = this.isImported ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + Integer.hashCode(this.numPrivateComponents);
            result2 = result2 * 31 + Integer.hashCode(this.numComponents);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementImportPathFeatures)) {
                return false;
            }
            ElementImportPathFeatures elementImportPathFeatures = (ElementImportPathFeatures)other;
            if (this.isImported != elementImportPathFeatures.isImported) {
                return false;
            }
            if (this.numPrivateComponents != elementImportPathFeatures.numPrivateComponents) {
                return false;
            }
            return this.numComponents == elementImportPathFeatures.numComponents;
        }
    }
}

