/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringTypeReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    @Nullable
    private PyType myType;
    @NotNull
    private final TextRange myFullRange;
    @Nullable
    private final PyImportElement myImportElement;

    public DocStringTypeReference(PsiElement element, TextRange range, @NotNull TextRange fullRange, @Nullable PyType type2, @Nullable PyImportElement importElement) {
        if (fullRange == null) {
            DocStringTypeReference.$$$reportNull$$$0(0);
        }
        super(element, range);
        this.myFullRange = fullRange;
        this.myType = type2;
        this.myImportElement = importElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DocStringTypeReference.$$$reportNull$$$0(1);
        }
        if (element.equals(this.resolve())) {
            return element;
        }
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof PyStringLiteralExpression) {
            PyClass cls;
            QualifiedName qname;
            PyStringLiteralExpression e = (PyStringLiteralExpression)psiElement;
            if (element instanceof PyClass && (qname = QualifiedNameFinder.findCanonicalImportPath(cls = (PyClass)element, element)) != null) {
                qname = qname.append(cls.getName());
                this.myType = new PyClassTypeImpl(cls, false);
                return ElementManipulators.handleContentChange((PsiElement)e, (TextRange)this.myFullRange, (String)qname.toString());
            }
        }
        return null;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            DocStringTypeReference.$$$reportNull$$$0(2);
        }
        newElementName = StringUtil.trimEnd((String)newElementName, (String)".py");
        return super.handleElementRename(newElementName);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            DocStringTypeReference.$$$reportNull$$$0(3);
        }
        if (this.myType instanceof PyImportedModuleType) {
            return element.equals(PyUtil.turnInitIntoDir(this.resolve()));
        }
        return super.isReferenceTo(element);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PyDocStringOwner result2 = null;
        ResolveResultList results = new ResolveResultList();
        if (this.myType instanceof PyClassType) {
            result2 = ((PyClassType)this.myType).getPyClass();
        } else if (this.myType instanceof PyImportedModuleType) {
            result2 = ((PyImportedModuleType)this.myType).getImportedModule().resolve();
        } else if (this.myType instanceof PyModuleType) {
            result2 = ((PyModuleType)this.myType).getModule();
        }
        if (result2 != null) {
            if (this.myImportElement != null) {
                results.add(new ImportedResolveResult((PsiElement)result2, 0, this.myImportElement));
            } else {
                results.poke((PsiElement)result2, 0);
            }
        }
        ResolveResult[] resolveResultArray = results.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            DocStringTypeReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            DocStringTypeReference.$$$reportNull$$$0(5);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public List<Object> collectTypeVariants() {
        PsiFile file = this.myElement.getContainingFile();
        ArrayList variants = Lists.newArrayList((Object[])new Object[]{"str", "int", "basestring", "bool", "buffer", "bytearray", "complex", "dict", "tuple", "enumerate", "file", "float", "frozenset", "list", "long", "set", "object"});
        if (file instanceof PyFile) {
            variants.addAll(((PyFile)file).getTopLevelClasses());
            List<PyFromImportStatement> fromImports = ((PyFile)file).getFromImports();
            for (PyFromImportStatement fromImportStatement : fromImports) {
                PyImportElement[] elements;
                for (PyImportElement element : elements = fromImportStatement.getImportElements()) {
                    PyType type2;
                    PyReferenceExpression referenceExpression = element.getImportReferenceExpression();
                    if (referenceExpression == null || !((type2 = TypeEvalContext.userInitiated(file.getProject(), (PsiFile)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)file)).getType(referenceExpression)) instanceof PyClassType)) continue;
                    variants.add(((PyClassType)type2).getPyClass());
                }
            }
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            DocStringTypeReference.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullRange";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringTypeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringTypeReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

