/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "PyAddAwaitCallForCoroutineFix", "Visitor", "intellij.python.psi.impl"})
public final class PyAsyncCallInspection
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> ignoreReturnedType = CollectionsKt.listOf((Object)"asyncio.tasks.Task");
    @NotNull
    private static final List<String> ignoreBuiltinFunctions;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    static {
        Object[] objectArray = new String[]{"asyncio.events.AbstractEventLoop.run_in_executor", "asyncio.tasks.ensure_future", "asyncio.ensure_future"};
        ignoreBuiltinFunctions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion;", "", "()V", "ignoreBuiltinFunctions", "", "", "getIgnoreBuiltinFunctions", "()Ljava/util/List;", "ignoreReturnedType", "getIgnoreReturnedType", "getCalledCoroutineName", "callExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "isOuterFunctionAsync", "", "node", "Lcom/jetbrains/python/psi/PyExpression;", "isOuterFunctionCoroutine", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "AwaitableType", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getIgnoreReturnedType() {
            return ignoreReturnedType;
        }

        @NotNull
        public final List<String> getIgnoreBuiltinFunctions() {
            return ignoreBuiltinFunctions;
        }

        private final String getCalledCoroutineName(PyCallExpression callExpression, PyResolveContext resolveContext) {
            PyExpression pyExpression = callExpression.getCallee();
            PyReferenceExpression pyReferenceExpression = pyExpression instanceof PyReferenceExpression ? (PyReferenceExpression)pyExpression : null;
            if (pyReferenceExpression == null) {
                return null;
            }
            PyReferenceExpression callee = pyReferenceExpression;
            List<PyCallable> list = callExpression.multiResolveCalleeFunction(resolveContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCalleeFunction(...)");
            Object object = CollectionsKt.firstOrNull(list);
            PyFunction pyFunction = object instanceof PyFunction ? (PyFunction)object : null;
            if (pyFunction == null) {
                return null;
            }
            PyFunction function = pyFunction;
            return PyUtil.isInitMethod(function) ? callee.getName() : function.getName();
        }

        public final boolean isOuterFunctionAsync(@NotNull PyExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            PyFunction pyFunction = scopeOwner instanceof PyFunction ? (PyFunction)scopeOwner : null;
            return pyFunction != null ? pyFunction.isAsync() : false;
        }

        private final boolean isOuterFunctionCoroutine(PyExpression node, TypeEvalContext typeEvalContext) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            PyFunction pyFunction = scopeOwner instanceof PyFunction ? (PyFunction)scopeOwner : null;
            if (pyFunction == null) {
                return false;
            }
            PyFunction pyFunction2 = pyFunction;
            return PyKnownDecoratorUtil.hasGeneratorBasedCoroutineDecorator(pyFunction2, typeEvalContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "", "(Ljava/lang/String;I)V", "AWAITABLE", "COROUTINE", "intellij.python.psi.impl"})
        public static final class AwaitableType
        extends Enum<AwaitableType> {
            public static final /* enum */ AwaitableType AWAITABLE = new AwaitableType();
            public static final /* enum */ AwaitableType COROUTINE = new AwaitableType();
            private static final /* synthetic */ AwaitableType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static AwaitableType[] values() {
                return (AwaitableType[])$VALUES.clone();
            }

            public static AwaitableType valueOf(String value) {
                return Enum.valueOf(AwaitableType.class, value);
            }

            @NotNull
            public static EnumEntries<AwaitableType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = awaitableTypeArray = new AwaitableType[]{AwaitableType.AWAITABLE, AwaitableType.COROUTINE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$PyAddAwaitCallForCoroutineFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "type", "Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "(Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;)V", "getType", "()Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Companion$AwaitableType;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.python.psi.impl"})
    private static final class PyAddAwaitCallForCoroutineFix
    implements LocalQuickFix {
        @NotNull
        private final Companion.AwaitableType type;

        public PyAddAwaitCallForCoroutineFix(@NotNull Companion.AwaitableType type2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            this.type = type2;
        }

        @NotNull
        public final Companion.AwaitableType getType() {
            return this.type;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.coroutine.is.not.awaited", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement instanceof PyExpressionStatement) {
                StringBuilder sb = new StringBuilder();
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 1: {
                        sb.append("async def foo():\n    ").append("await").append(" ").append(((PyExpressionStatement)psiElement).getText());
                        break;
                    }
                    case 2: {
                        sb.append("def foo():\n    ").append("yield").append(" ").append("from").append(" ").append(((PyExpressionStatement)psiElement).getText());
                    }
                }
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyFunction pyFunction = generator.createFromText(LanguageLevel.forElement(psiElement), PyFunction.class, sb.toString());
                Intrinsics.checkNotNullExpressionValue((Object)pyFunction, (String)"createFromText(...)");
                PyFunction function = pyFunction;
                PyStatement[] pyStatementArray = function.getStatementList().getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)pyStatementArray, (String)"getStatements(...)");
                PyStatement awaitedStatement = (PyStatement)ArraysKt.firstOrNull((Object[])pyStatementArray);
                if (awaitedStatement != null) {
                    PyReplaceExpressionUtil.replaceExpression(psiElement, (PsiElement)awaitedStatement);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Companion.AwaitableType.values().length];
                try {
                    nArray[Companion.AwaitableType.AWAITABLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Companion.AwaitableType.COROUTINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyAsyncCallInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "isAwaitableCall", "", "callExpr", "Lcom/jetbrains/python/psi/PyCallExpression;", "isIgnored", "visitPyExpressionStatement", "", "node", "Lcom/jetbrains/python/psi/PyExpressionStatement;", "intellij.python.psi.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyExpressionStatement(@NotNull PyExpressionStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression pyExpression = node.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getExpression(...)");
            PyExpression expr = pyExpression;
            if (expr instanceof PyCallExpression && this.isAwaitableCall((PyCallExpression)expr) && !this.isIgnored((PyCallExpression)expr)) {
                Companion.AwaitableType awaitableType;
                if (Companion.isOuterFunctionAsync(expr)) {
                    awaitableType = Companion.AwaitableType.AWAITABLE;
                } else {
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (Companion.isOuterFunctionCoroutine(expr, typeEvalContext)) {
                        awaitableType = Companion.AwaitableType.COROUTINE;
                    } else {
                        return;
                    }
                }
                Companion.AwaitableType awaitableType2 = awaitableType;
                PyCallExpression pyCallExpression = (PyCallExpression)expr;
                PyResolveContext pyResolveContext = this.getResolveContext();
                Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"getResolveContext(...)");
                String string = Companion.getCalledCoroutineName(pyCallExpression, pyResolveContext);
                if (string == null) {
                    return;
                }
                String functionName = string;
                Object[] objectArray = new Object[]{functionName};
                String string2 = PyPsiBundle.message("INSP.NAME.coroutine.is.not.awaited", objectArray);
                objectArray = new LocalQuickFix[]{new PyAddAwaitCallForCoroutineFix(awaitableType2)};
                this.registerProblem((PsiElement)node, string2, (LocalQuickFix[])objectArray);
            }
        }

        private final boolean isIgnored(PyCallExpression callExpr) {
            String typeQName;
            PyType pyType = this.myTypeEvalContext.getType(callExpr);
            if (pyType == null) {
                return true;
            }
            PyType type2 = pyType;
            String string = typeQName = type2 instanceof PyClassLikeType ? ((PyClassLikeType)type2).getClassQName() : null;
            if (CollectionsKt.contains((Iterable)Companion.getIgnoreReturnedType(), (Object)typeQName)) {
                return true;
            }
            List<PyCallable> list = callExpr.multiResolveCalleeFunction(this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCalleeFunction(...)");
            PyCallable pyCallable = (PyCallable)CollectionsKt.firstOrNull(list);
            String qualifiedName = pyCallable != null ? pyCallable.getQualifiedName() : null;
            return CollectionsKt.contains((Iterable)Companion.getIgnoreBuiltinFunctions(), (Object)qualifiedName);
        }

        private final boolean isAwaitableCall(PyCallExpression callExpr) {
            PyType pyType = this.myTypeEvalContext.getType(callExpr);
            if (pyType == null) {
                return false;
            }
            PyType type2 = pyType;
            return PyABCUtil.isSubtype(type2, "Awaitable", this.myTypeEvalContext) || PyTypingTypeProvider.isGenerator(type2) && PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine(callExpr, this.getResolveContext(), this.myTypeEvalContext);
        }
    }
}

