/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.inspections.PyBaseDocstringInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyIncorrectDocstringInspection
extends PyBaseDocstringInspection {
    @Override
    @NotNull
    public PyBaseDocstringInspection.Visitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(1);
        }
        return new PyBaseDocstringInspection.Visitor(holder, PyInspectionVisitor.getContext(session)){

            @Override
            protected void checkDocString(@NotNull PyDocStringOwner node) {
                PyStringLiteralExpression docstringExpr;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((docstringExpr = node.getDocStringExpression()) != null) {
                    this.checkParameters(node, docstringExpr);
                }
            }

            private void checkParameters(@NotNull PyDocStringOwner pyDocStringOwner, @NotNull PyStringLiteralExpression node) {
                StructuredDocString docString;
                if (pyDocStringOwner == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((docString = DocStringUtil.parseDocString(node)) instanceof PlainDocString) {
                    return;
                }
                if (pyDocStringOwner instanceof PyFunction) {
                    List<Substring> unexpectedParams;
                    PyParameter[] realParams = ((PyFunction)pyDocStringOwner).getParameterList().getParameters();
                    List<PyNamedParameter> missingParams = PyIncorrectDocstringInspection.getMissingParams(docString, realParams);
                    if (!missingParams.isEmpty()) {
                        for (PyNamedParameter param : missingParams) {
                            this.registerProblem((PsiElement)param, PyPsiBundle.message("INSP.missing.parameter.in.docstring", param.getName()), new DocstringQuickFix(param, null));
                        }
                    }
                    if (!(unexpectedParams = PyIncorrectDocstringInspection.getUnexpectedParams(docString, realParams)).isEmpty()) {
                        for (Substring param : unexpectedParams) {
                            ProblemsHolder holder = this.getHolder();
                            if (holder == null) continue;
                            holder.registerProblem((PsiElement)node, param.getTextRange(), PyPsiBundle.message("INSP.unexpected.parameter.in.docstring", param), new LocalQuickFix[]{new DocstringQuickFix(null, param.getValue())});
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pyDocStringOwner";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyIncorrectDocstringInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkDocString";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkParameters";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static List<PyNamedParameter> getMissingParams(@NotNull StructuredDocString docString, PyParameter @NotNull [] realParams) {
        if (docString == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(2);
        }
        if (realParams == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(3);
        }
        ArrayList<PyNamedParameter> missing = new ArrayList<PyNamedParameter>();
        List<String> docStringParameters = docString.getParameters();
        if (docStringParameters.isEmpty()) {
            List<PyNamedParameter> list = Collections.emptyList();
            if (list == null) {
                PyIncorrectDocstringInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        for (PyParameter p : realParams) {
            PyNamedParameter named = PyUtil.as(p, PyNamedParameter.class);
            if (p.isSelf() || named == null || named.isPositionalContainer() || named.isKeywordContainer() || docStringParameters.contains(p.getName())) continue;
            missing.add((PyNamedParameter)p);
        }
        ArrayList<PyNamedParameter> arrayList = missing;
        if (arrayList == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<Substring> getUnexpectedParams(@NotNull StructuredDocString docString, PyParameter @NotNull [] realParams) {
        if (docString == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(6);
        }
        if (realParams == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(7);
        }
        HashMap unexpected = Maps.newHashMap();
        for (Substring s : docString.getParameterSubstrings()) {
            unexpected.put(s.toString(), s);
        }
        for (PyParameter p : realParams) {
            unexpected.remove(p.getName());
        }
        ArrayList arrayList = Lists.newArrayList(unexpected.values());
        if (arrayList == null) {
            PyIncorrectDocstringInspection.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realParams";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyIncorrectDocstringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyIncorrectDocstringInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingParams";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnexpectedParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMissingParams";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUnexpectedParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

