/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCallSuperQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.add.super", new Object[0]);
        if (string == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        boolean addSelfToCall;
        PyFunction problemFunction;
        if (project == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PyFunction.class)) == null) {
            return;
        }
        StringBuilder superCall = new StringBuilder();
        PyClass klass = problemFunction.getContainingClass();
        if (klass == null) {
            return;
        }
        PyClass[] superClasses = klass.getSuperClasses(null);
        if (superClasses.length == 0) {
            return;
        }
        PyClass superClass = superClasses[0];
        PyFunction superInit = superClass.findMethodByName("__init__", true, null);
        if (superInit == null) {
            return;
        }
        ParametersInfo origInfo = new ParametersInfo(problemFunction.getParameterList());
        ParametersInfo superInfo = new ParametersInfo(superInit.getParameterList());
        if (klass.isNewStyleClass(null)) {
            addSelfToCall = false;
            if (LanguageLevel.forElement(klass).isPy3K()) {
                superCall.append("super().__init__(");
            } else {
                superCall.append("super(").append(klass.getName()).append(", ").append(AddCallSuperQuickFix.getSelfParameterName(origInfo)).append(").__init__(");
            }
        } else {
            addSelfToCall = true;
            superCall.append(superClass.getName()).append(".__init__(");
        }
        Couple<List<String>> couple = AddCallSuperQuickFix.buildNewFunctionParamsAndSuperInitCallArgs(origInfo, superInfo, addSelfToCall);
        StringBuilder newParameters = new StringBuilder("(");
        StringUtil.join((Collection)((Collection)couple.getFirst()), (String)", ", (StringBuilder)newParameters);
        newParameters.append(")");
        StringUtil.join((Collection)((Collection)couple.getSecond()), (String)", ", (StringBuilder)superCall);
        superCall.append(")");
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        LanguageLevel languageLevel = LanguageLevel.forElement(problemFunction);
        PyStatement callSuperStatement = generator.createFromText(languageLevel, PyStatement.class, superCall.toString());
        PyParameterList newParameterList = generator.createParameterList(languageLevel, newParameters.toString());
        problemFunction.getParameterList().replace((PsiElement)newParameterList);
        PyStatementList statementList = problemFunction.getStatementList();
        PyPsiRefactoringUtil.addElementToStatementList((PsiElement)callSuperStatement, statementList, true);
        PyPsiUtils.removeRedundantPass(statementList);
    }

    @NotNull
    private static String getSelfParameterName(@NotNull ParametersInfo info) {
        PyParameter selfParameter;
        if (info == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(3);
        }
        if ((selfParameter = info.getSelfParameter()) == null) {
            return "self";
        }
        String string = StringUtil.defaultIfEmpty((String)selfParameter.getName(), (String)"self");
        if (string == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static Couple<List<String>> buildNewFunctionParamsAndSuperInitCallArgs(@NotNull ParametersInfo origInfo, @NotNull ParametersInfo superInfo, boolean addSelfToCall) {
        Object tupleParam;
        if (origInfo == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(5);
        }
        if (superInfo == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(6);
        }
        ArrayList<String> newFunctionParams = new ArrayList<String>();
        ArrayList<Object> superCallArgs = new ArrayList<Object>();
        PyParameter selfParameter = origInfo.getSelfParameter();
        if (selfParameter != null && StringUtil.isNotEmpty((String)selfParameter.getName())) {
            newFunctionParams.add(selfParameter.getText());
        } else {
            newFunctionParams.add("self");
        }
        if (addSelfToCall) {
            superCallArgs.add(AddCallSuperQuickFix.getSelfParameterName(origInfo));
        }
        for (PyParameter param : origInfo.getRequiredParameters()) {
            newFunctionParams.add(param.getText());
        }
        for (PyParameter param : superInfo.getRequiredParameters()) {
            tupleParam = param.getAsTuple();
            if (tupleParam != null) {
                List<String> uniqueNames = AddCallSuperQuickFix.collectParameterNames((PyParameter)tupleParam);
                boolean hasDuplicates = uniqueNames.removeAll(origInfo.getAllParameterNames());
                if (hasDuplicates) {
                    newFunctionParams.addAll(uniqueNames);
                } else {
                    newFunctionParams.add(param.getText());
                }
                superCallArgs.add(param.getText());
                continue;
            }
            if (!origInfo.getAllParameterNames().contains(param.getName())) {
                newFunctionParams.add(param.getText());
            }
            superCallArgs.add(param.getName());
        }
        for (PyParameter param : origInfo.getOptionalParameters()) {
            newFunctionParams.add(param.getText());
        }
        for (PyParameter param : superInfo.getOptionalParameters()) {
            tupleParam = param.getAsTuple();
            if (tupleParam != null) {
                if (!origInfo.getAllParameterNames().containsAll(AddCallSuperQuickFix.collectParameterNames((PyParameter)tupleParam))) continue;
                String paramText = tupleParam.getText();
                PsiElement equalSign = PyPsiUtils.getFirstChildOfType((PsiElement)param, PyTokenTypes.EQ);
                if (equalSign == null) continue;
                superCallArgs.add(paramText.substring(0, equalSign.getStartOffsetInParent()).trim());
                continue;
            }
            if (!origInfo.getAllParameterNames().contains(param.getName())) continue;
            superCallArgs.add(param.getName());
        }
        PyParameter starredParam = null;
        if (origInfo.getPositionalContainerParameter() != null) {
            starredParam = origInfo.getPositionalContainerParameter();
        } else if (superInfo.getPositionalContainerParameter() != null) {
            starredParam = superInfo.getPositionalContainerParameter();
        } else if (origInfo.getSingleStarParameter() != null) {
            starredParam = origInfo.getSingleStarParameter();
        } else if (superInfo.getSingleStarParameter() != null) {
            starredParam = superInfo.getSingleStarParameter();
        }
        if (starredParam != null) {
            newFunctionParams.add(starredParam.getText());
            if (superInfo.getPositionalContainerParameter() != null) {
                superCallArgs.add("*" + starredParam.getName());
            }
        }
        boolean newSignatureContainsKeywordParams = false;
        for (PyParameter param : origInfo.getRequiredKeywordOnlyParameters()) {
            newFunctionParams.add(param.getText());
            newSignatureContainsKeywordParams = true;
        }
        for (PyParameter param : superInfo.getRequiredKeywordOnlyParameters()) {
            if (!origInfo.getAllParameterNames().contains(param.getName())) {
                newFunctionParams.add(param.getText());
                newSignatureContainsKeywordParams = true;
            }
            superCallArgs.add(param.getName() + "=" + param.getName());
        }
        for (PyParameter param : origInfo.getOptionalKeywordOnlyParameters()) {
            newFunctionParams.add(param.getText());
            newSignatureContainsKeywordParams = true;
        }
        if (starredParam instanceof PySingleStarParameter && !newSignatureContainsKeywordParams) {
            newFunctionParams.remove(newFunctionParams.size() - 1);
        }
        for (PyParameter param : superInfo.getOptionalKeywordOnlyParameters()) {
            if (!origInfo.getAllParameterNames().contains(param.getName())) continue;
            superCallArgs.add(param.getName() + "=" + param.getName());
        }
        PyParameter doubleStarredParam = null;
        if (origInfo.getKeywordContainerParameter() != null) {
            doubleStarredParam = origInfo.getKeywordContainerParameter();
        } else if (superInfo.getKeywordContainerParameter() != null) {
            doubleStarredParam = superInfo.getKeywordContainerParameter();
        }
        if (doubleStarredParam != null) {
            newFunctionParams.add(doubleStarredParam.getText());
            if (superInfo.getKeywordContainerParameter() != null) {
                superCallArgs.add("**" + doubleStarredParam.getName());
            }
        }
        Couple couple = Couple.of(newFunctionParams, superCallArgs);
        if (couple == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(7);
        }
        return couple;
    }

    @NotNull
    private static List<String> collectParameterNames(@NotNull PyParameter param) {
        if (param == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(8);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        AddCallSuperQuickFix.collectParameterNames(param, result2);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void collectParameterNames(@NotNull PyParameter param, @NotNull Collection<String> acc) {
        PyTupleParameter tupleParam;
        if (param == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(10);
        }
        if (acc == null) {
            AddCallSuperQuickFix.$$$reportNull$$$0(11);
        }
        if ((tupleParam = param.getAsTuple()) != null) {
            for (PyParameter subParam : tupleParam.getContents()) {
                AddCallSuperQuickFix.collectParameterNames(subParam, acc);
            }
        } else {
            ContainerUtil.addIfNotNull(acc, (Object)param.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superInfo";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfParameterName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewFunctionParamsAndSuperInitCallArgs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParameterNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelfParameterName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildNewFunctionParamsAndSuperInitCallArgs";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectParameterNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static class ParametersInfo {
        private final PyParameter mySelfParam;
        private final List<PyParameter> myRequiredParams;
        private final List<PyParameter> myOptionalParams;
        private final PyParameter myPositionalContainerParam;
        private final PyParameter mySingleStarParam;
        private final List<PyParameter> myRequiredKwOnlyParams;
        private final List<PyParameter> myOptionalKwOnlyParams;
        private final PyParameter myKeywordContainerParam;
        private final Set<String> myAllParameterNames;

        ParametersInfo(@NotNull PyParameterList parameterList) {
            if (parameterList == null) {
                ParametersInfo.$$$reportNull$$$0(0);
            }
            this.myRequiredParams = new ArrayList<PyParameter>();
            this.myOptionalParams = new ArrayList<PyParameter>();
            this.myRequiredKwOnlyParams = new ArrayList<PyParameter>();
            this.myOptionalKwOnlyParams = new ArrayList<PyParameter>();
            this.myAllParameterNames = new LinkedHashSet<String>();
            PyParameter positionalContainer = null;
            PyParameter singleStarParam = null;
            PyParameter keywordContainer = null;
            PyParameter selfParam = null;
            for (PyParameter param : parameterList.getParameters()) {
                this.myAllParameterNames.addAll(AddCallSuperQuickFix.collectParameterNames(param));
                if (param.isSelf()) {
                    selfParam = param;
                    continue;
                }
                if (param instanceof PySingleStarParameter) {
                    singleStarParam = param;
                    continue;
                }
                if (param.getAsNamed() != null && param.getAsNamed().isKeywordContainer()) {
                    keywordContainer = param;
                    continue;
                }
                if (param.getAsNamed() != null && param.getAsNamed().isPositionalContainer()) {
                    positionalContainer = param;
                    continue;
                }
                if (param.getAsNamed() == null || !param.getAsNamed().isKeywordOnly()) {
                    if (param.hasDefaultValue()) {
                        this.myOptionalParams.add(param);
                        continue;
                    }
                    this.myRequiredParams.add(param);
                    continue;
                }
                if (param.hasDefaultValue()) {
                    this.myOptionalKwOnlyParams.add(param);
                    continue;
                }
                this.myRequiredKwOnlyParams.add(param);
            }
            this.mySelfParam = selfParam;
            this.myPositionalContainerParam = positionalContainer;
            this.mySingleStarParam = singleStarParam;
            this.myKeywordContainerParam = keywordContainer;
        }

        @Nullable
        public PyParameter getSelfParameter() {
            return this.mySelfParam;
        }

        @NotNull
        public List<PyParameter> getRequiredParameters() {
            List<PyParameter> list = Collections.unmodifiableList(this.myRequiredParams);
            if (list == null) {
                ParametersInfo.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<PyParameter> getOptionalParameters() {
            List<PyParameter> list = Collections.unmodifiableList(this.myOptionalParams);
            if (list == null) {
                ParametersInfo.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        public PyParameter getPositionalContainerParameter() {
            return this.myPositionalContainerParam;
        }

        @Nullable
        public PyParameter getSingleStarParameter() {
            return this.mySingleStarParam;
        }

        @NotNull
        public List<PyParameter> getRequiredKeywordOnlyParameters() {
            List<PyParameter> list = Collections.unmodifiableList(this.myRequiredKwOnlyParams);
            if (list == null) {
                ParametersInfo.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public List<PyParameter> getOptionalKeywordOnlyParameters() {
            List<PyParameter> list = Collections.unmodifiableList(this.myOptionalKwOnlyParams);
            if (list == null) {
                ParametersInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        public PyParameter getKeywordContainerParameter() {
            return this.myKeywordContainerParam;
        }

        @NotNull
        public Set<String> getAllParameterNames() {
            Set<String> set = Collections.unmodifiableSet(this.myAllParameterNames);
            if (set == null) {
                ParametersInfo.$$$reportNull$$$0(5);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterList";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix$ParametersInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix$ParametersInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequiredParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionalParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequiredKeywordOnlyParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionalKeywordOnlyParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllParameterNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

