/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.inspections.quickfix.PyQuickFixUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocstringQuickFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    private final SmartPsiElementPointer<PyNamedParameter> myMissingParam;
    private final String myUnexpectedParamName;

    public DocstringQuickFix(@Nullable PyNamedParameter missing, @Nullable String unexpectedParamName) {
        this.myMissingParam = missing != null ? SmartPointerManager.getInstance((Project)missing.getProject()).createSmartPsiElementPointer((PsiElement)missing) : null;
        this.myUnexpectedParamName = unexpectedParamName;
    }

    @NotNull
    public String getName() {
        if (this.myMissingParam != null) {
            PyNamedParameter param = (PyNamedParameter)this.myMissingParam.getElement();
            if (param == null) {
                throw new IncorrectOperationException("Parameter was invalidates before quickfix is called");
            }
            String string = PyPsiBundle.message("QFIX.docstring.add.parameter", param.getName());
            if (string == null) {
                DocstringQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.myUnexpectedParamName != null) {
            String string = PyPsiBundle.message("QFIX.docstring.remove.parameter", this.myUnexpectedParamName);
            if (string == null) {
                DocstringQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = PyPsiBundle.message("QFIX.docstring.insert.stub", new Object[0]);
        if (string == null) {
            DocstringQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.docstring", new Object[0]);
        if (string == null) {
            DocstringQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyDocStringOwner docStringOwner;
        if (project == null) {
            DocstringQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            DocstringQuickFix.$$$reportNull$$$0(5);
        }
        if ((docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), PyDocStringOwner.class)) == null) {
            return;
        }
        PyStringLiteralExpression docStringExpression = docStringOwner.getDocStringExpression();
        if (docStringExpression == null && this.myMissingParam == null && this.myUnexpectedParamName == null) {
            DocstringQuickFix.addEmptyDocstring(docStringOwner);
            return;
        }
        if (docStringExpression != null) {
            PyDocstringGenerator generator = PyDocstringGenerator.forDocStringOwner(docStringOwner);
            if (this.myMissingParam != null) {
                PyNamedParameter param = (PyNamedParameter)this.myMissingParam.getElement();
                if (param != null) {
                    generator.withParam(param);
                }
            } else if (this.myUnexpectedParamName != null) {
                generator.withoutParam(this.myUnexpectedParamName.trim());
            }
            generator.buildAndInsert();
        }
    }

    private static void addEmptyDocstring(@NotNull PyDocStringOwner docStringOwner) {
        if (docStringOwner == null) {
            DocstringQuickFix.$$$reportNull$$$0(6);
        }
        if (docStringOwner instanceof PyFunction || docStringOwner instanceof PyClass && ((PyClass)docStringOwner).findInitOrNew(false, null) != null) {
            DocstringQuickFix.doGenerateDocstring(docStringOwner, PyQuickFixUtil.getEditor((PsiElement)docStringOwner));
        }
    }

    public static void doGenerateDocstring(@NotNull PyDocStringOwner docStringOwner, @Nullable Editor editor2) {
        PyDocstringGenerator docstringGenerator;
        PyStringLiteralExpression updated;
        if (docStringOwner == null) {
            DocstringQuickFix.$$$reportNull$$$0(7);
        }
        if ((updated = (docstringGenerator = PyDocstringGenerator.forDocStringOwner(docStringOwner).withInferredParameters(false).addFirstEmptyLine()).buildAndInsert().getDocStringExpression()) != null && editor2 != null) {
            int offset = updated.getTextOffset();
            editor2.getCaretModel().moveToOffset(offset);
            editor2.getCaretModel().moveCaretRelatively(0, 1, false, false, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/DocstringQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/DocstringQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyDocstring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDocstring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

