/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PatternParsing;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected SyntaxTreeBuilder myBuilder;
    private static final Logger LOG = Logger.getInstance(Parsing.class);

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    @NotNull
    public PatternParsing getPatternParser() {
        PatternParsing patternParsing = this.getParsingContext().getPatternParser();
        if (patternParsing == null) {
            Parsing.$$$reportNull$$$0(0);
        }
        return patternParsing;
    }

    protected boolean checkMatches(IElementType token, @NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            Parsing.$$$reportNull$$$0(1);
        }
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip(IElementType ... validSuccessiveTokens) {
        if (validSuccessiveTokens == null) {
            Parsing.$$$reportNull$$$0(2);
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        SyntaxTreeBuilder.Marker nameExpected = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && !this.atAnyOfTokens(validSuccessiveTokens)) {
            this.myBuilder.advanceLexer();
        }
        nameExpected.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        LOG.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        if (tokenType == null) {
            Parsing.$$$reportNull$$$0(3);
        }
        if (tokenText == null) {
            Parsing.$$$reportNull$$$0(4);
        }
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType currentTokenType = this.myBuilder.getTokenType();
        for (IElementType tokenType : tokenTypes) {
            if (currentTokenType != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean atAnyOfTokens(@NotNull TokenSet tokenTypes) {
        if (tokenTypes == null) {
            Parsing.$$$reportNull$$$0(5);
        }
        return tokenTypes.contains(this.myBuilder.getTokenType());
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected void advanceAsync(boolean falseAsync) {
        if (falseAsync) {
            Parsing.advanceError(this.myBuilder, PyParsingBundle.message("PARSE.async.keyword.not.expected.here", new Object[0]));
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    protected static void advanceIdentifierLike(@NotNull SyntaxTreeBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(6);
        }
        if (Parsing.isFalseIdentifier(builder)) {
            String tokenText = builder.getTokenText();
            Parsing.advanceError(builder, PyParsingBundle.message("PARSE.keyword.cannot.be.used.as.identifier.py2", tokenText));
        } else {
            builder.advanceLexer();
        }
    }

    protected static void advanceError(@NotNull SyntaxTreeBuilder builder, @NotNull @NlsContexts.ParsingError String message) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(7);
        }
        if (message == null) {
            Parsing.$$$reportNull$$$0(8);
        }
        SyntaxTreeBuilder.Marker err = builder.mark();
        builder.advanceLexer();
        err.error(message);
    }

    protected static boolean isIdentifier(@NotNull SyntaxTreeBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(9);
        }
        return builder.getTokenType() == PyTokenTypes.IDENTIFIER || Parsing.isFalseIdentifier(builder);
    }

    private static boolean isFalseIdentifier(@NotNull SyntaxTreeBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(10);
        }
        return builder.getTokenType() == PyTokenTypes.EXEC_KEYWORD || builder.getTokenType() == PyTokenTypes.PRINT_KEYWORD;
    }

    protected static void buildTokenElement(IElementType type2, SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker marker = builder.mark();
        Parsing.advanceIdentifierLike(builder);
        marker.done(type2);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/parsing/Parsing";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validSuccessiveTokens";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenTypes";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/parsing/Parsing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkMatches";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseIdentifierOrSkip";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "atToken";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "atAnyOfTokens";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "advanceIdentifierLike";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "advanceError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFalseIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

