/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.inline;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyRefactoringUiService;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionHandler;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionHandler$hasStarArgs$;
import com.jetbrains.python.refactoring.inline.PyInlineFunctionProcessor;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/refactoring/inline/PyInlineFunctionHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "checkInterruptsControlFlow", "ifStatement", "Lcom/jetbrains/python/psi/PyIfStatement;", "cache", "", "checkLastStatement", "statementList", "Lcom/jetbrains/python/psi/PyStatementList;", "hasDecorators", "function", "Lcom/jetbrains/python/psi/PyFunction;", "hasNestedFunction", "hasNonExhaustiveIfs", "hasReferencesToSelf", "hasStarArgs", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledForLanguage", "l", "Lcom/intellij/lang/Language;", "isOverridden", "isSpecialMethod", "isUnderSkeletonDir", "overridesMethod", "Companion", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyInlineFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyInlineFunctionHandler.kt\ncom/jetbrains/python/refactoring/inline/PyInlineFunctionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,172:1\n1747#2,3:173\n1747#2,3:183\n1247#3,2:176\n473#3:180\n1247#3,2:181\n13309#4,2:178\n*S KotlinDebug\n*F\n+ 1 PyInlineFunctionHandler.kt\ncom/jetbrains/python/refactoring/inline/PyInlineFunctionHandler\n*L\n85#1:173,3\n147#1:183,3\n102#1:176,2\n142#1:180\n143#1:181,2\n113#1:178,2\n*E\n"})
public final class PyInlineFunctionHandler
extends InlineActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String REFACTORING_ID = "refactoring.inlineMethod";

    public boolean isEnabledForLanguage(@Nullable Language l) {
        return l instanceof PythonLanguage;
    }

    public boolean canInlineElement(@Nullable PsiElement element) {
        if (element instanceof PyFunction) {
            Object object;
            if (((PyFunction)element).getContainingFile() instanceof PyiFile) {
                PsiElement psiElement = PyiUtil.getOriginalElement((PyElement)element);
                object = psiElement != null ? psiElement.getContainingFile() : null;
            } else {
                object = ((PyFunction)element).getContainingFile();
            }
            PsiFile containingFile = object;
            return containingFile instanceof PyFile;
        }
        return false;
    }

    public void inlineElement(@Nullable Project project, @Nullable Editor editor2, @Nullable PsiElement element) {
        String error;
        if (project == null || editor2 == null || !(element instanceof PyFunction)) {
            return;
        }
        Scope scope = ControlFlowCache.getScope((ScopeOwner)element);
        Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"getScope(...)");
        Scope functionScope = scope;
        String string = ((PyFunction)element).isAsync() ? PyPsiBundle.message("refactoring.inline.function.async", new Object[0]) : (((PyFunction)element).isGenerator() ? PyPsiBundle.message("refactoring.inline.function.generator", new Object[0]) : (PyUtil.isInitOrNewMethod(element) ? PyPsiBundle.message("refactoring.inline.function.constructor", new Object[0]) : (PyBuiltinCache.getInstance(element).isBuiltin(element) ? PyPsiBundle.message("refactoring.inline.function.builtin", new Object[0]) : (this.isSpecialMethod((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.special.method", new Object[0]) : (this.isUnderSkeletonDir((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.skeleton.only", new Object[0]) : (this.hasDecorators((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.decorator", new Object[0]) : (this.hasReferencesToSelf((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.self.referrent", new Object[0]) : (this.hasStarArgs((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.star", new Object[0]) : (this.overridesMethod((PyFunction)element, project) ? PyPsiBundle.message("refactoring.inline.function.overrides.method", new Object[0]) : (this.isOverridden((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.is.overridden", new Object[0]) : (functionScope.hasGlobals() ? PyPsiBundle.message("refactoring.inline.function.global", new Object[0]) : (functionScope.hasNonLocals() ? PyPsiBundle.message("refactoring.inline.function.nonlocal", new Object[0]) : (this.hasNestedFunction((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.nested", new Object[0]) : (error = this.hasNonExhaustiveIfs((PyFunction)element) ? PyPsiBundle.message("refactoring.inline.function.interrupts.flow", new Object[0]) : null))))))))))))));
        if (error != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)error, (String)PyPsiBundle.message("refactoring.inline.function.title", new Object[0]), (String)REFACTORING_ID);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PyRefactoringUiService.getInstance().showPyInlineFunctionDialog(project, editor2, (PyFunction)element, Companion.findReference(editor2));
        } else {
            PyInlineFunctionProcessor processor2 = new PyInlineFunctionProcessor(project, editor2, (PyFunction)element, Companion.findReference(editor2), false, true);
            processor2.setPreviewUsages(false);
            processor2.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSpecialMethod(PyFunction function) {
        if (function.getContainingClass() == null) return false;
        if (function.getName() == null) return false;
        Map<String, PyNames.BuiltinDescription> map = PyNames.getBuiltinMethods(LanguageLevel.forElement(function));
        Intrinsics.checkNotNullExpressionValue(map, (String)"getBuiltinMethods(...)");
        Map<String, PyNames.BuiltinDescription> map2 = map;
        if (!map2.containsKey(function.getName())) return false;
        return true;
    }

    private final boolean hasNestedFunction(PyFunction function) {
        boolean bl;
        block3: {
            JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)function.getStatementList())).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PyFunction)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNonExhaustiveIfs(PyFunction function) {
        boolean bl;
        block2: {
            void $this$any$iv;
            List returns = new ArrayList();
            function.accept(new PyRecursiveElementVisitor(returns){
                final /* synthetic */ List<PyReturnStatement> $returns;
                {
                    this.$returns = $returns;
                }

                public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.$returns.add(node);
                }
            });
            if (returns.isEmpty()) {
                return false;
            }
            Set cache = new LinkedHashSet();
            Sequence sequence = SequencesKt.filterNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)returns), (Function1)hasNonExhaustiveIfs.2.INSTANCE)));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PyIfStatement it = (PyIfStatement)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.checkInterruptsControlFlow(it, cache)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean checkInterruptsControlFlow(PyIfStatement ifStatement, Set<PyIfStatement> cache) {
        if (cache.contains(ifStatement)) {
            return false;
        }
        cache.add(ifStatement);
        PyElsePart elsePart = ifStatement.getElsePart();
        if (elsePart == null) {
            return true;
        }
        PyStatementList pyStatementList = ifStatement.getIfPart().getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
        if (this.checkLastStatement(pyStatementList, cache)) {
            return true;
        }
        PyStatementList pyStatementList2 = elsePart.getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList2, (String)"getStatementList(...)");
        if (this.checkLastStatement(pyStatementList2, cache)) {
            return true;
        }
        PyIfPart[] pyIfPartArray = ifStatement.getElifParts();
        Intrinsics.checkNotNullExpressionValue((Object)pyIfPartArray, (String)"getElifParts(...)");
        Object[] $this$forEach$iv = pyIfPartArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyIfPart it = (PyIfPart)element$iv;
            boolean bl = false;
            PyStatementList pyStatementList3 = it.getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementList3, (String)"getStatementList(...)");
            if (!this.checkLastStatement(pyStatementList3, cache)) continue;
            return true;
        }
        PyIfStatement parentIfStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ifStatement), PyIfStatement.class);
        return parentIfStatement != null && this.checkInterruptsControlFlow(parentIfStatement, cache);
    }

    private final boolean checkLastStatement(PyStatementList statementList, Set<PyIfStatement> cache) {
        Object[] statements = statementList.getStatements();
        Intrinsics.checkNotNull((Object)statements);
        if (statements.length == 0) {
            return true;
        }
        PyStatement last = (PyStatement)ArraysKt.last((Object[])statements);
        return last instanceof PyIfStatement ? this.checkInterruptsControlFlow((PyIfStatement)last, cache) : !(last instanceof PyReturnStatement);
    }

    private final boolean hasDecorators(PyFunction function) {
        PyDecorator[] pyDecoratorArray = function.getDecoratorList();
        return pyDecoratorArray != null && (pyDecoratorArray = pyDecoratorArray.getDecorators()) != null ? !(pyDecoratorArray.length == 0) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean overridesMethod(PyFunction function, Project project) {
        if (function.getContainingClass() == null) return false;
        Query<PsiElement> query = PySuperMethodsSearch.search(function, TypeEvalContext.codeAnalysis(project, function.getContainingFile()));
        Intrinsics.checkNotNullExpressionValue(query, (String)"search(...)");
        if (!CollectionsKt.any((Iterable)((Iterable)query))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverridden(PyFunction function) {
        if (function.getContainingClass() == null) return false;
        Query<PyFunction> query = PyOverridingMethodsSearch.search(function, true);
        Intrinsics.checkNotNullExpressionValue(query, (String)"search(...)");
        if (!CollectionsKt.any((Iterable)((Iterable)query))) return false;
        return true;
    }

    private final boolean hasStarArgs(PyFunction function) {
        boolean bl;
        block1: {
            PyParameter[] pyParameterArray = function.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)pyParameterArray, (String)"getParameters(...)");
            Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])pyParameterArray);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)hasStarArgs$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PyNamedParameter it = (PyNamedParameter)element$iv;
                boolean bl2 = false;
                if (!(it.isPositionalContainer() || it.isKeywordContainer())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasReferencesToSelf(PyFunction function) {
        boolean bl;
        block3: {
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)function.getStatementList()));
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Iterable $this$any$iv = (Iterable)syntaxTraverser;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PyReferenceExpression && ((PyReferenceExpression)it).getReference().isReferenceTo((PsiElement)function))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isUnderSkeletonDir(PyFunction function) {
        PsiFile containingFile = PyiUtil.getOriginalElementOrLeaveAsIs((PyElement)function, PyElement.class).getContainingFile();
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((PsiElement)containingFile);
        if (sdk2 == null) {
            return false;
        }
        Sdk sdk3 = sdk2;
        VirtualFile virtualFile = PythonSdkUtil.findSkeletonsDir(sdk3);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile skeletonsDir = virtualFile;
        return VfsUtil.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)containingFile.getVirtualFile(), (boolean)true);
    }

    @JvmStatic
    @NotNull
    public static final PyInlineFunctionHandler getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final String getREFACTORING_ID() {
        return Companion.getREFACTORING_ID();
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final PsiReference findReference(@NotNull Editor editor2) {
        return Companion.findReference(editor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/refactoring/inline/PyInlineFunctionHandler$Companion;", "", "()V", "REFACTORING_ID", "", "getREFACTORING_ID$annotations", "getREFACTORING_ID", "()Ljava/lang/String;", "findReference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getInstance", "Lcom/jetbrains/python/refactoring/inline/PyInlineFunctionHandler;", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PyInlineFunctionHandler getInstance() {
            return (PyInlineFunctionHandler)((Object)InlineActionHandler.EP_NAME.findExtensionOrFail(PyInlineFunctionHandler.class));
        }

        @NotNull
        public final String getREFACTORING_ID() {
            return REFACTORING_ID;
        }

        @JvmStatic
        public static /* synthetic */ void getREFACTORING_ID$annotations() {
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final PsiReference findReference(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            PsiReference reference = TargetElementUtilBase.findReferenceWithoutExpectedCaret((Editor)editor2);
            return !(reference instanceof PyImportReference) ? reference : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

