/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualEnvSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final Set<String> NAMES = Set.of("jython", "pypy", "python", "jython.bat", "pypy.exe", "python.exe");

    private VirtualEnvSdkFlavor() {
    }

    public static VirtualEnvSdkFlavor getInstance() {
        return (VirtualEnvSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(VirtualEnvSdkFlavor.class);
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        List list = ContainerUtil.map((Collection)((Collection)ReadAction.compute(() -> {
            VirtualFile pyEnvLocation;
            VirtualFile dir;
            Path baseDirFromContext;
            ArrayList<String> candidates = new ArrayList<String>();
            VirtualFile baseDirFromModule = module == null ? null : BasePySdkExtKt.getBaseDir(module);
            Path path2 = baseDirFromContext = context == null ? null : (Path)context.getUserData(PySdkExtKt.getBASE_DIR());
            if (baseDirFromModule != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(baseDirFromModule));
            } else if (baseDirFromContext != null && (dir = VfsUtil.findFile((Path)baseDirFromContext, (boolean)false)) != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(dir));
            }
            VirtualFile path3 = VirtualEnvSdkFlavor.getDefaultLocation();
            if (path3 != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(path3));
            }
            if ((pyEnvLocation = VirtualEnvSdkFlavor.getPyEnvDefaultLocations()) != null) {
                candidates.addAll(VirtualEnvSdkFlavor.findInBaseDirectory(pyEnvLocation));
            }
            return ContainerUtil.filter(candidates, PythonSdkUtil::isVirtualEnv);
        })), x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private static VirtualFile getPyEnvDefaultLocations() {
        VirtualFile pyEnvRoot;
        String path2 = System.getenv().get("PYENV_ROOT");
        if (!StringUtil.isEmpty((String)path2) && (pyEnvRoot = LocalFileSystem.getInstance().findFileByPath(FileUtil.expandUserHome((String)path2).replace('\\', '/'))) != null) {
            return pyEnvRoot.findFileByRelativePath("versions");
        }
        VirtualFile userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'));
        if (userHome != null) {
            return userHome.findFileByRelativePath(".pyenv/versions");
        }
        return null;
    }

    public static VirtualFile getDefaultLocation() {
        String path2 = System.getenv().get("WORKON_HOME");
        if (!StringUtil.isEmpty((String)path2)) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.expandUserHome((String)path2).replace('\\', '/'));
        }
        VirtualFile userHome = VfsUtil.getUserHomeDir();
        if (userHome != null) {
            return userHome.findChild(".virtualenvs");
        }
        return null;
    }

    private static Collection<String> findInBaseDirectory(@Nullable VirtualFile baseDir) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (baseDir != null) {
            VirtualFile[] suspects;
            baseDir.refresh(true, false);
            for (VirtualFile child : suspects = baseDir.getChildren()) {
                candidates.addAll(VirtualEnvSdkFlavor.findInRootDirectory(child));
            }
        }
        return candidates;
    }

    @NotNull
    public static Collection<String> findInRootDirectory(@Nullable VirtualFile rootDir) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (rootDir != null && rootDir.isDirectory()) {
            String interpreter;
            VirtualFile bin = rootDir.findChild("bin");
            VirtualFile scripts = rootDir.findChild("Scripts");
            if (bin != null && bin.isDirectory() && (interpreter = VirtualEnvSdkFlavor.findInterpreter(bin)) != null) {
                candidates.add(interpreter);
            }
            if (scripts != null && scripts.isDirectory() && (interpreter = VirtualEnvSdkFlavor.findInterpreter(scripts)) != null) {
                candidates.add(interpreter);
            }
            if (candidates.isEmpty() && (interpreter = VirtualEnvSdkFlavor.findInterpreter(rootDir)) != null) {
                candidates.add(interpreter);
            }
        }
        ArrayList<String> arrayList = candidates;
        if (arrayList == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static String findInterpreter(VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            String childName;
            if (child.isDirectory() || !NAMES.contains(childName = StringUtil.toLowerCase((String)child.getName()))) continue;
            String childPath = child.getPath();
            return SystemInfo.isWindows ? FileUtil.toSystemDependentName((String)childPath) : childPath;
        }
        return null;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkUtil.getVirtualEnvRoot(file.getPath()) != null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Virtualenv;
        if (icon == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRootDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

