/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.installer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.installer.CancelledProcessException;
import com.jetbrains.python.sdk.installer.DownloadableReleaseInstaller;
import com.jetbrains.python.sdk.installer.ExecutionProcessException;
import com.jetbrains.python.sdk.installer.NonZeroExitCodeProcessException;
import com.jetbrains.python.sdk.installer.ProcessException;
import com.jetbrains.python.sdk.installer.ReleaseInstallerKt;
import com.jetbrains.python.sdk.installer.TimeoutProcessException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/sdk/installer/ResourceTypeReleaseInstaller;", "Lcom/jetbrains/python/sdk/installer/DownloadableReleaseInstaller;", "resourceType", "Lcom/jetbrains/python/sdk/ResourceType;", "(Lcom/jetbrains/python/sdk/ResourceType;)V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "canInstall", "", "release", "Lcom/jetbrains/python/sdk/Release;", "getResourcesToDownload", "", "process", "", "resourcePaths", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processResource", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nResourceTypeReleaseInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceTypeReleaseInstaller.kt\ncom/jetbrains/python/sdk/installer/ResourceTypeReleaseInstaller\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n215#2,2:97\n1#3:99\n1747#4,2:100\n1747#4,3:102\n1749#4:105\n766#4:106\n857#4,2:107\n766#4:109\n857#4,2:110\n*S KotlinDebug\n*F\n+ 1 ResourceTypeReleaseInstaller.kt\ncom/jetbrains/python/sdk/installer/ResourceTypeReleaseInstaller\n*L\n45#1:97,2\n79#1:100,2\n81#1:102,3\n79#1:105\n90#1:106\n90#1:107,2\n92#1:109\n92#1:110,2\n*E\n"})
public abstract class ResourceTypeReleaseInstaller
extends DownloadableReleaseInstaller {
    @NotNull
    private final ResourceType resourceType;

    public ResourceTypeReleaseInstaller(@NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)resourceType), (String)"resourceType");
        this.resourceType = resourceType;
    }

    @NotNull
    public abstract GeneralCommandLine buildCommandLine(@NotNull Resource var1, @NotNull Path var2);

    @Override
    public void process(@NotNull Release release, @NotNull Map<Resource, ? extends Path> resourcePaths, @NotNull ProgressIndicator indicator) throws ProcessException {
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        Intrinsics.checkNotNullParameter(resourcePaths, (String)"resourcePaths");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Map<Resource, ? extends Path> $this$forEach$iv = resourcePaths;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Resource, ? extends Path>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Resource, ? extends Path> element$iv;
            Map.Entry<Resource, ? extends Path> entry = element$iv = iterator.next();
            boolean bl = false;
            Resource resource = entry.getKey();
            Path path2 = entry.getValue();
            this.processResource(resource, path2, indicator);
        }
    }

    private final void processResource(Resource resource, Path path2, ProgressIndicator indicator) throws ProcessException {
        Comparable<Boolean> comparable;
        indicator.setIndeterminate(true);
        Object[] objectArray = new Object[]{resource.getFileName()};
        indicator.setText(PySdkBundle.message("python.sdk.running.progress.text", objectArray));
        indicator.setText2(PySdkBundle.message("python.sdk.running.one.minute.progress.details", new Object[0]));
        GeneralCommandLine commandLine = this.buildCommandLine(resource, path2);
        ReleaseInstallerKt.getLOGGER().info("Running " + commandLine.getCommandLineString());
        ProcessOutput processOutput = null;
        try {
            ProcessOutput processOutput2 = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(indicator);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
            processOutput = processOutput2;
        }
        catch (Exception e) {
            throw new ExecutionProcessException(commandLine, e);
        }
        Comparable<Boolean> comparable2 = processOutput.isCancelled();
        boolean bl = (Boolean)comparable2;
        boolean bl2 = false;
        Comparable<Boolean> comparable3 = comparable = bl ? comparable2 : null;
        if (comparable != null) {
            boolean bl3 = (Boolean)comparable;
            boolean bl22 = false;
            throw new CancelledProcessException(commandLine, processOutput);
        }
        comparable2 = processOutput.getExitCode();
        int n = ((Number)((Object)comparable2)).intValue();
        boolean bl3 = false;
        Comparable<Boolean> comparable4 = comparable = n != 0 ? comparable2 : null;
        if (comparable != null) {
            int n2 = ((Number)((Object)comparable)).intValue();
            boolean bl4 = false;
            String string = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)"User cancelled", (boolean)true)) {
                throw new CancelledProcessException(commandLine, processOutput);
            }
            throw new NonZeroExitCodeProcessException(commandLine, processOutput);
        }
        comparable2 = processOutput.isTimeout();
        boolean bl4 = (Boolean)comparable2;
        boolean bl5 = false;
        Comparable<Boolean> comparable5 = comparable = bl4 ? comparable2 : null;
        if (comparable != null) {
            boolean bl6 = (Boolean)comparable;
            boolean bl62 = false;
            throw new TimeoutProcessException(commandLine, processOutput);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canInstall(@NotNull Release release) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        List<Binary> list = release.getBinaries();
        if (list == null) return false;
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Binary it = (Binary)element$iv;
            boolean bl2 = false;
            if (Binary.isCompatible$default(it, null, null, 3, null)) {
                boolean bl3;
                Iterable $this$any$iv2 = it.getResources();
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        Resource r = (Resource)element$iv2;
                        boolean bl4 = false;
                        if (r.getType() == this.resourceType) {
                            return true;
                        }
                        boolean bl5 = false;
                        if (!bl5) continue;
                        return true;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<Resource> getResourcesToDownload(@NotNull Release release) {
        List list;
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        List<Binary> list2 = release.getBinaries();
        if (list2 != null) {
            List list3;
            block7: {
                List list4;
                Collection collection;
                List list5;
                Object it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Binary)element$iv$iv;
                    boolean bl = false;
                    if (!Binary.isCompatible$default((Binary)it, null, null, 3, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = ((Iterable)((List)destination$iv$iv)).iterator();
                do {
                    void $this$filterTo$iv$iv2;
                    if (!object.hasNext()) {
                        list4 = null;
                        break block7;
                    }
                    Binary it2 = (Binary)object.next();
                    boolean bl = false;
                    Iterable $this$filter$iv2 = it2.getResources();
                    boolean $i$f$filter2 = false;
                    it = $this$filter$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        Resource r = (Resource)element$iv$iv;
                        boolean bl2 = false;
                        if (!(r.getType() == this.resourceType)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Collection collection2 = (List)destination$iv$iv2;
                    if (collection2.isEmpty()) {
                        boolean bl3 = false;
                        collection = null;
                        continue;
                    }
                    collection = collection2;
                } while ((list5 = (List)collection) == null);
                list4 = list3 = list5;
            }
            if (list3 != null) {
                list = list3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }
}

