/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/validation/PyTypeParameterListAnnotator;", "Lcom/jetbrains/python/validation/PyAnnotator;", "()V", "visitPyTypeParameter", "", "node", "Lcom/jetbrains/python/psi/PyTypeParameter;", "visitPyTypeParameterList", "Lcom/jetbrains/python/psi/PyTypeParameterList;", "intellij.python.psi.impl"})
public final class PyTypeParameterListAnnotator
extends PyAnnotator {
    @Override
    public void visitPyTypeParameterList(@NotNull PyTypeParameterList node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.getTypeParameters().isEmpty()) {
            Set namesSet = new LinkedHashSet();
            for (PyTypeParameter typeParameter : node.getTypeParameters()) {
                String name2 = typeParameter.getName();
                PsiElement identifier = typeParameter.getNameIdentifier();
                if (name2 == null || identifier == null || namesSet.add(name2)) continue;
                Object[] objectArray = new Object[]{name2};
                AnnotationBuilder annotationBuilder = this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.type.parameter.already.defined", objectArray));
                PsiElement psiElement = typeParameter.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                annotationBuilder.range(psiElement.getTextRange()).create();
            }
        }
    }

    @Override
    public void visitPyTypeParameter(@NotNull PyTypeParameter node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyExpression boundExpression = PyPsiUtils.flattenParens(node.getBoundExpression());
        if (node.getKind() == PyTypeParameter.Kind.TypeVar) {
            if (boundExpression instanceof PyTupleExpression && ((PyTupleExpression)boundExpression).getElements().length < 2) {
                this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.two.or.more.types.required", new Object[0])).range(((PyTupleExpression)boundExpression).getTextRange()).create();
            }
        } else if (boundExpression != null) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.type.var.tuple.and.param.spec.can.not.have.bounds", new Object[0])).range(boundExpression.getTextRange()).create();
        }
    }
}

