/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockDecoration;
import org.jetbrains.plugins.terminal.exp.BlockDecorationState;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u00019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0007J\u001a\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00152\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u0017H\u0007J\u0012\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020'J\u0010\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020'J\u0012\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u000e\u0010.\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010/\u001a\u0004\u0018\u00010\u0007J\u0018\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u00101\u001a\u00020\rH\u0007J\u001e\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0007J\u0010\u00103\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u0018\u00104\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u00105\u001a\u00020!H\u0007J,\u00106\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\f\u00107\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "blockStates", "", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "", "Lorg/jetbrains/plugins/terminal/exp/BlockDecorationState;", "blocks", "", "decorations", "Lorg/jetbrains/plugins/terminal/exp/BlockDecoration;", "document", "Lcom/intellij/openapi/editor/Document;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlightings", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "listeners", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "addBlockState", "", "block", "state", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "closeLastBlock", "createBlock", "command", "", "getAllHighlightings", "getBlockBounds", "Ljava/awt/Rectangle;", "getBlockState", "getBlocksSize", "", "getByIndex", "index", "getByOffset", "offset", "getDecoration", "getHighlightings", "getIndexOfBlock", "getLastBlock", "putDecoration", "decoration", "putHighlightings", "removeBlock", "removeBlockState", "stateName", "updateBlockStates", "oldStates", "newStates", "TerminalOutputListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n76#3:174\n96#3,5:175\n766#4:180\n857#4,2:181\n1855#4,2:183\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n*L\n118#1:174\n118#1:175,5\n148#1:180\n148#1:181,2\n154#1:183,2\n*E\n"})
public final class TerminalOutputModel {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CommandBlock> blocks;
    @NotNull
    private final Map<CommandBlock, BlockDecoration> decorations;
    @NotNull
    private final Map<CommandBlock, List<HighlightingInfo>> highlightings;
    @NotNull
    private final Map<CommandBlock, List<BlockDecorationState>> blockStates;
    @NotNull
    private final Document document;
    @NotNull
    private final List<TerminalOutputListener> listeners;

    public TerminalOutputModel(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.blocks = list;
        this.decorations = new HashMap();
        this.highlightings = new LinkedHashMap();
        this.blockStates = new HashMap();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.document = (Document)documentEx;
        this.listeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    public final void addListener(@NotNull TerminalOutputListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalOutputModel.addListener$lambda$0(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalOutputModel terminalOutputModel, TerminalOutputListener terminalOutputListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputModel.addListener(terminalOutputListener, disposable);
    }

    @RequiresEdt
    @NotNull
    public final CommandBlock createBlock(@Nullable String command) {
        this.closeLastBlock();
        if (this.document.getTextLength() > 0) {
            this.document.insertString(this.document.getTextLength(), (CharSequence)"\n");
        }
        RangeMarker rangeMarker = this.document.createRangeMarker(this.document.getTextLength(), this.document.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker marker = rangeMarker;
        marker.setGreedyToRight(true);
        CommandBlock block = new CommandBlock(command, marker);
        this.blocks.add(block);
        return block;
    }

    @RequiresEdt
    public final void closeLastBlock() {
        block1: {
            CommandBlock lastBlock = this.getLastBlock();
            if (lastBlock == null) break block1;
            lastBlock.getRange().setGreedyToRight(false);
            BlockDecoration blockDecoration = this.decorations.get(lastBlock);
            if (blockDecoration != null) {
                BlockDecoration it = blockDecoration;
                boolean bl = false;
                it.getBackgroundHighlighter().setGreedyToRight(false);
                it.getCornersHighlighter().setGreedyToRight(false);
                Inlay<?> inlay = it.getBottomInlay();
                Intrinsics.checkNotNull(inlay, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.RangeMarkerImpl");
                ((RangeMarkerImpl)inlay).setStickingToRight(false);
            }
        }
    }

    @RequiresEdt
    public final void removeBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.document.deleteString(block.getStartOffset(), block.getEndOffset());
        block.getRange().dispose();
        BlockDecoration blockDecoration = this.decorations.get(block);
        if (blockDecoration != null) {
            BlockDecoration it = blockDecoration;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getTopInlay()));
            Disposer.dispose((Disposable)((Disposable)it.getBottomInlay()));
            Inlay<?> inlay = it.getCommandToOutputInlay();
            if (inlay != null) {
                Inlay<?> inlay2 = inlay;
                boolean bl2 = false;
                Disposer.dispose((Disposable)((Disposable)inlay2));
            }
            this.editor.getMarkupModel().removeHighlighter(it.getBackgroundHighlighter());
            this.editor.getMarkupModel().removeHighlighter(it.getCornersHighlighter());
        }
        this.blocks.remove(block);
        this.decorations.remove(block);
        this.highlightings.remove(block);
        this.blockStates.remove(block);
    }

    @Nullable
    public final CommandBlock getLastBlock() {
        return (CommandBlock)CollectionsKt.lastOrNull(this.blocks);
    }

    @Nullable
    public final CommandBlock getByOffset(int offset) {
        Object v1;
        block1: {
            Iterable iterable = this.blocks;
            for (Object t : iterable) {
                CommandBlock it = (CommandBlock)t;
                boolean bl = false;
                int n = it.getStartOffset();
                boolean bl2 = offset <= it.getEndOffset() ? n <= offset : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final CommandBlock getByIndex(int index) {
        return this.blocks.get(index);
    }

    public final int getIndexOfBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.blocks.indexOf(block);
    }

    @RequiresEdt
    @NotNull
    public final Rectangle getBlockBounds(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int topY = this.editor.offsetToXY((int)block.getStartOffset()).y - 8;
        int bottomY = this.editor.offsetToXY((int)block.getEndOffset()).y + this.editor.getLineHeight() + 12;
        int width = this.editor.getScrollingModel().getVisibleArea().width - 7;
        return new Rectangle(0, topY, width, bottomY - topY);
    }

    public final int getBlocksSize() {
        return this.blocks.size();
    }

    @RequiresEdt
    @Nullable
    public final BlockDecoration getDecoration(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.decorations.get(block);
    }

    @RequiresEdt
    public final void putDecoration(@NotNull CommandBlock block, @NotNull BlockDecoration decoration) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        this.decorations.put(block, decoration);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final List<HighlightingInfo> getAllHighlightings() {
        void $this$flatMapTo$iv$iv;
        Map<CommandBlock, List<HighlightingInfo>> $this$flatMap$iv = this.highlightings;
        boolean $i$f$flatMap = false;
        Map<CommandBlock, List<HighlightingInfo>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @RequiresEdt
    @Nullable
    public final List<HighlightingInfo> getHighlightings(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.highlightings.get(block);
    }

    @RequiresEdt
    public final void putHighlightings(@NotNull CommandBlock block, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.highlightings.put(block, highlightings);
    }

    @RequiresEdt
    @NotNull
    public final List<BlockDecorationState> getBlockState(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List list = this.blockStates.get(block);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @RequiresEdt
    public final void addBlockState(@NotNull CommandBlock block, @NotNull BlockDecorationState state) {
        Object v1;
        List curStates;
        block3: {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            List list = this.blockStates.get(block);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            curStates = list;
            Iterable iterable = curStates;
            for (Object t : iterable) {
                BlockDecorationState it = (BlockDecorationState)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)state.getName())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if (v1 == null) {
            this.updateBlockStates(block, curStates, CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)curStates), (Object)state));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void removeBlockState(@NotNull CommandBlock block, @NotNull String stateName) {
        BlockDecorationState blockDecorationState;
        List<BlockDecorationState> curStates;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        List<BlockDecorationState> list = curStates = this.blockStates.get(block);
        if (list != null) {
            Object v1;
            block5: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    BlockDecorationState it = (BlockDecorationState)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            blockDecorationState = v1;
        } else {
            blockDecorationState = null;
        }
        if (blockDecorationState != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = curStates;
            List<BlockDecorationState> list2 = curStates;
            CommandBlock commandBlock = block;
            TerminalOutputModel terminalOutputModel = this;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BlockDecorationState it = (BlockDecorationState)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)stateName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            terminalOutputModel.updateBlockStates(commandBlock, list2, list3);
        }
    }

    private final void updateBlockStates(CommandBlock block, List<? extends BlockDecorationState> oldStates, List<? extends BlockDecorationState> newStates) {
        this.blockStates.put(block, newStates);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockDecorationStateChanged(block, oldStates, newStates);
        }
    }

    private static final void addListener$lambda$0(TerminalOutputModel this$0, TerminalOutputListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "", "blockDecorationStateChanged", "", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "oldStates", "", "Lorg/jetbrains/plugins/terminal/exp/BlockDecorationState;", "newStates", "blockRemoved", "intellij.terminal"})
    public static interface TerminalOutputListener {
        default public void blockRemoved(@NotNull CommandBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        }

        default public void blockDecorationStateChanged(@NotNull CommandBlock block, @NotNull List<? extends BlockDecorationState> oldStates, @NotNull List<? extends BlockDecorationState> newStates) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter(oldStates, (String)"oldStates");
            Intrinsics.checkNotNullParameter(newStates, (String)"newStates");
        }
    }
}

