/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandHistoryManager;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0013\u0010#\u001a\u00070\u000b\u00a2\u0006\u0002\b$2\u0006\u0010%\u001a\u00020\u000bJ\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000bH\u0016J\b\u0010(\u001a\u00020\u001dH\u0007J\b\u0010)\u001a\u00020\u001dH\u0007J\b\u0010*\u001a\u00020\u001dH\u0007J\b\u0010+\u001a\u00020\u001dH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;)V", "commandHistory", "", "", "getCommandHistory", "()Ljava/util/List;", "commandHistoryManager", "Lorg/jetbrains/plugins/terminal/exp/CommandHistoryManager;", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController$PromptStateListener;", "<set-?>", "", "promptIsVisible", "getPromptIsVisible", "()Z", "setPromptIsVisible", "(Z)V", "promptIsVisible$delegate", "Lkotlin/properties/ReadWriteProperty;", "addDocumentListener", "", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "addListener", "computePromptText", "Lcom/intellij/openapi/util/NlsSafe;", "directory", "directoryChanged", "newDirectory", "handleEnterPressed", "onCommandHistoryClosed", "reset", "showCommandHistory", "Companion", "PromptStateListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalPromptController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptController.kt\norg/jetbrains/plugins/terminal/exp/TerminalPromptController\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n33#2,3:95\n1855#3,2:98\n1855#3,2:100\n1855#3,2:102\n*S KotlinDebug\n*F\n+ 1 TerminalPromptController.kt\norg/jetbrains/plugins/terminal/exp/TerminalPromptController\n*L\n28#1:95,3\n53#1:98,2\n70#1:100,2\n75#1:102,2\n*E\n"})
public final class TerminalPromptController
implements ShellCommandListener {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalCommandExecutor commandExecutor;
    @NotNull
    private final CommandHistoryManager commandHistoryManager;
    @NotNull
    private final List<PromptStateListener> listeners;
    @NotNull
    private final ReadWriteProperty promptIsVisible$delegate;
    @NotNull
    private static final DataKey<TerminalPromptController> KEY;

    public TerminalPromptController(@NotNull EditorEx editor, @NotNull TerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.editor = editor;
        this.commandExecutor = commandExecutor;
        this.listeners = new CopyOnWriteArrayList();
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = true;
        boolean $i$f$observable = false;
        this.promptIsVisible$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ TerminalPromptController this$0;
            {
                this.this$0 = terminalPromptController;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean oldValue2 = (Boolean)oldValue;
                boolean bl2 = false;
                if (newValue2 != oldValue2) {
                    Iterable $this$forEach$iv = TerminalPromptController.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PromptStateListener it = (PromptStateListener)element$iv;
                        boolean bl3 = false;
                        it.promptVisibilityChanged((boolean)newValue2);
                    }
                }
            }
        };
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_PROMPT_EDITOR_KEY(), (Object)true);
        this.editor.putUserData(TerminalSession.Companion.getKEY(), (Object)session2);
        this.commandHistoryManager = new CommandHistoryManager(session2);
        TerminalSession.addCommandListener$default(session2, this, null, 2, null);
    }

    @NotNull
    public final List<String> getCommandHistory() {
        return this.commandHistoryManager.getHistory();
    }

    public final boolean getPromptIsVisible() {
        return (Boolean)this.promptIsVisible$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setPromptIsVisible(boolean bl) {
        this.promptIsVisible$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public final void addListener(@NotNull PromptStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @RequiresEdt
    public final void reset() {
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalPromptController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TerminalPromptController.access$getEditor$p(this.this$0).getDocument().setText((CharSequence)"");
            }
        }));
    }

    @Override
    public void directoryChanged(@NotNull String newDirectory) {
        Intrinsics.checkNotNullParameter((Object)newDirectory, (String)"newDirectory");
        String newText = this.computePromptText(newDirectory);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.promptLabelChanged(newText);
        }
    }

    @NotNull
    public final String computePromptText(@NotNull String directory) {
        String string;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!Intrinsics.areEqual((Object)directory, (Object)SystemProperties.getUserHome())) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)directory);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "~";
        }
        return string;
    }

    @RequiresEdt
    public final void handleEnterPressed() {
        String string = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.commandExecutor.startCommandExecution(string);
    }

    @RequiresEdt
    public final void showCommandHistory() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.commandHistoryStateChanged(true);
        }
    }

    @RequiresEdt
    public final void onCommandHistoryClosed() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PromptStateListener it = (PromptStateListener)element$iv;
            boolean bl = false;
            it.commandHistoryStateChanged(false);
        }
    }

    public final void addDocumentListener(@NotNull DocumentListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalPromptController terminalPromptController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalPromptController.addDocumentListener(documentListener, disposable);
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(TerminalPromptController $this) {
        return $this.editor;
    }

    public static final /* synthetic */ List access$getListeners$p(TerminalPromptController $this) {
        return $this.listeners;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TerminalPromptController.class, "promptIsVisible", "getPromptIsVisible()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        DataKey dataKey = DataKey.create((String)"TerminalPromptController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalPromptController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0015\u0010\u0006\u001a\u00020\u00032\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController$PromptStateListener;", "", "commandHistoryStateChanged", "", "showing", "", "promptLabelChanged", "newText", "", "Lcom/intellij/openapi/util/NlsSafe;", "promptVisibilityChanged", "visible", "intellij.terminal"})
    public static interface PromptStateListener {
        default public void promptLabelChanged(@NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        }

        default public void commandHistoryStateChanged(boolean showing) {
        }

        default public void promptVisibilityChanged(boolean visible) {
        }
    }
}

