/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.performancePlugin.lang.psi.IJPerfElementType;
import com.jetbrains.performancePlugin.lang.psi.IJPerfTokenType;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfCommandLineImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfCommandNameImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfDelayTypingOptionImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfGotoOptionImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfOptionImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfOptionListImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfSimpleOptionImpl;
import com.jetbrains.performancePlugin.lang.psi.impl.IJPerfStatementImpl;

public interface IJPerfElementTypes {
    public static final IElementType COMMAND_LINE = new IJPerfElementType("COMMAND_LINE");
    public static final IElementType COMMAND_NAME = new IJPerfElementType("COMMAND_NAME");
    public static final IElementType DELAY_TYPING_OPTION = new IJPerfElementType("DELAY_TYPING_OPTION");
    public static final IElementType GOTO_OPTION = new IJPerfElementType("GOTO_OPTION");
    public static final IElementType OPTION = new IJPerfElementType("OPTION");
    public static final IElementType OPTION_LIST = new IJPerfElementType("OPTION_LIST");
    public static final IElementType SIMPLE_OPTION = new IJPerfElementType("SIMPLE_OPTION");
    public static final IElementType STATEMENT = new IJPerfElementType("STATEMENT");
    public static final IElementType ASSIGNMENT_OPERATOR = new IJPerfTokenType("ASSIGNMENT_OPERATOR");
    public static final IElementType COMMAND = new IJPerfTokenType("COMMAND");
    public static final IElementType COMMENT = new IJPerfTokenType("COMMENT");
    public static final IElementType FILE_PATH = new IJPerfTokenType("FILE_PATH");
    public static final IElementType IDENTIFIER = new IJPerfTokenType("IDENTIFIER");
    public static final IElementType NUMBER = new IJPerfTokenType("NUMBER");
    public static final IElementType OPTIONS_SEPARATOR = new IJPerfTokenType("OPTIONS_SEPARATOR");
    public static final IElementType PIPE = new IJPerfTokenType("PIPE");
    public static final IElementType TEXT = new IJPerfTokenType("TEXT");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == COMMAND_LINE) {
                return new IJPerfCommandLineImpl(node);
            }
            if (type == COMMAND_NAME) {
                return new IJPerfCommandNameImpl(node);
            }
            if (type == DELAY_TYPING_OPTION) {
                return new IJPerfDelayTypingOptionImpl(node);
            }
            if (type == GOTO_OPTION) {
                return new IJPerfGotoOptionImpl(node);
            }
            if (type == OPTION) {
                return new IJPerfOptionImpl(node);
            }
            if (type == OPTION_LIST) {
                return new IJPerfOptionListImpl(node);
            }
            if (type == SIMPLE_OPTION) {
                return new IJPerfSimpleOptionImpl(node);
            }
            if (type == STATEMENT) {
                return new IJPerfStatementImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

