/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.configurationStore.ComponentReloadingKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.importSettings.jb.JbSettingsImporter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\nH\u0002J*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010J\u001c\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbSettingsImporter;", "", "configDirPath", "Ljava/nio/file/Path;", "pluginsPath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "filesFromFolder", "", "", "dir", "prefix", "filterFiles", "", "allFiles", "", "categories", "Lcom/intellij/openapi/components/SettingsCategory;", "importOptions", "", "installPlugins", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pluginIds", "Companion", "ImportStreamProvider", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbSettingsImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbSettingsImporter.kt\ncom/intellij/ide/startup/importSettings/jb/JbSettingsImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n1549#2:192\n1620#2,3:193\n1855#2,2:196\n10#3:198\n*S KotlinDebug\n*F\n+ 1 JbSettingsImporter.kt\ncom/intellij/ide/startup/importSettings/jb/JbSettingsImporter\n*L\n33#1:192\n33#1:193,3\n33#1:196,2\n189#1:198\n*E\n"})
public final class JbSettingsImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path configDirPath;
    @NotNull
    private final Path pluginsPath;
    @NotNull
    private final ComponentStoreImpl componentStore;
    @NotNull
    private static final Logger LOG;

    public JbSettingsImporter(@NotNull Path configDirPath, @NotNull Path pluginsPath) {
        Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
        Intrinsics.checkNotNullParameter((Object)pluginsPath, (String)"pluginsPath");
        this.configDirPath = configDirPath;
        this.pluginsPath = pluginsPath;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        this.componentStore = (ComponentStoreImpl)iComponentStore;
    }

    /*
     * WARNING - void declaration
     */
    public final void importOptions(@NotNull Set<? extends SettingsCategory> categories) {
        Iterator $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Set allFiles = new LinkedHashSet();
        Path path = this.configDirPath.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path optionsPath = path;
        Iterable $this$map$iv = PathsKt.listDirectoryEntries((Path)optionsPath, (String)"*.xml");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PathsKt.getName((Path)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Object element$iv = $this$mapTo$iv$iv.next();
            String it = (String)element$iv;
            boolean bl = false;
            allFiles.add(it);
        }
        for (Path optionsEntry : PathsKt.listDirectoryEntries$default((Path)optionsPath, null, (int)1, null)) {
            String string = PathsKt.getName((Path)optionsEntry).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                String string2 = PathsKt.getName((Path)optionsEntry).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string2, (Object)"other.xml")) {
                    allFiles.add(PathsKt.getName((Path)optionsEntry));
                    continue;
                }
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(optionsEntry, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            String string3 = PathsKt.getName((Path)optionsEntry).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string3, (Object)StoreUtilKt.getPerOsSettingsStorageFolderName())) continue;
            allFiles.addAll(this.filesFromFolder(optionsEntry, ""));
        }
        CodeStyleSchemes.getInstance();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        SchemeManagerFactoryBase schemeManagerFactory2 = (SchemeManagerFactoryBase)schemeManagerFactory;
        schemeManagerFactory2.process((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(this, (Set<String>)allFiles){
            final /* synthetic */ JbSettingsImporter this$0;
            final /* synthetic */ Set<String> $allFiles;
            {
                this.this$0 = $receiver;
                this.$allFiles = $allFiles;
                super(1);
            }

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Path path = JbSettingsImporter.access$getConfigDirPath$p(this.this$0).resolve(it.getFileSpec());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path dirPath = path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(dirPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    this.$allFiles.addAll(JbSettingsImporter.filesFromFolder$default(this.this$0, dirPath, null, 2, null));
                }
            }
        });
        LOG.info("Detected " + allFiles.size() + " files to import: " + CollectionsKt.joinToString$default((Iterable)allFiles, null, null, null, (int)0, null, null, (int)63, null));
        List<String> files2process = this.filterFiles(allFiles, categories);
        LOG.info("After filtering we have " + files2process.size() + " files to import: " + CollectionsKt.joinToString$default((Iterable)files2process, null, null, null, (int)0, null, null, (int)63, null));
        StateStorageManager stateStorageManager = this.componentStore.getStorageManager();
        Intrinsics.checkNotNull((Object)stateStorageManager, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        StateStorageManagerImpl storageManager = (StateStorageManagerImpl)stateStorageManager;
        ImportStreamProvider provider2 = new ImportStreamProvider(this.configDirPath);
        StateStorageManager.addStreamProvider$default((StateStorageManager)((StateStorageManager)storageManager), (StreamProvider)provider2, (boolean)false, (int)2, null);
        ComponentReloadingKt.reloadComponents((ComponentStoreImpl)this.componentStore, (Collection)files2process, (Collection)CollectionsKt.emptyList());
        storageManager.removeStreamProvider(provider2.getClass());
    }

    private final Collection<String> filesFromFolder(Path dir, String prefix) {
        ArrayList<CallSite> retval = new ArrayList<CallSite>();
        for (Path entry2 : PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null)) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(entry2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            retval.add((CallSite)((Object)(prefix + "/" + PathsKt.getName((Path)entry2))));
        }
        return retval;
    }

    static /* synthetic */ Collection filesFromFolder$default(JbSettingsImporter jbSettingsImporter, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = PathsKt.getName((Path)path);
        }
        return jbSettingsImporter.filesFromFolder(path, string);
    }

    private final List<String> filterFiles(Set<String> allFiles, Set<? extends SettingsCategory> categories) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        HashSet<String> retval = new HashSet<String>();
        componentManager.processAllImplementationClasses(new Function2<Class<?>, PluginDescriptor, Unit>(categories, allFiles, retval){
            final /* synthetic */ Set<SettingsCategory> $categories;
            final /* synthetic */ Set<String> $allFiles;
            final /* synthetic */ HashSet<String> $retval;
            {
                this.$categories = $categories;
                this.$allFiles = $allFiles;
                this.$retval = $retval;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                if (PersistentStateComponent.class.isAssignableFrom(aClass)) {
                    void $this$forEach$iv;
                    State state = aClass.getAnnotation(State.class);
                    if (state == null) {
                        return;
                    }
                    State state2 = state;
                    if (!this.$categories.contains(state2.category())) {
                        return;
                    }
                    Storage[] storageArray = state2.storages();
                    Set<String> set = this.$allFiles;
                    HashSet<String> hashSet = this.$retval;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void storage = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        if (storage.deprecated() || !set.contains(storage.value())) continue;
                        hashSet.add(storage.value());
                    }
                }
            }
        });
        HashSet<String> schemeCategories = new HashSet<String>();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(categories, schemeCategories){
            final /* synthetic */ Set<SettingsCategory> $categories;
            final /* synthetic */ HashSet<String> $schemeCategories;
            {
                this.$categories = $categories;
                this.$schemeCategories = $schemeCategories;
                super(1);
            }

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.$categories.contains(it.getSettingsCategory())) {
                    this.$schemeCategories.add(it.getFileSpec());
                }
            }
        });
        for (String file : allFiles) {
            char[] cArray;
            List split = StringsKt.split$default((CharSequence)file, (char[])(cArray = new char[]{'/'}), (boolean)false, (int)0, (int)6, null);
            if (split.size() != 2 || !schemeCategories.contains(split.get(0))) continue;
            retval.add(file);
        }
        return CollectionsKt.toList((Iterable)retval);
    }

    public final void installPlugins(@NotNull ProgressIndicator progressIndicator, @NotNull List<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        ConfigImportHelper.ConfigImportOptions importOptions2 = new ConfigImportHelper.ConfigImportOptions(LOG);
        importOptions2.setHeadless(true);
        importOptions2.setHeadlessProgressIndicator(progressIndicator);
        importOptions2.setImportSettings(new ConfigImportSettings(pluginIds){
            final /* synthetic */ List<String> $pluginIds;
            {
                this.$pluginIds = $pluginIds;
            }

            public void processPluginsToMigrate(@NotNull Path newConfigDir, @NotNull Path oldConfigDir, @NotNull List<IdeaPluginDescriptor> bundledPlugins, @NotNull List<IdeaPluginDescriptor> nonBundledPlugins) {
                Intrinsics.checkNotNullParameter((Object)newConfigDir, (String)"newConfigDir");
                Intrinsics.checkNotNullParameter((Object)oldConfigDir, (String)"oldConfigDir");
                Intrinsics.checkNotNullParameter(bundledPlugins, (String)"bundledPlugins");
                Intrinsics.checkNotNullParameter(nonBundledPlugins, (String)"nonBundledPlugins");
                nonBundledPlugins.removeIf(arg_0 -> installPlugins.1.processPluginsToMigrate$lambda$0((Function1)new Function1<IdeaPluginDescriptor, Boolean>(this.$pluginIds){
                    final /* synthetic */ List<String> $pluginIds;
                    {
                        this.$pluginIds = $pluginIds;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull IdeaPluginDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !this.$pluginIds.contains(it.getPluginId().getIdString());
                    }
                }, arg_0));
            }

            private static final boolean processPluginsToMigrate$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        });
        ConfigImportHelper.migratePlugins((Path)this.pluginsPath, (Path)this.configDirPath, (Path)PathManager.getPluginsDir(), (Path)PathManager.getConfigDir(), (ConfigImportHelper.ConfigImportOptions)importOptions2, JbSettingsImporter::installPlugins$lambda$2);
    }

    private static final boolean installPlugins$lambda$2(IdeaPluginDescriptor it) {
        return false;
    }

    public static final /* synthetic */ Path access$getConfigDirPath$p(JbSettingsImporter $this) {
        return $this.configDirPath;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JbSettingsImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbSettingsImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0088\u0001\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\u00102K\u0010\u0013\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J.\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\u0019\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001a0\u0010H\u0016J \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbSettingsImporter$ImportStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "configDirPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "isExclusive", "", "()Z", "delete", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "input", "readOnly", "read", "consumer", "", "write", "content", "", "intellij.ide.startup.importSettings"})
    public static final class ImportStreamProvider
    implements StreamProvider {
        @NotNull
        private final Path configDirPath;
        private final boolean isExclusive;

        public ImportStreamProvider(@NotNull Path configDirPath) {
            Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
            this.configDirPath = configDirPath;
            this.isExclusive = true;
        }

        public boolean isExclusive() {
            return this.isExclusive;
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content2, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Companion.getLOG().warn("Writing to " + fileSpec + " (Will do nothing)");
        }

        public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Path path = this.configDirPath.resolve("options");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path.resolve(fileSpec);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path it = path2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                consumer.invoke((Object)new FileInputStream(it.toFile()));
                return true;
            }
            Path path3 = this.configDirPath.resolve(fileSpec);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            it = path3;
            boolean bl2 = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                consumer.invoke((Object)new FileInputStream(it.toFile()));
                return true;
            }
            return false;
        }

        public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Companion.getLOG().warn("Process Children " + path);
            Path folder = this.configDirPath.resolve(path);
            Intrinsics.checkNotNull((Object)folder);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return true;
            }
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filter, this, processor){
                final /* synthetic */ Function1<String, Boolean> $filter;
                final /* synthetic */ ImportStreamProvider this$0;
                final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
                {
                    this.$filter = $filter;
                    this.this$0 = $receiver;
                    this.$processor = $processor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @Nullable BasicFileAttributes attrs) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!((Boolean)this.$filter.invoke((Object)PathsKt.getName((Path)file))).booleanValue()) {
                        return FileVisitResult.CONTINUE;
                    }
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        return FileVisitResult.CONTINUE;
                    }
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream2 = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
                    Closeable closeable = inputStream2;
                    ImportStreamProvider importStreamProvider = this.this$0;
                    Function3<String, InputStream, Boolean, Boolean> function3 = this.$processor;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream3 = (InputStream)closeable;
                        boolean bl2 = false;
                        Path path = ImportStreamProvider.access$getConfigDirPath$p(importStreamProvider).relativize(file);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
                        String fileSpec = PathKt.getSystemIndependentPath((Path)path);
                        bl = StreamProvider.read$default((StreamProvider)importStreamProvider, (String)fileSpec, null, (Function1)((Function1)new Function1<InputStream, Unit>(function3, file, inputStream3){
                            final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
                            final /* synthetic */ Path $file;
                            final /* synthetic */ InputStream $inputStream;
                            {
                                this.$processor = $processor;
                                this.$file = $file;
                                this.$inputStream = $inputStream;
                                super(1);
                            }

                            public final void invoke(@Nullable InputStream it) {
                                this.$processor.invoke((Object)((Object)this.$file.getFileName()).toString(), (Object)this.$inputStream, (Object)false);
                            }
                        }), (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    boolean shouldProceed2 = bl;
                    return shouldProceed2 ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
                }
            });
            return true;
        }

        public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Companion.getLOG().warn("Deleting " + fileSpec);
            return false;
        }

        public static final /* synthetic */ Path access$getConfigDirPath$p(ImportStreamProvider $this) {
            return $this.configDirPath;
        }
    }
}

