/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.customize.transferSettings.models.IdeVersion;
import com.intellij.ide.customize.transferSettings.models.SettingsPreferences;
import com.intellij.ide.customize.transferSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.ImportProgress;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferServiceKt;
import com.intellij.util.text.StringKt;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000*\u0001\b\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\r\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"applyPreferences", "", "ideVersion", "Lcom/intellij/ide/customize/transferSettings/models/IdeVersion;", "toApply", "", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "dummyImportData", "com/intellij/ide/startup/importSettings/transfer/SettingTransferServiceKt$dummyImportData$1", "()Lcom/intellij/ide/startup/importSettings/transfer/SettingTransferServiceKt$dummyImportData$1;", "showImportErrorNotification", "error", "", "intellij.ide.startup.importSettings"})
public final class SettingTransferServiceKt {
    private static final void applyPreferences(IdeVersion ideVersion, List<DataForSave> toApply) {
        Set selectedIds2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)toApply), (Function1)applyPreferences.selectedIds.1.INSTANCE));
        SettingsPreferences preferences = ideVersion.getSettingsCache().getPreferences();
        preferences.set(SettingsPreferencesKind.Laf, selectedIds2.contains("ui"));
        preferences.set(SettingsPreferencesKind.SyntaxScheme, selectedIds2.contains("ui"));
        preferences.set(SettingsPreferencesKind.Keymap, selectedIds2.contains("keymap"));
        preferences.set(SettingsPreferencesKind.Plugins, selectedIds2.contains("plugins"));
        preferences.set(SettingsPreferencesKind.RecentProjects, selectedIds2.contains("recentProjects"));
    }

    private static final void showImportErrorNotification(Throwable error) {
        String string;
        Object[] objectArray = new Object[1];
        String string2 = error.getLocalizedMessage();
        if (string2 == null) {
            string2 = error.getMessage();
        }
        if ((string = StringKt.nullize((String)string2, (boolean)true)) == null) {
            string = ImportSettingsBundle.INSTANCE.message("transfer.error.no-error-message", new Object[0]);
        }
        objectArray[0] = string;
        String message = ImportSettingsBundle.INSTANCE.message("transfer.error.unknown", objectArray);
        SettingsService.Companion.getInstance().getError().fire((Object)new NotificationData(message){
            @NotNull
            private final NotificationData.NotificationStatus status;
            @NotNull
            private final String message;
            @NotNull
            private final List<NotificationData.Action> customActionList;
            {
                this.status = NotificationData.NotificationStatus.ERROR;
                this.message = $message;
                this.customActionList = CollectionsKt.emptyList();
            }

            @NotNull
            public NotificationData.NotificationStatus getStatus() {
                return this.status;
            }

            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public List<NotificationData.Action> getCustomActionList() {
                return this.customActionList;
            }
        });
    }

    private static final dummyImportData.1 dummyImportData() {
        return new DialogImportData(){
            @NotNull
            private final String message;
            @NotNull
            private final dummyImportData.progress.1 progress;
            {
                this.message = "";
                this.progress = new ImportProgress(){
                    @NotNull
                    private final Property<String> progressMessage;
                    @NotNull
                    private final OptProperty<Integer> progress;
                    {
                        this.progressMessage = new Property((Object)"");
                        this.progress = new OptProperty();
                    }

                    @NotNull
                    public Property<String> getProgressMessage() {
                        return this.progressMessage;
                    }

                    @NotNull
                    public OptProperty<Integer> getProgress() {
                        return this.progress;
                    }
                };
            }

            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public dummyImportData.progress.1 getProgress() {
                return this.progress;
            }
        };
    }

    public static final /* synthetic */ void access$applyPreferences(IdeVersion ideVersion, List toApply) {
        SettingTransferServiceKt.applyPreferences(ideVersion, toApply);
    }

    public static final /* synthetic */ void access$showImportErrorNotification(Throwable error) {
        SettingTransferServiceKt.showImportErrorNotification(error);
    }

    public static final /* synthetic */ dummyImportData.1 access$dummyImportData() {
        return SettingTransferServiceKt.dummyImportData();
    }
}

