/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ml.embeddings.EmbeddingsBundle;
import com.intellij.platform.ml.embeddings.search.indices.DiskSynchronizedEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.FileIndexableEntitiesProvider;
import com.intellij.platform.ml.embeddings.search.services.ClassesSemanticSearchFileListener;
import com.intellij.platform.ml.embeddings.search.services.FileContentBasedEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.IndexableClass;
import com.intellij.platform.ml.embeddings.search.settings.SemanticSearchSettings;
import com.intellij.platform.ml.embeddings.services.LocalArtifactsManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\f0\u0014\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\f0\u0014\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/ClassEmbeddingsStorage;", "Lcom/intellij/platform/ml/embeddings/search/services/FileContentBasedEmbeddingsStorage;", "Lcom/intellij/platform/ml/embeddings/search/services/IndexableClass;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "index", "Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "getIndex", "()Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "indexMemoryWeight", "", "getIndexMemoryWeight", "()I", "indexStrongLimit", "getIndexStrongLimit", "()Ljava/lang/Integer;", "scanningTitle", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getScanningTitle", "()Ljava/lang/String;", "setupTitle", "getSetupTitle", "spanIndexName", "getSpanIndexName", "checkSearchEnabled", "", "getIndexableEntities", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "traversePsiFile", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.platform.ml.embeddings"})
public final class ClassEmbeddingsStorage
extends FileContentBasedEmbeddingsStorage<IndexableClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskSynchronizedEmbeddingSearchIndex index;
    @NotNull
    private final String spanIndexName;
    private final int indexMemoryWeight;
    private final int indexStrongLimit;
    @NotNull
    private static final String INDEX_DIR = "classes";

    public ClassEmbeddingsStorage(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, cs);
        String string = FilesKt.resolve((File)FilesKt.resolve((File)new File("semantic-search"), (String)LocalArtifactsManager.Companion.getInstance().getModelVersion()), (String)INDEX_DIR).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.index = new DiskSynchronizedEmbeddingSearchIndex(ProjectUtil.getProjectCachePath$default((Project)project, (String)string, (boolean)false, null, (int)6, null), null, 2, null);
        this.spanIndexName = "semanticClasses";
        this.indexMemoryWeight = 1;
        this.indexStrongLimit = Registry.intValue((String)"search.everywhere.ml.semantic.indexing.indexable.classes.limit");
    }

    @Override
    @NotNull
    public DiskSynchronizedEmbeddingSearchIndex getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public String getScanningTitle() {
        String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.indices.classes.scanning.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Override
    @NotNull
    public String getSetupTitle() {
        String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.indices.classes.generation.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Override
    @NotNull
    public String getSpanIndexName() {
        return this.spanIndexName;
    }

    @Override
    public int getIndexMemoryWeight() {
        return this.indexMemoryWeight;
    }

    @Override
    @NotNull
    public Integer getIndexStrongLimit() {
        return this.indexStrongLimit;
    }

    @Override
    public boolean checkSearchEnabled() {
        return SemanticSearchSettings.Companion.getInstance().getEnabledInClassesTab();
    }

    @Override
    @RequiresBackgroundThread
    @Nullable
    public Object getIndexableEntities(@NotNull Continuation<? super List<? extends IndexableClass>> $completion) {
        return this.collectEntities(ClassesSemanticSearchFileListener.Companion.getInstance(this.getProject()), $completion);
    }

    @Override
    @NotNull
    public List<IndexableClass> traversePsiFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileIndexableEntitiesProvider.Companion.extractClasses(file);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/ClassEmbeddingsStorage$Companion;", "", "()V", "INDEX_DIR", "", "getInstance", "Lcom/intellij/platform/ml/embeddings/search/services/ClassEmbeddingsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.embeddings"})
    @SourceDebugExtension(value={"SMAP\nClassEmbeddingsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/ClassEmbeddingsStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n30#2,3:65\n*S KotlinDebug\n*F\n+ 1 ClassEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/ClassEmbeddingsStorage$Companion\n*L\n58#1:65,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassEmbeddingsStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ClassEmbeddingsStorage> serviceClass$iv = ClassEmbeddingsStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ClassEmbeddingsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

