/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/HidingMouseListener;", "Ljava/awt/event/MouseAdapter;", "mainComponent", "Ljavax/swing/JComponent;", "componentsToHide", "", "Ljava/awt/Component;", "(Ljavax/swing/JComponent;[Ljava/awt/Component;)V", "[Ljava/awt/Component;", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "intellij.notebooks.ui"})
public final class HidingMouseListener
extends MouseAdapter {
    @NotNull
    private final JComponent mainComponent;
    @NotNull
    private final Component[] componentsToHide;

    public HidingMouseListener(@NotNull JComponent mainComponent, Component ... componentsToHide) {
        Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
        Intrinsics.checkNotNullParameter((Object)componentsToHide, (String)"componentsToHide");
        this.mainComponent = mainComponent;
        this.componentsToHide = componentsToHide;
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (Component c : this.componentsToHide) {
            c.setVisible(true);
        }
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.mainComponent.getBounds().contains(e.getPoint())) {
            for (Component c : this.componentsToHide) {
                c.setVisible(false);
            }
        }
    }
}

