/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutputStream;
import java.io.IOException;

public class SwitchData
implements CoverageData {
    private int[] myKeys;
    private int myDefaultHits;
    private int[] myHits;
    private int[] myIds;

    /*
     * WARNING - void declaration
     */
    public SwitchData(int[] keys) {
        void var1_1;
        this.myKeys = keys;
        this.myHits = new int[((void)var1_1).length];
    }

    /*
     * WARNING - void declaration
     */
    public void touch(int key) {
        if (key == -1) {
            ++this.myDefaultHits;
            return;
        }
        if (key < this.myHits.length && key >= 0) {
            void var1_1;
            void v0 = var1_1;
            this.myHits[v0] = this.myHits[v0] + 1;
        }
    }

    public int getDefaultHits() {
        return this.myDefaultHits;
    }

    public int[] getHits() {
        return this.myHits;
    }

    public void save(DataOutputStream os) throws IOException {
        CoverageIOUtil.writeINT(os, this.myDefaultHits);
        CoverageIOUtil.writeINT(os, this.myHits.length);
        for (int i = 0; i < this.myHits.length; ++i) {
            CoverageIOUtil.writeINT(os, this.myKeys[i]);
            CoverageIOUtil.writeINT(os, this.myHits[i]);
        }
    }

    public void merge(CoverageData data) {
        SwitchData switchData = (SwitchData)data;
        SwitchData switchData2 = this;
        switchData2.setDefaultHits(switchData2.myDefaultHits + switchData.myDefaultHits);
        if (switchData.myHits.length > this.myHits.length) {
            this.myHits = ArrayUtil.copy(this.myHits, switchData.myHits.length);
            this.myKeys = switchData.myKeys;
        }
        for (int i = Math.min(this.myHits.length, switchData.myHits.length) - 1; i >= 0; --i) {
            this.myHits[i] = ClassData.trimHits(this.myHits[i] + switchData.myHits[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultHits(int defaultHits) {
        void var1_1;
        this.myDefaultHits = ClassData.trimHits((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setKeysAndHits(int[] keys, int[] hits) {
        void var2_3;
        this.myKeys = keys;
        this.myHits = var2_3;
        for (int i = 0; i < this.myHits.length; ++i) {
            this.myHits[i] = ClassData.trimHits(this.myHits[i]);
        }
    }

    public int[] getKeys() {
        return this.myKeys;
    }

    /*
     * WARNING - void declaration
     */
    public int getId(int index) {
        void var1_1;
        if (this.myIds == null) {
            return 0;
        }
        if (index == -1) {
            return this.myIds[this.myIds.length - 1];
        }
        if (index < 0 || index >= this.myIds.length) {
            return 0;
        }
        return this.myIds[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void setId(int id, int index) {
        void var1_1;
        if (this.myIds == null) {
            this.myIds = new int[this.myKeys.length + 1];
        }
        if (index == -1) {
            this.myIds[this.myIds.length - 1] = id;
            return;
        }
        if (index < 0 || index >= this.myIds.length) {
            return;
        }
        this.myIds[var2_2] = var1_1;
    }
}

