/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    protected static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = ContainerUtil::createMaybeSingletonList;
    protected final Icon myIcon;
    private final NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> myConverter;
    protected NotNullLazyValue<Collection<? extends T>> myTargets;
    private boolean myLazy;
    protected @NlsContexts.Tooltip String myTooltipText;
    protected @NlsContexts.PopupTitle String myPopupTitle;
    protected @NlsContexts.PopupContent String myEmptyText;
    private @NlsContexts.PopupTitle String myTooltipTitle;
    protected GutterIconRenderer.Alignment myAlignment;
    private Computable<PsiElementListCellRenderer<?>> myCellRenderer;
    @NotNull
    private NullableFunction<? super T, String> myNamer;
    private final NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> myGotoRelatedItemProvider;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
    public static final NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> DOM_GOTO_RELATED_ITEM_PROVIDER = dom -> {
        if (dom.getXmlElement() != null) {
            return List.of(new DomGotoRelatedItem((DomElement)dom));
        }
        return Collections.emptyList();
    };
    protected static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> PSI_GOTO_RELATED_ITEM_PROVIDER = dom -> List.of(new GotoRelatedItem(dom, InspectionsBundle.message((String)"xml.goto.group", (Object[])new Object[0])));
    @NotNull
    private Supplier<? extends PsiTargetPresentationRenderer<PsiElement>> myTargetRenderer;

    protected NavigationGutterIconBuilder(@NotNull Icon icon2, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(1);
        }
        this(icon2, converter, null);
    }

    protected NavigationGutterIconBuilder(@NotNull Icon icon2, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(3);
        }
        this.myAlignment = GutterIconRenderer.Alignment.CENTER;
        this.myNamer = ElementPresentationManager.namer();
        this.myIcon = icon2;
        this.myConverter = converter;
        this.myGotoRelatedItemProvider = gotoRelatedItemProvider;
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon2) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(4);
        }
        return NavigationGutterIconBuilder.create(icon2, DEFAULT_PSI_CONVERTOR, PSI_GOTO_RELATED_ITEM_PROVIDER);
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon2, @NlsContexts.Separator String navigationGroup) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(5);
        }
        return NavigationGutterIconBuilder.create(icon2, DEFAULT_PSI_CONVERTOR, element -> List.of(new GotoRelatedItem(element, navigationGroup)));
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon2, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(6);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(7);
        }
        return NavigationGutterIconBuilder.create(icon2, converter, null);
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon2, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        if (icon2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(8);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(9);
        }
        return new NavigationGutterIconBuilder<T>(icon2, converter, gotoRelatedItemProvider);
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target) {
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = this.setTargets(ContainerUtil.createMaybeSingletonList(target));
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(10);
        }
        return navigationGutterIconBuilder;
    }

    @SafeVarargs
    @NotNull
    public final NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(11);
        }
        NavigationGutterIconBuilder<T> navigationGutterIconBuilder = this.setTargets((Collection<? extends T>)Arrays.asList(targets));
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(12);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(13);
        }
        this.myTargets = targets;
        this.myLazy = true;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(14);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull Collection<? extends T> targets) {
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(15);
        }
        if (ContainerUtil.containsIdentity(targets, null)) {
            throw new IllegalArgumentException("Must not pass collection with null target but got: " + targets);
        }
        this.myTargets = NotNullLazyValue.createConstantValue(targets);
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(16);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull @NlsContexts.Tooltip String tooltipText) {
        if (tooltipText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(17);
        }
        this.myTooltipText = tooltipText;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(18);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        if (alignment == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(19);
        }
        this.myAlignment = alignment;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(20);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull @NlsContexts.PopupTitle String popupTitle) {
        if (popupTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(21);
        }
        this.myPopupTitle = popupTitle;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(22);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull @NlsContexts.PopupContent String emptyText) {
        if (emptyText == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(23);
        }
        this.myEmptyText = emptyText;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(24);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull @NlsContexts.PopupTitle String tooltipTitle) {
        if (tooltipTitle == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(25);
        }
        this.myTooltipTitle = tooltipTitle;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(26);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<? super T, String> namer) {
        if (namer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(27);
        }
        this.myNamer = namer;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(28);
        }
        return navigationGutterIconBuilder;
    }

    @Deprecated
    @NotNull
    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer<?> cellRenderer) {
        if (cellRenderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(29);
        }
        this.myCellRenderer = new Computable.PredefinedValueComputable(cellRenderer);
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(30);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull Computable<PsiElementListCellRenderer<?>> cellRendererProvider) {
        if (cellRendererProvider == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(31);
        }
        this.myCellRenderer = cellRendererProvider;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(32);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargetRenderer(@NotNull Supplier<? extends PsiTargetPresentationRenderer<PsiElement>> cellRendererProvider) {
        if (cellRendererProvider == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(33);
        }
        this.myTargetRenderer = cellRendererProvider;
        NavigationGutterIconBuilder navigationGutterIconBuilder = this;
        if (navigationGutterIconBuilder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(34);
        }
        return navigationGutterIconBuilder;
    }

    @Deprecated
    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(35);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)this.createGutterIconRenderer(element.getProject(), null)).needsUpdateOnTyping(false).createAnnotation();
    }

    public void createGutterIcon(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(36);
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return;
        }
        NavigationGutterIconRenderer renderer2 = this.createGutterIconRenderer(element.getProject(), null);
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).gutterIconRenderer((GutterIconRenderer)renderer2).needsUpdateOnTyping(false).create();
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element) {
        NavigationGutterIconRenderer renderer2;
        if (element == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(37);
        }
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = this.createLineMarkerInfo(element, (renderer2 = this.createGutterIconRenderer(element.getProject(), null)).isNavigateAction() ? renderer2 : null);
        if (relatedItemLineMarkerInfo == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(38);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        if (element == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(39);
        }
        NavigationGutterIconRenderer renderer2 = this.createGutterIconRenderer(element.getProject(), navigationHandler);
        String tooltip2 = renderer2.getTooltipText();
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), renderer2.getIcon(), (Function)(tooltip2 == null ? null : new ConstantFunction((Object)tooltip2)), navigationHandler, renderer2.getAlignment(), () -> this.computeGotoTargets());
    }

    @NotNull
    protected Collection<GotoRelatedItem> computeGotoTargets() {
        if (this.myTargets == null || this.myGotoRelatedItemProvider == null) {
            List<GotoRelatedItem> list2 = Collections.emptyList();
            if (list2 == null) {
                NavigationGutterIconBuilder.$$$reportNull$$$0(40);
            }
            return list2;
        }
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        List list3 = ContainerUtil.concat((Iterable)((Iterable)factory.create()), this.myGotoRelatedItemProvider);
        if (list3 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(41);
        }
        return list3;
    }

    private void checkBuilt() {
        assert (this.myTargets != null) : "Must have called .setTargets() before calling create()";
    }

    @NotNull
    private static <T> NotNullFactory<T> evaluateAndForget(@NotNull NotNullLazyValue<T> lazyValue) {
        if (lazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(42);
        }
        final Ref ref = Ref.create(lazyValue);
        return new NotNullFactory<T>(){
            volatile T value;

            @NotNull
            public T create() {
                Object result2 = this.value;
                if (result2 == null) {
                    this.value = result2 = ((NotNullLazyValue)ref.get()).getValue();
                    ref.set(null);
                }
                Object t = result2;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$1", "create"));
            }
        };
    }

    @NotNull
    public NavigationGutterIconRenderer createGutterIconRenderer(@NotNull Project project2, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        boolean newUI;
        if (project2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(43);
        }
        this.checkBuilt();
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers = NavigationGutterIconBuilder.createPointersThunk(this.myLazy, project2, factory, this.myConverter);
        boolean empty2 = this.isEmpty();
        boolean bl = newUI = ExperimentalUI.isNewUI() && !ApplicationManager.getApplication().isUnitTestMode();
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text2 = (String)this.myNamer.fun(t);
                if (text2 == null) continue;
                names.add(newUI ? text2 : MessageFormat.format(PATTERN, text2));
            }
            @Nls StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name : names) {
                sb.append(name).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        Computable<PsiElementListCellRenderer<?>> renderer2 = this.myCellRenderer == null ? DefaultPsiElementCellRenderer::new : this.myCellRenderer;
        NavigationGutterIconRenderer gutterIconRenderer = this.createGutterIconRenderer(pointers, renderer2, empty2, navigationHandler);
        gutterIconRenderer.setProject(project2);
        gutterIconRenderer.setTargetRenderer(this.myTargetRenderer);
        NavigationGutterIconRenderer navigationGutterIconRenderer = gutterIconRenderer;
        if (navigationGutterIconRenderer == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(44);
        }
        return navigationGutterIconRenderer;
    }

    @NotNull
    protected NavigationGutterIconRenderer createGutterIconRenderer(@NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<? extends PsiElementListCellRenderer<?>> renderer2, boolean empty2, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        if (pointers == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(45);
        }
        if (renderer2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(46);
        }
        if (this.myLazy) {
            return this.createLazyGutterIconRenderer(pointers, renderer2, empty2, navigationHandler);
        }
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer2, empty2, navigationHandler);
    }

    @NotNull
    private NavigationGutterIconRenderer createLazyGutterIconRenderer(@NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<? extends PsiElementListCellRenderer<?>> renderer2, boolean empty2, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        if (pointers == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(47);
        }
        if (renderer2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(48);
        }
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer2, empty2, true, navigationHandler);
    }

    @NotNull
    private static <T> NotNullLazyValue<List<SmartPsiElementPointer<?>>> createPointersThunk(boolean lazy, Project project2, NotNullFactory<? extends Collection<? extends T>> targets, NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (!lazy) {
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.createConstantValue(NavigationGutterIconBuilder.calcPsiTargets(project2, (Collection)targets.create(), converter));
            if (notNullLazyValue == null) {
                NavigationGutterIconBuilder.$$$reportNull$$$0(49);
            }
            return notNullLazyValue;
        }
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> NavigationGutterIconBuilder.calcPsiTargets(project2, (Collection)targets.create(), converter));
        if (notNullLazyValue == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(50);
        }
        return notNullLazyValue;
    }

    @NotNull
    private static <T> List<SmartPsiElementPointer<?>> calcPsiTargets(@NotNull Project project2, @NotNull Collection<? extends T> targets, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (project2 == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(51);
        }
        if (targets == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(52);
        }
        if (converter == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(53);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        ArrayList list2 = new ArrayList(targets.size());
        for (T target : targets) {
            for (PsiElement psiElement : (Collection)converter.fun(target)) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(converter + " returned null element");
                }
                if (!elements.add(psiElement) || !psiElement.isValid()) continue;
                list2.add(manager.createSmartPsiElementPointer(psiElement));
            }
        }
        ArrayList arrayList = list2;
        if (arrayList == null) {
            NavigationGutterIconBuilder.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private boolean isEmpty() {
        if (this.myLazy) {
            return false;
        }
        Collection targets = (Collection)this.myTargets.getValue();
        return ContainerUtil.all((Collection)targets, target -> ((Collection)this.myConverter.fun(target)).isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 38, 40, 41, 44, 49, 50, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 49: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipTitle";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRendererProvider";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setTarget";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargets";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setTooltipText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setAlignment";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupTitle";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setEmptyPopupText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setTooltipTitle";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setNamer";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "setCellRenderer";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargetRenderer";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarkerInfo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "computeGotoTargets";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createGutterIconRenderer";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointersThunk";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPsiTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 49: 
            case 50: 
            case 54: {
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTargets";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setAlignment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setPopupTitle";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyPopupText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setTooltipTitle";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setNamer";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setTargetRenderer";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createGutterIcon";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndForget";
                break;
            }
            case 43: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createGutterIconRenderer";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createLazyGutterIconRenderer";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "calcPsiTargets";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 38, 40, 41, 44, 49, 50, 54 -> new IllegalStateException(string2);
        };
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final @NlsContexts.Tooltip String myTooltipText;
        private final boolean myEmpty;

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder2, @NotNull GutterIconRenderer.Alignment alignment, Icon icon2, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, boolean empty2, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
            if (builder2 == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(0);
            }
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(1);
            }
            if (pointers == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(2);
            }
            if (cellRenderer == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(3);
            }
            super(builder2.myPopupTitle, builder2.myEmptyText, cellRenderer, pointers, false, navigationHandler);
            this.myAlignment = alignment;
            this.myIcon = icon2;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty2;
        }

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder2, @NotNull GutterIconRenderer.Alignment alignment, Icon icon2, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, boolean empty2, boolean computeTargetsInBackground, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
            if (builder2 == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(4);
            }
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(5);
            }
            if (pointers == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(6);
            }
            if (cellRenderer == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(7);
            }
            super(builder2.myPopupTitle, builder2.myEmptyText, cellRenderer, pointers, computeTargetsInBackground, navigationHandler);
            this.myAlignment = alignment;
            this.myIcon = icon2;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty2;
        }

        @Override
        public boolean isNavigateAction() {
            return !this.myEmpty;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.myIcon;
            if (icon2 == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(8);
            }
            return icon2;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = this.myAlignment;
            if (alignment == null) {
                MyNavigationGutterIconRenderer.$$$reportNull$$$0(9);
            }
            return alignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)((Object)o);
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (!Objects.equals(this.myIcon, that.myIcon)) {
                return false;
            }
            return Objects.equals(this.myTooltipText, that.myTooltipText);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result2 = 31 * result2 + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result2 = 31 * result2 + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alignment";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointers";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cellRenderer";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 8, 9 -> new IllegalStateException(string2);
            };
        }
    }
}

