/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.html.webSymbols.elements.WebSymbolElementDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.XmlElementDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspectionBase
extends HtmlUnknownElementInspection {
    public static final Key<HtmlUnknownElementInspection> TAG_KEY = Key.create((String)"HtmlUnknownTag");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownTagInspectionBase.class);

    public HtmlUnknownTagInspectionBase(@NotNull String defaultValues) {
        if (defaultValues == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(0);
        }
        super(defaultValues);
    }

    public HtmlUnknownTagInspectionBase() {
        this("nobr,noembed,comment,noscript,embed,script");
    }

    private static boolean isAbstractDescriptor(XmlElementDescriptor descriptor) {
        return descriptor == null || descriptor instanceof AnyXmlElementDescriptor;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HtmlUnknownTag";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(1);
        }
        return logger;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        WebSymbolElementDescriptor webSymbolElementDescriptor;
        XmlElementDescriptor ownDescriptor;
        if (tag == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(3);
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        XmlElementDescriptor descriptorFromContext = XmlUtil.getDescriptorFromContext(tag);
        PsiElement parent = tag.getParent();
        XmlElementDescriptor parentDescriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        XmlElementDescriptor xmlElementDescriptor = ownDescriptor = HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext) ? tag.getDescriptor() : descriptorFromContext;
        if (ownDescriptor instanceof XmlElementDescriptorEx) {
            ((XmlElementDescriptorEx)ownDescriptor).validateTagName(tag, holder, isOnTheFly);
            return;
        }
        if (descriptorFromContext instanceof XmlElementDescriptorEx) {
            ((XmlElementDescriptorEx)descriptorFromContext).validateTagName(tag, holder, isOnTheFly);
            return;
        }
        if (HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) || (parentDescriptor instanceof HtmlElementDescriptorImpl || parentDescriptor instanceof WebSymbolElementDescriptor && !(webSymbolElementDescriptor = (WebSymbolElementDescriptor)parentDescriptor).isCustomElement()) && ownDescriptor instanceof HtmlElementDescriptorImpl && HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext)) {
            String name = tag.getName();
            if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                ProblemHighlightType highlightType;
                AddCustomHtmlElementIntentionAction action2 = new AddCustomHtmlElementIntentionAction(TAG_KEY, name, XmlAnalysisBundle.message("html.quickfix.add.custom.html.tag", name));
                String message2 = HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) ? XmlAnalysisBundle.message("xml.inspections.unknown.html.tag", name) : XmlAnalysisBundle.message("xml.inspections.element.is.not.allowed.here", name);
                XmlToken startTagName = XmlTagUtil.getStartTagNameElement(tag);
                assert (startTagName != null);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement(tag);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>();
                quickfixes.add(action2);
                if (isOnTheFly) {
                    PsiFile file = startTagName.getContainingFile();
                    if (file instanceof XmlFile) {
                        quickfixes.add(XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix(startTagName, "", null));
                    }
                    ContainerUtil.addIfNotNull(quickfixes, (Object)this.createChangeTemplateDataFix(file));
                }
                if (HtmlUtil.isHtml5Tag(name) && !HtmlUtil.hasNonHtml5Doctype(tag)) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                ProblemHighlightType problemHighlightType = highlightType = XmlUtil.isNotInjectedOrCustomHtmlFile(tag.getContainingFile()) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                if (isOnTheFly || highlightType != ProblemHighlightType.INFORMATION) {
                    if (startTagName.getTextLength() > 0) {
                        holder.registerProblem((PsiElement)startTagName, message2, highlightType, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                    if (endTagName != null) {
                        holder.registerProblem((PsiElement)endTagName, message2, highlightType, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        }
    }

    @Nullable
    protected LocalQuickFix createChangeTemplateDataFix(PsiFile file) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

