/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataSuitesManager;
import com.intellij.coverage.CoverageDataSuitesManagerKt;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00010B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015JY\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010\u0016\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#J[\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001fJ*\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\tJ\b\u0010(\u001a\u00020\u0002H\u0016J\u0011\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u0019\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u000e\u0010-\u001a\u00020 2\u0006\u0010!\u001a\u00020\tJ\b\u0010.\u001a\u00020 H\u0002J\b\u0010/\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a(\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n \f*\u0012\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "suites", "", "Lcom/intellij/coverage/CoverageSuite;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "addExternalCoverageSuite", "coverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "fileName", "", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timeStamp", "", "addSuite", "name", "filters", "", "lastCoverageTimeStamp", "suiteToMergeWith", "coverageByTestEnabled", "", "branchCoverage", "(Lcom/intellij/coverage/CoverageRunner;Ljava/lang/String;Lcom/intellij/coverage/CoverageFileProvider;[Ljava/lang/String;JLjava/lang/String;ZZ)Lcom/intellij/coverage/CoverageSuite;", "", "suite", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "createCoverageSuite", "runner", "Lcom/intellij/coverage/DefaultCoverageFileProvider;", "deleteSuite", "getState", "getSuites", "()[Lcom/intellij/coverage/CoverageSuite;", "loadState", "element", "removeSuite", "setUpEngineEPRemovedCallback", "setUpRunnerEPRemovedCallback", "Companion", "intellij.platform.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,190:1\n1#2:191\n37#3,2:192\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n*L\n94#1:192,2\n*E\n"})
public final class CoverageDataSuitesManager
implements PersistentStateComponent<Element>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<CoverageSuite> suites;

    public CoverageDataSuitesManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.suites = set;
        this.setUpRunnerEPRemovedCallback();
        this.setUpEngineEPRemovedCallback();
    }

    @Nullable
    public final CoverageSuite addSuite(@NotNull CoverageRunner coverageRunner, @NotNull String name, @NotNull CoverageFileProvider fileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, boolean coverageByTestEnabled, boolean branchCoverage) {
        CoverageSuite coverageSuite;
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        CoverageSuite coverageSuite2 = this.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, coverageByTestEnabled, branchCoverage);
        if (coverageSuite2 != null) {
            CoverageSuite coverageSuite3;
            CoverageSuite it = coverageSuite3 = coverageSuite2;
            boolean bl = false;
            this.addSuite(it, suiteToMergeWith);
            coverageSuite = coverageSuite3;
        } else {
            coverageSuite = null;
        }
        return coverageSuite;
    }

    public final void addSuite(@NotNull CoverageSuite suite, @Nullable String suiteToMergeWith) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        if (suiteToMergeWith == null || !Intrinsics.areEqual((Object)suite.getPresentableName(), (Object)suiteToMergeWith)) {
            this.deleteSuite(suite);
        }
        this.suites.remove(suite);
        this.suites.add(suite);
    }

    @Nullable
    public final CoverageSuite addExternalCoverageSuite(@NotNull CoverageRunner coverageRunner, @NotNull String fileName, @NotNull CoverageFileProvider fileProvider, long timeStamp) {
        CoverageSuite coverageSuite;
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        CoverageSuite coverageSuite2 = this.createCoverageSuite(coverageRunner, fileName, fileProvider, ArrayUtilRt.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        if (coverageSuite2 != null) {
            CoverageSuite coverageSuite3;
            CoverageSuite it = coverageSuite3 = coverageSuite2;
            boolean bl = false;
            this.suites.add(it);
            coverageSuite = coverageSuite3;
        } else {
            coverageSuite = null;
        }
        return coverageSuite;
    }

    @Nullable
    public final CoverageSuite addSuite(@NotNull CoverageEnabledConfiguration config) {
        CoverageSuite coverageSuite;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object[] objectArray = new Object[]{config.getName()};
        String string2 = CoverageBundle.message("coverage.results.suite.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String name = string2;
        String path2 = config.getCoverageFilePath();
        CoverageDataSuitesManagerKt.access$getLOG$p().assertTrue(path2 != null, (Object)("Configuration coverage report file is not configured " + config.getName()));
        CoverageRunner runner = config.getCoverageRunner();
        CoverageDataSuitesManagerKt.access$getLOG$p().assertTrue(runner != null, (Object)("Cannot find coverage runner id = " + config.getRunnerId()));
        if (runner == null || path2 == null) {
            return null;
        }
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(path2));
        CoverageSuite coverageSuite2 = this.createCoverageSuite(config, runner, name, fileProvider);
        if (coverageSuite2 != null) {
            CoverageSuite coverageSuite3;
            CoverageSuite it = coverageSuite3 = coverageSuite2;
            boolean bl = false;
            this.deleteSuite(it);
            this.suites.add(it);
            coverageSuite = coverageSuite3;
        } else {
            coverageSuite = null;
        }
        return coverageSuite;
    }

    public final void deleteSuite(@NotNull CoverageSuite suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        suite.deleteCachedCoverageData();
        this.removeSuite(suite);
    }

    public final void removeSuite(@NotNull CoverageSuite suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        this.suites.remove(suite);
    }

    @NotNull
    public final CoverageSuite[] getSuites() {
        Collection $this$toTypedArray$iv = this.suites;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CoverageSuite[0]);
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (Element suiteElement : element.getChildren("SUITE")) {
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) continue;
            CoverageSuite suite = null;
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(engine) || (suite = engine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(suite instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)suite).setProject(this.project);
                break;
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.suites.add(suite);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (CoverageSuite coverageSuite : this.suites) {
            Element suiteElement = new Element("SUITE");
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
        return element;
    }

    private final CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, CoverageRunner runner, String name, DefaultCoverageFileProvider fileProvider) {
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            CoverageSuite suite;
            if (!runner.acceptsCoverageEngine(engine) || !engine.isApplicableTo(config.getConfiguration()) || (suite = engine.createCoverageSuite(runner, name, fileProvider, config)) == null) continue;
            return suite;
        }
        CoverageDataSuitesManagerKt.access$getLOG$p().error("Cannot create coverage suite for runner: " + runner.getPresentableName());
        return null;
    }

    private final CoverageSuite createCoverageSuite(CoverageRunner runner, String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean coverageByTestEnabled, boolean branchCoverage) {
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            CoverageSuite suite;
            if (!runner.acceptsCoverageEngine(engine) || (suite = engine.createCoverageSuite(runner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, coverageByTestEnabled, branchCoverage, false, this.project)) == null) continue;
            return suite;
        }
        CoverageDataSuitesManagerKt.access$getLOG$p().error("Cannot create coverage suite for runner: " + runner.getPresentableName());
        return null;
    }

    private final void setUpRunnerEPRemovedCallback() {
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(@NotNull CoverageRunner extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                for (CoverageSuite suite : CoverageDataSuitesManager.access$getSuites$p(this.this$0)) {
                    if (!(suite instanceof BaseCoverageSuite) || suite.getRunner() != extension) continue;
                    ((BaseCoverageSuite)suite).setRunner(null);
                }
            }
        }, (Disposable)this);
    }

    private final void setUpEngineEPRemovedCallback() {
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(@NotNull CoverageEngine extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                CoverageDataSuitesManager.access$getSuites$p(this.this$0).removeIf(arg_0 -> setUpEngineEPRemovedCallback.1.extensionRemoved$lambda$0((Function1)new Function1<CoverageSuite, Boolean>(extension){
                    final /* synthetic */ CoverageEngine $extension;
                    {
                        this.$extension = $extension;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull CoverageSuite suite) {
                        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
                        return suite.getCoverageEngine() == this.$extension;
                    }
                }, arg_0));
            }

            private static final boolean extensionRemoved$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, (Disposable)this);
    }

    @JvmStatic
    @NotNull
    public static final CoverageDataSuitesManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ Set access$getSuites$p(CoverageDataSuitesManager $this) {
        return $this.suites;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/coverage/CoverageDataSuitesManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,190:1\n30#2,3:191\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n*L\n36#1:191,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CoverageDataSuitesManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CoverageDataSuitesManager> serviceClass$iv = CoverageDataSuitesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (CoverageDataSuitesManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

