/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(Repository::getPresentableUrl);

    @NotNull
    public static List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<? extends VirtualFile> virtualFiles2) {
        if (virtualFiles2 == null) {
            DvcsUtil.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.sorted(virtualFiles2, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<? extends File> files2) {
        if (files2 == null) {
            DvcsUtil.$$$reportNull$$$0(2);
        }
        RefreshVFsSynchronously.refreshFiles(files2);
        List list2 = ContainerUtil.mapNotNull(files2, file -> VfsUtil.findFileByIoFile((File)file, (boolean)false));
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NlsSafe
    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            DvcsUtil.$$$reportNull$$$0(4);
        }
        String string2 = VcsImplUtil.getShortVcsRootName(repository.getProject(), repository.getRoot());
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(6);
        }
        String string2 = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static <T extends Repository> void disableActionIfAnyRepositoryIsFresh(@NotNull AnActionEvent e, @NotNull List<T> repositories, @Nls String operationName) {
        boolean isFresh;
        if (e == null) {
            DvcsUtil.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(9);
        }
        if (isFresh = ContainerUtil.exists(repositories, Repository::isFresh)) {
            Presentation p = e.getPresentation();
            p.setEnabled(false);
            p.setDescription(DvcsBundle.messagePointer("action.not.possible.in.fresh.repo.description", operationName));
        }
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        String joined;
        if (messages == null) {
            DvcsUtil.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmptyOrSpaces((String)(joined = StringUtil.join(messages, (String)"\n"))) ? null : joined;
    }

    @Nullable
    @RequiresEdt
    public static VirtualFile getSelectedFile(@NotNull Project project2) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
        return fileEditor == null ? null : fileEditor.getFile();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static VirtualFile getSelectedFile(@NotNull DataContext dataProvider) {
        FileEditor fileEditor;
        if (dataProvider == null) {
            DvcsUtil.$$$reportNull$$$0(12);
        }
        return (fileEditor = (FileEditor)PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR.getData(dataProvider)) == null ? null : fileEditor.getFile();
    }

    @NlsSafe
    @NotNull
    public static String getShortHash(@NotNull String hash2) {
        if (hash2 == null) {
            DvcsUtil.$$$reportNull$$$0(13);
        }
        if (hash2.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash2 + "]");
        }
        if (hash2.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash2 + "]");
        }
        String string2 = VcsLogUtil.getShortHash(hash2);
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit2) {
        if (commit2 == null) {
            DvcsUtil.$$$reportNull$$$0(15);
        }
        String string2 = DateFormatUtil.formatPrettyDateTime((long)commit2.getTimestamp()) + " ";
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project2) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(17);
        }
        return DvcsUtil.workingTreeChangeStarted(project2, null);
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project2, @Nullable @Nls String activityName) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(18);
        }
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project2, activityName);
        return new AccessToken(){

            public void finish() {
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project2);
            }
        };
    }

    public static void assertFileExists(File file, @NonNls @Nls String message2) throws IllegalStateException {
        if (!file.exists()) {
            throw new IllegalStateException(message2);
        }
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(19);
        }
        return DvcsUtil.tryLoadFile(file, null);
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file, @Nullable String encoding) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(20);
        }
        String string2 = DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file, (String)encoding)).trim(), file);
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NlsSafe
    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable @NlsSafe String defaultValue) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(22);
        }
        return DvcsUtil.tryLoadFileOrReturn(file, defaultValue, null);
    }

    @NlsSafe
    @Nullable
    @Contract(value="_ , !null, _ -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable @NlsSafe String defaultValue, @Nullable @NonNls String encoding) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(23);
        }
        try {
            return DvcsUtil.tryLoadFile(file, encoding);
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return defaultValue;
        }
    }

    public static <T> T tryOrThrow(Callable<? extends T> actionToTry, Object details) throws RepoStateException {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + details, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + details, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + details, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            DvcsUtil.$$$reportNull$$$0(24);
        }
        if (subDirs == null) {
            DvcsUtil.$$$reportNull$$$0(25);
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)CommonProcessors.alwaysTrue());
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project2, @NotNull @NonNls String newRepositoryPath, @NotNull @NonNls String vcsName) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(26);
        }
        if (newRepositoryPath == null) {
            DvcsUtil.$$$reportNull$$$0(27);
        }
        if (vcsName == null) {
            DvcsUtil.$$$reportNull$$$0(28);
        }
        if (!project2.isDisposed() && project2.getBasePath() != null && FileUtil.isAncestor((String)project2.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project2);
            manager.setDirectoryMappings(VcsUtil.addMapping(manager.getDirectoryMappings(), newRepositoryPath, vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessWidgetRepository(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls @SystemIndependent String recentRootPath, @Nullable VirtualFile selectedFile) {
        T repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(29);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(30);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, selectedFile))) != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), recentRootPath));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Nullable
    public static <T extends Repository> T guessWidgetRepository(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls @SystemIndependent String recentRootPath, @NotNull DataContext dataContext) {
        VirtualFile file;
        T repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(31);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(32);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(33);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, file = DvcsUtil.getSelectedFile(dataContext)))) != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), recentRootPath));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Nullable
    @RequiresEdt
    public static <T extends Repository> T guessRepositoryForOperation(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(34);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project2).add(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR, (Object)FileEditorManager.getInstance((Project)project2).getSelectedEditor()).build();
        return DvcsUtil.guessRepositoryForOperation(project2, manager, dataContext);
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForOperation(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @NotNull DataContext dataContext) {
        VirtualFile file;
        T repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(36);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(37);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(38);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, file = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            return repository;
        }
        file = DvcsUtil.getSelectedFile(dataContext);
        repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, file));
        if (repository != null) {
            return repository;
        }
        repository = manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), null));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Nullable
    public static Repository guessRepositoryForOperation(@NotNull Project project2, @NotNull DataContext dataContext) {
        VirtualFile file;
        VcsRepositoryManager manager;
        Repository repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(39);
        }
        if (dataContext == null) {
            DvcsUtil.$$$reportNull$$$0(40);
        }
        if ((repository = (manager = VcsRepositoryManager.getInstance(project2)).getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, file = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            return repository;
        }
        VirtualFile selectedFile = DvcsUtil.getSelectedFile(dataContext);
        repository = manager.getRepositoryForRootQuick(DvcsUtil.findVcsRootFor(project2, selectedFile));
        if (repository != null) {
            return repository;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project2, @NotNull RepositoryManager<T> manager, @Nullable VirtualFile file, @Nullable @NonNls String defaultRootPathValue) {
        T repository;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(41);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(42);
        }
        if ((repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project2, file))) != null) {
            return repository;
        }
        return manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue));
    }

    @Deprecated
    @Nullable
    @RequiresEdt
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @Nullable @NonNls String defaultRootPathValue) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(43);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        T repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project2, DvcsUtil.getSelectedFile(project2)));
        if (repository != null) {
            return repository;
        }
        return manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project2, @NotNull AbstractVcs vcs, @Nullable @NonNls String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(45);
        }
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(46);
        }
        if (project2.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
        String vcsName = vcs.getDisplayName();
        Object[] vcsRoots = vcsManager2.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && ArrayUtil.contains((Object)(recentRoot = VcsUtil.getVirtualFile(defaultRootPathValue)), (Object[])vcsRoots)) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project2.getBaseDir();
        if (projectBaseDir == null) {
            Object firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + (VirtualFile)firstRoot);
            return firstRoot;
        }
        for (Object root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + (VirtualFile)root);
            return root;
        }
        Object rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + (VirtualFile)rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<? extends T> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(47);
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        return ContainerUtil.sorted((Collection)validRepositories, REPOSITORY_COMPARATOR);
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project2, @NotNull VirtualFile file) {
        ProjectLevelVcsManager vcsManager2;
        VirtualFile root;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(48);
        }
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(49);
        }
        if ((root = (vcsManager2 = ProjectLevelVcsManager.getInstance(project2)).getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file))) != null) {
            LOG.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries2 = ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> modulesVcsRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry2 : entries2) {
            VirtualFile moduleVcsRoot;
            if (!(entry2 instanceof LibraryOrderEntry) && !(entry2 instanceof JdkOrderEntry) || (moduleVcsRoot = vcsManager2.getVcsRootFor(entry2.getOwnerModule().getModuleFile())) == null) continue;
            modulesVcsRoots.add(moduleVcsRoot);
        }
        if (modulesVcsRoots.isEmpty()) {
            LOG.debug("No library roots");
            return null;
        }
        VirtualFile topRoot = null;
        for (VirtualFile vcsRoot : modulesVcsRoots) {
            if (topRoot != null && !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)topRoot, (boolean)true)) continue;
            topRoot = vcsRoot;
        }
        LOG.debug("Several library roots, returning " + topRoot);
        return topRoot;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(50);
        }
        return DvcsUtil.findVcsRootFor(project2, file);
    }

    @Nullable
    public static VirtualFile findVcsRootFor(@NotNull Project project2, @Nullable VirtualFile file) {
        VirtualFile root;
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(51);
        }
        if ((root = ProjectLevelVcsManager.getInstance(project2).getVcsRootFor(file)) != null) {
            return root;
        }
        if (file != null && (root = DvcsUtil.getVcsRootForLibraryFile(project2, file)) != null) {
            return root;
        }
        return null;
    }

    @NotNull
    @RequiresBackgroundThread
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsFullCommitDetails> commits2) {
        if (repoManager == null) {
            DvcsUtil.$$$reportNull$$$0(52);
        }
        if (commits2 == null) {
            DvcsUtil.$$$reportNull$$$0(53);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        HashMap<Repository, List> groupedCommits = new HashMap<Repository, List>();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits2) {
            R repository = repoManager.getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOG.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = groupedCommits.computeIfAbsent((Repository)repository, __ -> new ArrayList());
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap<Repository, List> hashMap = groupedCommits;
        if (hashMap == null) {
            DvcsUtil.$$$reportNull$$$0(54);
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(55);
        }
        return (PushSupport)ContainerUtil.find((Object[])((PushSupport[])PushSupport.PUSH_SUPPORT_EP.getExtensions((AreaInstance)vcs.getProject())), support -> support.getVcs().equals(vcs));
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(56);
        }
        return DvcsUtil.joinShortNames(repositories, -1);
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(57);
        }
        return DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
    }

    @Nls
    @NotNull
    public static String joinWithAnd(@NotNull List<@Nls String> strings, int limit) {
        if (strings == null) {
            DvcsUtil.$$$reportNull$$$0(58);
        }
        String string2 = VcsUtil.joinWithAnd(strings, limit);
        if (string2 == null) {
            DvcsUtil.$$$reportNull$$$0(59);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 14, 16, 21, 54, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 21: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 9: 
            case 47: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositoryPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 33: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoManager";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVirtualFilesByPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFilesWithRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRepositoryName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateString";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadFile";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "groupCommitsByRoots";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortVirtualFilesByPresentation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 21: 
            case 54: 
            case 59: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFilesWithRefresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortRepositoryName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShortNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disableActionIfAnyRepositoryIsFresh";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinMessagesOrNull";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDateString";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeStarted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFileOrReturn";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitVcsDirVfs";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addMappingIfSubRoot";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "guessWidgetRepository";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForOperation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForFile";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepositoryQuick";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "guessRootForVcs";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sortRepositories";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootForLibraryFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "guessVcsRoot";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findVcsRootFor";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "groupCommitsByRoots";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupport";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "joinShortNames";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 5, 7, 14, 16, 21, 54, 59 -> new IllegalStateException(string2);
        };
    }
}

