/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareBranchesDiffPanel
extends JPanel
implements DataProvider {
    public static final DataKey<CompareBranchesDiffPanel> DATA_KEY = DataKey.create((String)"com.intellij.dvcs.ui.CompareBranchesDiffPanel");
    @NlsSafe
    private final String myBranchName;
    private final Project myProject;
    @NlsSafe
    private final String myCurrentBranchName;
    private final DvcsCompareSettings myVcsSettings;
    @Nullable
    private CommitCompareInfo myCompareInfo;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public CompareBranchesDiffPanel(@NotNull Project project2, @NotNull DvcsCompareSettings settings, @NotNull String branchName, @NotNull String currentBranchName) {
        if (project2 == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(1);
        }
        if (branchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(2);
        }
        if (currentBranchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myCurrentBranchName = currentBranchName;
        this.myBranchName = branchName;
        this.myVcsSettings = settings;
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(@Nls String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(HTMLEditorKitBuilder.simple());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.setFocusable(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompareBranchesDiffPanel.this.swapSides();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$2", "hyperlinkActivated"));
            }
        });
        this.updateLabelText();
        this.myChangesBrowser = new MyChangesBrowser(project2, Collections.emptyList());
        this.myChangesBrowser.getViewer().setTreeStateStrategy(ChangesTree.KEEP_NON_EMPTY);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)this.myChangesBrowser, "Center");
    }

    @RequiresEdt
    public void setCompareInfo(@NotNull CommitCompareInfo compareInfo) {
        if (compareInfo == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCompareInfo = compareInfo;
        this.refreshView(false);
    }

    @NotNull
    public ChangesBrowserBase getChangesBrowser() {
        MyChangesBrowser myChangesBrowser = this.myChangesBrowser;
        if (myChangesBrowser == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(5);
        }
        return myChangesBrowser;
    }

    private void swapSides() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
        this.refreshView(true);
    }

    private void refreshView(boolean onSwapSides) {
        if (this.myCompareInfo == null) {
            return;
        }
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        this.updateLabelText();
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = DvcsBranchUtil.swapRevisions(diff);
        }
        if (onSwapSides) {
            this.myChangesBrowser.setChangesToDisplay(diff, new OnSwapSidesTreeStateStrategy());
        } else {
            this.myChangesBrowser.setChangesToDisplay(diff);
        }
    }

    private void updateLabelText() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        HtmlChunk.Element branchNameText = HtmlChunk.text((String)this.myBranchName).code().bold();
        HtmlChunk.Element currentBranchNameText = HtmlChunk.text((String)this.myCurrentBranchName).code().bold();
        String diffBetween = swapSides ? DvcsBundle.message("compare.branches.diff.panel.diff.between.files.in.branch.and.current.working.tree.on.branch", branchNameText, currentBranchNameText) : DvcsBundle.message("compare.branches.diff.panel.difference.between.current.working.tree.on.branch.and.files.in.branch", currentBranchNameText, branchNameText);
        String swapBranches = DvcsBundle.message("compare.branches.diff.panel.swap.branches", new Object[0]);
        this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)(diffBetween + "&emsp;" + HtmlChunk.link((String)"", (String)swapBranches))));
    }

    public void setEmptyText(@NotNull @NlsContexts.Label String text2) {
        if (text2 == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(6);
        }
        this.myChangesBrowser.getViewer().setEmptyText(text2);
    }

    public void disableControls() {
        this.myLabel.setEnabled(false);
    }

    public void enableControls() {
        this.myLabel.setEnabled(true);
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        JComponent jComponent = this.myChangesBrowser.getPreferredFocusedComponent();
        if (jComponent == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(8);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCompareInfo";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 7 -> new IllegalStateException(string2);
        };
    }

    private static class MyChangesBrowser
    extends SimpleAsyncChangesBrowser {
        MyChangesBrowser(@NotNull Project project2, @NotNull List<? extends Change> changes) {
            if (project2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project2, false, true);
            this.setChangesToDisplay(changes);
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.GetVersion")});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.GetVersion")});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class OnSwapSidesTreeStateStrategy
    implements ChangesTree.TreeStateStrategy<MyState> {
        private OnSwapSidesTreeStateStrategy() {
        }

        @Override
        public MyState saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                OnSwapSidesTreeStateStrategy.$$$reportNull$$$0(0);
            }
            List<Change> changes = VcsTreeModelData.selected((JTree)((Object)tree2)).userObjects(Change.class);
            return new MyState(changes);
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, MyState state, boolean scrollToSelection) {
            if (tree2 == null) {
                OnSwapSidesTreeStateStrategy.$$$reportNull$$$0(1);
            }
            if (state != null && !state.selectedChanges.isEmpty()) {
                tree2.setSelectedChanges(DvcsBranchUtil.swapRevisions(state.selectedChanges));
            } else {
                tree2.resetTreeState();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private record MyState(@NotNull List<Change> selectedChanges) {
            @NotNull
            private final List<Change> selectedChanges;

            private MyState(@NotNull List<Change> selectedChanges) {
                if (selectedChanges == null) {
                    MyState.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public List<Change> selectedChanges() {
                List<Change> list2 = this.selectedChanges;
                if (list2 == null) {
                    MyState.$$$reportNull$$$0(1);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedChanges";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy$MyState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy$MyState";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }
    }

    public static class GetVersionActionProvider
    implements AnActionExtensionProvider {
        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(0);
            }
            return e.getData(DATA_KEY) != null;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GetVersionActionProvider.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(2);
            }
            CompareBranchesDiffPanel panel2 = (CompareBranchesDiffPanel)e.getRequiredData(DATA_KEY);
            Presentation presentation2 = e.getPresentation();
            presentation2.setText(DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action", new Object[0]));
            presentation2.setDescription(DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action.description", panel2.myBranchName));
            boolean isEnabled = !panel2.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible2 = panel2.myCompareInfo instanceof LocalCommitCompareInfo;
            presentation2.setEnabled(isEnabled && isVisible2);
            presentation2.setVisible(isVisible2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(3);
            }
            final CompareBranchesDiffPanel panel2 = (CompareBranchesDiffPanel)e.getRequiredData(DATA_KEY);
            Project project2 = panel2.myProject;
            final List<Change> changes = panel2.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = panel2.myVcsSettings.shouldSwapSidesInCompareBranches();
            final CommitCompareInfo compareInfo = panel2.myCompareInfo;
            String title2 = DvcsBundle.message("compare.branches.diff.panel.get.from.branch.title", panel2.myBranchName);
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project2, title2);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges(changes))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action2 = LocalHistory.getInstance().startAction(title2);
            new Task.Modal(project2, DvcsBundle.message("compare.branches.diff.panel.loading.content.from.branch.process", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (compareInfo != null) {
                            ((LocalCommitCompareInfo)compareInfo).copyChangesFromBranch(changes, swapSides);
                        }
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)DvcsBundle.message("compare.branches.diff.panel.can.not.copy.changes.error", new Object[0])));
                    }
                }

                public void onFinished() {
                    action2.finish();
                    panel2.refreshView(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isActive";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

