/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsonStructureViewElement
implements StructureViewTreeElement {
    private final JsonElement myElement;

    public JsonStructureViewElement(@NotNull JsonElement element) {
        if (element == null) {
            JsonStructureViewElement.$$$reportNull$$$0(0);
        }
        assert (PsiTreeUtil.instanceOf((Object)element, (Class[])new Class[]{JsonFile.class, JsonProperty.class, JsonObject.class, JsonArray.class}));
        this.myElement = element;
    }

    public JsonElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation presentation2 = this.myElement.getPresentation();
        assert (presentation2 != null);
        ItemPresentation itemPresentation = presentation2;
        if (itemPresentation == null) {
            JsonStructureViewElement.$$$reportNull$$$0(1);
        }
        return itemPresentation;
    }

    public TreeElement @NotNull [] getChildren() {
        JsonElement value2 = null;
        if (this.myElement instanceof JsonFile) {
            value2 = ((JsonFile)this.myElement).getTopLevelValue();
        } else if (this.myElement instanceof JsonProperty) {
            value2 = ((JsonProperty)this.myElement).getValue();
        } else if (PsiTreeUtil.instanceOf((Object)this.myElement, (Class[])new Class[]{JsonObject.class, JsonArray.class})) {
            value2 = this.myElement;
        }
        if (value2 instanceof JsonObject) {
            JsonObject object = (JsonObject)value2;
            TreeElement[] treeElementArray = (TreeElement[])ContainerUtil.map2Array(object.getPropertyList(), TreeElement.class, property2 -> new JsonStructureViewElement((JsonElement)property2));
            if (treeElementArray == null) {
                JsonStructureViewElement.$$$reportNull$$$0(2);
            }
            return treeElementArray;
        }
        if (value2 instanceof JsonArray) {
            JsonArray array = (JsonArray)value2;
            List childObjects = ContainerUtil.mapNotNull(array.getValueList(), value1 -> {
                if (value1 instanceof JsonObject && !((JsonObject)value1).getPropertyList().isEmpty()) {
                    return new JsonStructureViewElement((JsonElement)value1);
                }
                if (value1 instanceof JsonArray && PsiTreeUtil.findChildOfType((PsiElement)value1, JsonProperty.class) != null) {
                    return new JsonStructureViewElement((JsonElement)value1);
                }
                return null;
            });
            TreeElement[] treeElementArray = childObjects.toArray(TreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                JsonStructureViewElement.$$$reportNull$$$0(3);
            }
            return treeElementArray;
        }
        if (EMPTY_ARRAY == null) {
            JsonStructureViewElement.$$$reportNull$$$0(4);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/structureView/JsonStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/structureView/JsonStructureViewElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

