/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineStatusClientIdTrackerKt;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedLocalChangeListDiffViewer
extends UnifiedDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private final LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;
    private final GutterCheckboxMouseMotionListener myGutterCheckboxMouseMotionListener;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    public UnifiedLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])new UserDataHolder[]{context});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel((DiffViewerBase)this, this.getEditor());
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.myLocalRequest);
        this.myGutterCheckboxMouseMotionListener = new GutterCheckboxMouseMotionListener();
        this.myGutterCheckboxMouseMotionListener.install();
        for (AnAction action2 : LocalTrackerDiffUtil.createTrackerShortcutOnlyActions(this.myTrackerActionProvider)) {
            DiffUtil.registerAction((AnAction)action2, (JComponent)this.myPanel);
        }
    }

    @Nullable
    protected JComponent createTitles() {
        JComponent titles = super.createTitles();
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles != null) {
            titleWithCheckbox.addToCenter((Component)titles);
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        return titleWithCheckbox;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>(super.createEditorPopupActions());
        group2.addAll(LocalTrackerDiffUtil.createTrackerEditorPopupActions(this.myTrackerActionProvider));
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected UnifiedDiffChangeUi createUi(@NotNull UnifiedDiffChange change) {
        if (change == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        if (change instanceof MyUnifiedDiffChange) {
            return new MyUnifiedDiffChangeUi(this, (MyUnifiedDiffChange)change);
        }
        UnifiedDiffChangeUi unifiedDiffChangeUi = super.createUi(change);
        if (unifiedDiffChangeUi == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        return unifiedDiffChangeUi;
    }

    @Nullable
    @Nls
    protected String getStatusTextMessage() {
        List allChanges = this.getDiffChanges();
        if (this.myAllowExcludeChangesFromCommit && allChanges != null) {
            int totalCount = 0;
            int includedIntoCommitCount = 0;
            int excludedCount = 0;
            for (UnifiedDiffChange change : allChanges) {
                RangeExclusionState.Included exclusionState;
                if (change instanceof MyUnifiedDiffChange) {
                    MyUnifiedDiffChange myChange = (MyUnifiedDiffChange)change;
                    exclusionState = myChange.getExclusionState();
                } else {
                    exclusionState = RangeExclusionState.Included.INSTANCE;
                }
                totalCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                if (change.isSkipped()) {
                    excludedCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                    continue;
                }
                includedIntoCommitCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)true);
            }
            return LocalTrackerDiffUtil.getStatusText(totalCount, includedIntoCommitCount, excludedCount, this.myModel.isContentsEqual());
        }
        return super.getStatusTextMessage();
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(5);
        }
        Runnable runnable = super.computeDifferences(indicator);
        if (runnable == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(7);
        }
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        Runnable runnable = LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), document1, document2, this.myLocalRequest.getChangelistId(), this.myAllowExcludeChangesFromCommit, (TwosideTextDiffProvider)this.myTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(document1, document2, indicator));
        if (runnable == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    protected void clearDiffPresentation() {
        super.clearDiffPresentation();
        for (RangeHighlighter operation : this.myHighlighters) {
            operation.dispose();
        }
        this.myHighlighters.clear();
        this.myGutterCheckboxMouseMotionListener.destroyHoverHighlighter();
    }

    @NotNull
    private Runnable applyGutterOperations(@NotNull UnifiedFragmentBuilder builder2, @NotNull List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges) {
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(9);
        }
        if (toggleableLineRanges == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(10);
        }
        Runnable runnable = () -> {
            if (this.myAllowExcludeChangesFromCommit) {
                for (LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange : toggleableLineRanges) {
                    this.myHighlighters.addAll(this.createGutterToggleRenderers(builder2, toggleableLineRange));
                }
            }
            for (LocalTrackerDiffUtil.ToggleableLineRange range : toggleableLineRanges) {
                ContainerUtil.addIfNotNull(this.myHighlighters, (Object)this.createClientIdHighlighter(builder2, range));
            }
            if (!this.myHighlighters.isEmpty()) {
                this.getEditor().getGutterComponentEx().revalidateMarkup();
            }
        };
        if (runnable == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    private List<RangeHighlighter> createGutterToggleRenderers(@NotNull UnifiedFragmentBuilder builder2, @NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        LocalTrackerDiffUtil.LineFragmentData fragmentData;
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(12);
        }
        if (toggleableLineRange == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(13);
        }
        if (!(fragmentData = toggleableLineRange.getFragmentData()).isFromActiveChangelist()) {
            List<RangeHighlighter> list2 = Collections.emptyList();
            if (list2 == null) {
                UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(14);
            }
            return list2;
        }
        ArrayList<RangeHighlighter> result2 = new ArrayList<RangeHighlighter>();
        RangeExclusionState exclusionState = fragmentData.getExclusionState();
        if (fragmentData.isPartiallyExcluded()) {
            RangeExclusionState.Partial partialExclusionState = (RangeExclusionState.Partial)exclusionState;
            Range lineRange = toggleableLineRange.getLineRange();
            partialExclusionState.iterateDeletionOffsets((start2, end, isIncluded) -> {
                for (int i = start2.intValue(); i < end; ++i) {
                    result2.add(this.createLineCheckboxToggleHighlighter(builder2, i + lineRange.start1, Side.LEFT, isIncluded == false));
                }
                return null;
            });
            partialExclusionState.iterateAdditionOffsets((start2, end, isIncluded) -> {
                for (int i = start2.intValue(); i < end; ++i) {
                    result2.add(this.createLineCheckboxToggleHighlighter(builder2, i + lineRange.start2, Side.RIGHT, isIncluded == false));
                }
                return null;
            });
        } else {
            result2.add(this.createBlockCheckboxToggleHighlighter(builder2, toggleableLineRange));
        }
        if (LocalTrackerDiffUtil.shouldShowToggleAreaThumb(toggleableLineRange)) {
            ContainerUtil.addIfNotNull(result2, (Object)this.createToggleAreaThumb(builder2, toggleableLineRange));
        }
        ArrayList<RangeHighlighter> arrayList = result2;
        if (arrayList == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private RangeHighlighter createBlockCheckboxToggleHighlighter(@NotNull UnifiedFragmentBuilder builder2, @NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(16);
        }
        if (toggleableLineRange == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(17);
        }
        Side side = Side.RIGHT;
        int line = LocalTrackerDiffUtil.getSingleCheckBoxLine(toggleableLineRange, side);
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        LineNumberConvertor lineConvertor = (LineNumberConvertor)side.select((Object)builder2.getConvertor1(), (Object)builder2.getConvertor2());
        int editorLine = lineConvertor.convertApproximateInv(line);
        RangeHighlighter rangeHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(this.getEditor(), editorLine, isExcludedFromCommit, () -> LocalTrackerDiffUtil.toggleBlockExclusion(this.myTrackerActionProvider, line, isExcludedFromCommit));
        if (rangeHighlighter == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(18);
        }
        return rangeHighlighter;
    }

    @NotNull
    private RangeHighlighter createLineCheckboxToggleHighlighter(@NotNull UnifiedFragmentBuilder builder2, int line, @NotNull Side side, boolean isExcludedFromCommit) {
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(19);
        }
        if (side == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(20);
        }
        LineNumberConvertor lineConvertor = (LineNumberConvertor)side.select((Object)builder2.getConvertor1(), (Object)builder2.getConvertor2());
        int editorLine = lineConvertor.convertApproximateInv(line);
        RangeHighlighter rangeHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(this.getEditor(), editorLine, isExcludedFromCommit, () -> LocalTrackerDiffUtil.toggleLinePartialExclusion(this.myTrackerActionProvider, line, side, isExcludedFromCommit));
        if (rangeHighlighter == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(21);
        }
        return rangeHighlighter;
    }

    @Nullable
    private RangeHighlighter createToggleAreaThumb(@NotNull UnifiedFragmentBuilder builder2, @NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(22);
        }
        if (toggleableLineRange == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(23);
        }
        Range lineRange = toggleableLineRange.getLineRange();
        int line1 = builder2.getConvertor1().convertApproximateInv(lineRange.start1);
        int line2 = builder2.getConvertor2().convertApproximateInv(lineRange.end2);
        if (line1 < 0 || line2 < 0 || line2 <= line1 || line2 > DiffUtil.getLineCount((Document)this.myDocument)) {
            LOG.warn("Failed to show toggle area thumb");
            return null;
        }
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        return LocalTrackerDiffUtil.createToggleAreaThumb(this.getEditor(), line1, line2, () -> LocalTrackerDiffUtil.toggleBlockExclusion(this.myTrackerActionProvider, lineRange.start1, isExcludedFromCommit));
    }

    @Nullable
    private RangeHighlighter createClientIdHighlighter(@NotNull UnifiedFragmentBuilder builder2, @NotNull LocalTrackerDiffUtil.ToggleableLineRange range) {
        List<ClientId> clientIds;
        if (builder2 == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(24);
        }
        if (range == null) {
            UnifiedLocalChangeListDiffViewer.$$$reportNull$$$0(25);
        }
        if ((clientIds = range.getFragmentData().getClientIds()).isEmpty()) {
            return null;
        }
        GutterIconRenderer iconRenderer = LineStatusClientIdTrackerKt.createClientIdGutterIconRenderer(this.myLocalRequest.getProject(), clientIds);
        if (iconRenderer == null) {
            return null;
        }
        Range lineRange = range.getLineRange();
        int line1 = builder2.getConvertor1().convertApproximateInv(lineRange.start1);
        int line2 = builder2.getConvertor2().convertApproximateInv(lineRange.end2);
        if (line1 < 0 || line2 < 0 || line2 <= line1 || line2 > DiffUtil.getLineCount((Document)this.myDocument)) {
            LOG.warn("Failed to show toggle area thumb");
            return null;
        }
        EditorEx editor = this.getEditor();
        TextRange textRange = DiffUtil.getLinesRange((Document)editor.getDocument(), (int)line1, (int)line2);
        return editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.LINES_IN_RANGE, false, rangeHighlighterEx -> {
            rangeHighlighterEx.setGreedyToLeft(true);
            rangeHighlighterEx.setGreedyToRight(true);
            rangeHighlighterEx.setGutterIconRenderer(iconRenderer);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 11, 14, 15, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toggleableLineRanges";
                break;
            }
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toggleableLineRange";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "superComputeDifferences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGutterOperations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGutterToggleRenderers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockCheckboxToggleHighlighter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCheckboxToggleHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "superComputeDifferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyGutterOperations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGutterToggleRenderers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCheckboxToggleHighlighter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLineCheckboxToggleHighlighter";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createToggleAreaThumb";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createClientIdHighlighter";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 8, 11, 14, 15, 18, 21 -> new IllegalStateException(string2);
        };
    }

    private static final class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final UnifiedLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            if (viewer == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(0);
            }
            if (localRequest == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(1);
            }
            super((DiffViewerBase)viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(2);
            }
            if (!this.myViewer.isContentGood()) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges()).select(MyUnifiedDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine1()), this.myViewer.transferLineFromOneside(Side.RIGHT, it.getLine2()), it.getChangelistId(), it.getExclusionState())).toList();
        }

        @Override
        @Nullable
        public LocalTrackerDiffUtil.SelectedTrackerLine getSelectedTrackerLines(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(3);
            }
            if (!this.myViewer.isContentGood()) {
                return null;
            }
            BitSet deletions = new BitSet();
            BitSet additions = new BitSet();
            DiffUtil.getSelectedLines((Editor)this.myViewer.getEditor()).stream().forEach(line -> {
                int line2;
                int line1 = this.myViewer.transferLineFromOnesideStrict(Side.LEFT, line);
                if (line1 != -1) {
                    deletions.set(line1);
                }
                if ((line2 = this.myViewer.transferLineFromOnesideStrict(Side.RIGHT, line)) != -1) {
                    additions.set(line2);
                }
            });
            return new LocalTrackerDiffUtil.SelectedTrackerLine(deletions, additions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRequest";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerActionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerLines";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GutterCheckboxMouseMotionListener {
        @Nullable
        private RangeHighlighter myHighlighter;

        private GutterCheckboxMouseMotionListener() {
        }

        public void install() {
            MyGutterMouseListener listener2 = new MyGutterMouseListener();
            UnifiedLocalChangeListDiffViewer.this.myEditor.getGutterComponentEx().addMouseListener((MouseListener)listener2);
            UnifiedLocalChangeListDiffViewer.this.myEditor.getGutterComponentEx().addMouseMotionListener((MouseMotionListener)listener2);
        }

        public void destroyHoverHighlighter() {
            if (this.myHighlighter != null) {
                this.myHighlighter.dispose();
                this.myHighlighter = null;
            }
        }

        private void updateHoverHighlighter(int editorLine) {
            Side side;
            int line;
            List changes = UnifiedLocalChangeListDiffViewer.this.getDiffChanges();
            if (changes == null) {
                this.destroyHoverHighlighter();
                return;
            }
            MyUnifiedDiffChange change = (MyUnifiedDiffChange)((Object)ObjectUtils.tryCast((Object)ContainerUtil.find((Iterable)changes, it -> it.getLine1() <= editorLine && it.getLine2() > editorLine), MyUnifiedDiffChange.class));
            if (change == null || change.isPartiallyExcluded() || !UnifiedLocalChangeListDiffViewer.this.myLocalRequest.getChangelistId().equals(change.getChangelistId())) {
                this.destroyHoverHighlighter();
                return;
            }
            int rightLine = UnifiedLocalChangeListDiffViewer.this.transferLineFromOnesideStrict(Side.RIGHT, editorLine);
            int leftLine = UnifiedLocalChangeListDiffViewer.this.transferLineFromOnesideStrict(Side.LEFT, editorLine);
            if (rightLine != -1) {
                line = rightLine;
                side = Side.RIGHT;
            } else if (leftLine != -1) {
                line = leftLine;
                side = Side.LEFT;
            } else {
                this.destroyHoverHighlighter();
                return;
            }
            if (LocalTrackerDiffUtil.hasIconHighlighters(UnifiedLocalChangeListDiffViewer.this.myProject, UnifiedLocalChangeListDiffViewer.this.myEditor, editorLine)) {
                if (this.myHighlighter != null && UnifiedLocalChangeListDiffViewer.this.myEditor.getDocument().getLineNumber(this.myHighlighter.getStartOffset()) != editorLine) {
                    this.destroyHoverHighlighter();
                }
                return;
            }
            this.destroyHoverHighlighter();
            boolean isExcludedFromCommit = change.getExclusionState() instanceof RangeExclusionState.Excluded;
            this.myHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(UnifiedLocalChangeListDiffViewer.this.myEditor, editorLine, isExcludedFromCommit, () -> {
                LocalTrackerDiffUtil.toggleLinePartialExclusion(UnifiedLocalChangeListDiffViewer.this.myTrackerActionProvider, line, side, isExcludedFromCommit);
                this.destroyHoverHighlighter();
            });
        }

        private class MyGutterMouseListener
        extends MouseAdapter {
            private MyGutterMouseListener() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int xOffset;
                if (!UnifiedLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                EditorGutterComponentEx gutter = UnifiedLocalChangeListDiffViewer.this.myEditor.getGutterComponentEx();
                int n = xOffset = DiffUtil.isMirrored((Editor)UnifiedLocalChangeListDiffViewer.this.myEditor) ? gutter.getWidth() - e.getX() : e.getX();
                if (xOffset < gutter.getIconAreaOffset() || xOffset > gutter.getIconAreaOffset() + gutter.getIconsAreaWidth()) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                LogicalPosition position = UnifiedLocalChangeListDiffViewer.this.myEditor.xyToLogicalPosition(e.getPoint());
                GutterCheckboxMouseMotionListener.this.updateHoverHighlighter(position.line);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
            }
        }
    }

    private static final class MyUnifiedDiffChange
    extends UnifiedDiffChange {
        @NotNull
        @NonNls
        private final String myChangelistId;
        private final boolean myIsPartiallyExcluded;
        @NotNull
        private final RangeExclusionState myExclusionState;

        private MyUnifiedDiffChange(int blockStart, int insertedStart, int blockEnd, @NotNull LineFragment lineFragment, boolean isExcluded, boolean isSkipped, @NotNull @NonNls String changelistId, boolean isPartiallyExcluded, @NotNull RangeExclusionState exclusionState) {
            if (lineFragment == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(1);
            }
            if (exclusionState == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(2);
            }
            super(blockStart, insertedStart, blockEnd, lineFragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsPartiallyExcluded = isPartiallyExcluded;
            this.myExclusionState = exclusionState;
        }

        @NotNull
        @NonNls
        public String getChangelistId() {
            String string2 = this.myChangelistId;
            if (string2 == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public boolean isPartiallyExcluded() {
            return this.myIsPartiallyExcluded;
        }

        @NotNull
        public RangeExclusionState getExclusionState() {
            RangeExclusionState rangeExclusionState = this.myExclusionState;
            if (rangeExclusionState == null) {
                MyUnifiedDiffChange.$$$reportNull$$$0(4);
            }
            return rangeExclusionState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineFragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exclusionState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangelistId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExclusionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyUnifiedDiffChangeUi
    extends UnifiedDiffChangeUi {
        private MyUnifiedDiffChangeUi(@NotNull UnifiedLocalChangeListDiffViewer viewer, @NotNull MyUnifiedDiffChange change) {
            if (viewer == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(1);
            }
            super((UnifiedDiffViewer)viewer, (UnifiedDiffChange)change);
        }

        @NotNull
        private UnifiedLocalChangeListDiffViewer getViewer() {
            UnifiedLocalChangeListDiffViewer unifiedLocalChangeListDiffViewer = (UnifiedLocalChangeListDiffViewer)this.myViewer;
            if (unifiedLocalChangeListDiffViewer == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(2);
            }
            return unifiedLocalChangeListDiffViewer;
        }

        @NotNull
        private MyUnifiedDiffChange getChange() {
            MyUnifiedDiffChange myUnifiedDiffChange = (MyUnifiedDiffChange)this.myChange;
            if (myUnifiedDiffChange == null) {
                MyUnifiedDiffChangeUi.$$$reportNull$$$0(3);
            }
            return myUnifiedDiffChange;
        }

        public void installHighlighter() {
            if (this.getChange().isPartiallyExcluded() && this.getViewer().myAllowExcludeChangesFromCommit) {
                assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
                int deletionStart = this.myChange.getDeletedRange().start;
                int additionStart = this.myChange.getInsertedRange().start;
                RangeExclusionState.Partial exclusionState = (RangeExclusionState.Partial)this.getChange().getExclusionState();
                exclusionState.iterateDeletionOffsets((start2, end, isIncluded) -> {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myEditor, start2 + deletionStart, end + deletionStart, TextDiffType.DELETED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(isIncluded == false).done());
                    return null;
                });
                exclusionState.iterateAdditionOffsets((start2, end, isIncluded) -> {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myEditor, start2 + additionStart, end + additionStart, TextDiffType.INSERTED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(isIncluded == false).done());
                    return null;
                });
            } else {
                super.installHighlighter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChangeUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedDiffChangeUi";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private final class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final Document myDocument1;
        @NotNull
        private final Document myDocument2;
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(@NotNull Document document1, @NotNull Document document2, ProgressIndicator indicator) {
            if (document1 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(0);
            }
            if (document2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(2);
            }
            this.myDocument1 = document1;
            this.myDocument2 = document2;
            this.myIndicator = indicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges) {
            if (toggleableLineRanges == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(3);
            }
            if (texts == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(4);
            }
            @NotNull ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
            @NotNull ArrayList<LocalTrackerDiffUtil.LineFragmentData> fragmentsData = new ArrayList<LocalTrackerDiffUtil.LineFragmentData>();
            for (LocalTrackerDiffUtil.ToggleableLineRange range : toggleableLineRanges) {
                List<LineFragment> rangeFragments = range.getFragments();
                fragments.addAll(rangeFragments);
                fragmentsData.addAll(Collections.nCopies(rangeFragments.size(), range.getFragmentData()));
            }
            UnifiedFragmentBuilder builder2 = (UnifiedFragmentBuilder)ReadAction.compute(() -> {
                this.myIndicator.checkCanceled();
                return new MyUnifiedFragmentBuilder(fragments, fragmentsData, this.myDocument1, this.myDocument2).exec();
            });
            Runnable applyChanges2 = UnifiedLocalChangeListDiffViewer.this.apply(builder2, texts, this.myIndicator);
            Runnable applyGutterExcludeOperations = UnifiedLocalChangeListDiffViewer.this.applyGutterOperations(builder2, toggleableLineRanges);
            Runnable runnable = () -> {
                applyChanges2.run();
                applyGutterExcludeOperations.run();
            };
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(5);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            ApplicationManager.getApplication().invokeLater(() -> UnifiedLocalChangeListDiffViewer.this.scheduleRediff());
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            Runnable runnable = UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(6);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = UnifiedLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            Runnable runnable = () -> {
                callback2.run();
                UnifiedLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(7);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable error() {
            Runnable runnable = UnifiedLocalChangeListDiffViewer.this.applyErrorNotification();
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(8);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toggleableLineRanges";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallback";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallbackWithProgress";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 7, 8 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyUnifiedFragmentBuilder
    extends UnifiedFragmentBuilder {
        @NotNull
        private final List<LocalTrackerDiffUtil.LineFragmentData> myFragmentsData;

        MyUnifiedFragmentBuilder(@NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData, @NotNull Document document1, Document document2) {
            if (fragments == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(0);
            }
            if (fragmentsData == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(1);
            }
            if (document1 == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(2);
            }
            if (document2 == null) {
                MyUnifiedFragmentBuilder.$$$reportNull$$$0(3);
            }
            super(fragments, document1, document2, UnifiedLocalChangeListDiffViewer.this.myMasterSide);
            this.myFragmentsData = fragmentsData;
        }

        @NotNull
        protected UnifiedDiffChange createDiffChange(int blockStart, int insertedStart, int blockEnd, int fragmentIndex) {
            LineFragment fragment2 = (LineFragment)this.myFragments.get(fragmentIndex);
            LocalTrackerDiffUtil.LineFragmentData data2 = this.myFragmentsData.get(fragmentIndex);
            boolean isSkipped = data2.isSkipped();
            boolean isExcluded = data2.isExcluded(UnifiedLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
            return new MyUnifiedDiffChange(blockStart, insertedStart, blockEnd, fragment2, isExcluded, isSkipped, data2.getChangelistId(), data2.isPartiallyExcluded(), data2.getExclusionState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragmentsData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/UnifiedLocalChangeListDiffViewer$MyUnifiedFragmentBuilder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

