/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedChangeList
implements JDOMExternalizable,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance(ShelvedChangeList.class);
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ATTRIBUTE_DELETED_CHANGELIST = "deleted";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public Path path;
    @NlsSafe
    public String DESCRIPTION;
    public Date DATE;
    private volatile List<ShelvedChange> myChanges;
    @Nls
    private volatile String myChangesLoadingError;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    private boolean myToDelete;
    private boolean myIsDeleted;
    private String mySchemeName;

    ShelvedChangeList() {
        this.myChangesLoadingError = null;
    }

    public ShelvedChangeList(@NotNull Path path2, @NlsSafe String description2, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges) {
        if (path2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(0);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(1);
        }
        this(path2, description2, binaryFiles, shelvedChanges, System.currentTimeMillis());
    }

    ShelvedChangeList(@NotNull Path path2, @NlsSafe String description2, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges, long time) {
        if (path2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(2);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(3);
        }
        this.myChangesLoadingError = null;
        this.path = path2;
        this.DESCRIPTION = description2;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
        this.mySchemeName = this.DESCRIPTION;
        this.myChanges = shelvedChanges;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(4);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.path = null;
        for (Element child : element.getChildren()) {
            String value2;
            if (!child.getName().equals("option") || !"PATH".equals(child.getAttributeValue(NAME_ATTRIBUTE)) || (value2 = child.getAttributeValue("value", "")).isEmpty()) continue;
            this.path = Paths.get(value2, new String[0]);
        }
        this.mySchemeName = element.getAttributeValue(NAME_ATTRIBUTE);
        this.DATE = new Date(Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE)));
        this.myRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        this.myToDelete = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        this.myIsDeleted = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_DELETED_CHANGELIST));
        List children = element.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children.size());
        for (Element child : children) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(5);
        }
        ShelvedChangeList.writeExternal(element, this);
    }

    private static void writeExternal(@NotNull Element element, @NotNull ShelvedChangeList shelvedChangeList) {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(6);
        }
        if (shelvedChangeList == null) {
            ShelvedChangeList.$$$reportNull$$$0(7);
        }
        if (shelvedChangeList.path != null) {
            element.addContent(new Element("option").setAttribute(NAME_ATTRIBUTE, "PATH").setAttribute("value", shelvedChangeList.path.toString().replace(File.separatorChar, '/')));
        }
        DefaultJDOMExternalizer.writeExternal((Object)shelvedChangeList, (Element)element);
        element.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.DATE.getTime()));
        element.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, "true");
        }
        if (shelvedChangeList.isDeleted()) {
            element.setAttribute(ATTRIBUTE_DELETED_CHANGELIST, "true");
        }
        for (ShelvedBinaryFile file : shelvedChangeList.getBinaryFiles()) {
            Element child = new Element(ELEMENT_BINARY);
            file.writeExternal(child);
            element.addContent(child);
        }
    }

    @Nls
    public String toString() {
        return this.DESCRIPTION;
    }

    public void loadChangesIfNeeded(@NotNull Project project2) {
        if (project2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(8);
        }
        if (this.myChanges != null) {
            return;
        }
        try {
            this.myChangesLoadingError = null;
            List<? extends FilePatch> list2 = ShelveChangesManager.loadPatchesWithoutContent(project2, this.path, null);
            ArrayList<ShelvedChange> changes = new ArrayList<ShelvedChange>();
            for (FilePatch filePatch : list2) {
                ShelvedChange change = ShelvedChangeList.createShelvedChange(project2, this.path, filePatch);
                if (change != null) {
                    changes.add(change);
                    continue;
                }
                if (this.myChangesLoadingError != null) continue;
                String patchName = (String)ObjectUtils.coalesce((Object)filePatch.getBeforeName(), (Object)filePatch.getAfterName(), (Object)this.path.toString());
                this.myChangesLoadingError = VcsBundle.message("shelve.loading.patch.error", patchName);
            }
            this.myChanges = changes;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse the file patch: [" + this.path + "]", (Throwable)e);
            this.myChanges = Collections.emptyList();
            this.myChangesLoadingError = VcsBundle.message("shelve.loading.patch.error", e.getMessage());
        }
    }

    @Nullable
    public List<ShelvedChange> getChanges() {
        return this.myChanges;
    }

    @Deprecated(forRemoval=true)
    public List<ShelvedChange> getChanges(Project project2) {
        this.loadChangesIfNeeded(project2);
        return this.getChanges();
    }

    @Nullable
    @Nls
    public String getChangesLoadingError() {
        return this.myChangesLoadingError;
    }

    void setChanges(List<ShelvedChange> shelvedChanges) {
        this.myChanges = shelvedChanges;
    }

    @NotNull
    static List<ShelvedChange> createShelvedChangesFromFilePatches(@NotNull Project project2, @NotNull Path patchPath, @NotNull Collection<? extends FilePatch> filePatches) {
        if (project2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(9);
        }
        if (patchPath == null) {
            ShelvedChangeList.$$$reportNull$$$0(10);
        }
        if (filePatches == null) {
            ShelvedChangeList.$$$reportNull$$$0(11);
        }
        List list2 = ContainerUtil.mapNotNull(filePatches, patch -> ShelvedChangeList.createShelvedChange(project2, patchPath, patch));
        if (list2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Nullable
    static ShelvedChange createShelvedChange(@NotNull Project project2, @NotNull Path patchPath, @NotNull FilePatch patch) {
        if (project2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(13);
        }
        if (patchPath == null) {
            ShelvedChangeList.$$$reportNull$$$0(14);
        }
        if (patch == null) {
            ShelvedChangeList.$$$reportNull$$$0(15);
        }
        String beforeName = patch.getBeforeName();
        String afterName = patch.getAfterName();
        if (beforeName == null || afterName == null) {
            LOG.warn("Failed to parse the file patch: [" + patchPath + "]:" + patch);
            return null;
        }
        FileStatus status = patch.isNewFile() ? FileStatus.ADDED : (patch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
        return ShelvedChange.create(project2, patchPath, beforeName, afterName, status);
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        String string2 = this.mySchemeName;
        if (string2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(16);
        }
        return string2;
    }

    public void setName(@NotNull String newName) {
        if (newName == null) {
            ShelvedChangeList.$$$reportNull$$$0(17);
        }
        this.mySchemeName = newName;
    }

    public boolean isValid() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void setDeleted(boolean isDeleted) {
        this.myIsDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    public void updateDate() {
        this.DATE = new Date(System.currentTimeMillis());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatches";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesIfNeeded";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createShelvedChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 16 -> new IllegalStateException(string2);
        };
    }
}

