/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.EditedCommitNode;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesListView
extends ChangesTree
implements DataProvider,
DnDAware {
    private static final Logger LOG = Logger.getInstance(ChangesListView.class);
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Iterable<FilePath>> UNVERSIONED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Iterable<VirtualFile>> EXACTLY_SELECTED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.ExactlySelectedFiles");
    @NonNls
    public static final DataKey<Iterable<FilePath>> IGNORED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");
    private boolean myBusy;

    public ChangesListView(@NotNull Project project2, boolean showCheckboxes) {
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        super(project2, showCheckboxes, true);
        this.myBusy = false;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
        }
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    public void setPaintBusy(boolean paintBusy) {
        this.myBusy = paintBusy;
        super.setPaintBusy(paintBusy);
    }

    protected boolean isEmptyTextVisible() {
        return super.isEmptyTextVisible() && !this.myBusy;
    }

    @Override
    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        ChangesBrowserNode<?> subtreeRoot;
        Object subtreeRootObject;
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        Object v0 = subtreeRootObject = (subtreeRoot = ChangesListView.getSubtreeRoot(node)) != null ? subtreeRoot.getUserObject() : null;
        if (subtreeRootObject instanceof LocalChangeList) {
            LocalChangeList localChangeList = subtreeRootObject;
            return !localChangeList.getChanges().isEmpty();
        }
        return subtreeRootObject == ChangesBrowserNode.UNVERSIONED_FILES_TAG && subtreeRoot.getChildCount() > 0;
    }

    @Nullable
    private static ChangesBrowserNode<?> getSubtreeRoot(@NotNull ChangesBrowserNode<?> node) {
        TreeNode[] path2;
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(2);
        }
        if ((path2 = node.getPath()).length < 2) {
            return null;
        }
        return (ChangesBrowserNode)path2[1];
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    @Override
    public void rebuildTree() {
        LOG.warn("rebuildTree() not implemented in " + this, new Throwable());
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateUserObjects(Change.class).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateRawUserObjects(ChangeList.class).toList().toArray(ChangeList[]::new);
        }
        if (VcsDataKeys.FILE_PATHS.is(dataId)) {
            return VcsTreeModelData.mapToFilePath(VcsTreeModelData.selected((JTree)((Object)this)));
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            boolean hasSelection = VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateRawUserObjects().filter(userObject -> !(userObject instanceof ChangeList)).isNotEmpty();
            return hasSelection ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (IGNORED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().toList();
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().toList();
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath).toList();
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            DataProvider superProvider = (DataProvider)super.getData(dataId);
            VcsTreeModelData treeSelection = VcsTreeModelData.selected((JTree)((Object)this));
            VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected((JTree)((Object)this));
            return CompositeDataProvider.compose(slowId -> ChangesListView.getSlowData(this.myProject, treeSelection, exactSelection, slowId), (DataProvider)superProvider);
        }
        return super.getData(dataId);
    }

    @Nullable
    private static Object getSlowData(@NotNull Project project2, @NotNull VcsTreeModelData treeSelection, @NotNull VcsTreeModelData exactSelection, @NotNull String slowId) {
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(4);
        }
        if (treeSelection == null) {
            ChangesListView.$$$reportNull$$$0(5);
        }
        if (exactSelection == null) {
            ChangesListView.$$$reportNull$$$0(6);
        }
        if (slowId == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        if (SelectInContext.DATA_KEY.is(slowId)) {
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapObjectToVirtualFile(exactSelection.iterateRawUserObjects()).first();
            if (file == null) {
                return null;
            }
            return new FileSelectInContext(project2, file, null);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(slowId)) {
            return VcsTreeModelData.mapToVirtualFile(treeSelection).toArray((Object[])VirtualFile.EMPTY_ARRAY);
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(slowId)) {
            return VcsTreeModelData.mapToVirtualFile(treeSelection);
        }
        if (CommonDataKeys.NAVIGATABLE.is(slowId)) {
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapToNavigatableFile(treeSelection).single();
            return file != null && !file.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(project2, file, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(slowId)) {
            return ChangesUtil.getNavigatableArray(project2, VcsTreeModelData.mapToNavigatableFile(treeSelection));
        }
        if (EXACTLY_SELECTED_FILES_DATA_KEY.is(slowId)) {
            return VcsTreeModelData.mapToExactVirtualFile(exactSelection);
        }
        return null;
    }

    @NotNull
    public JBIterable<FilePath> getUnversionedFiles() {
        JBIterable<FilePath> jBIterable = VcsTreeModelData.allUnderTag((JTree)((Object)this), ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<FilePath> getSelectedUnversionedFiles() {
        JBIterable<FilePath> jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<FilePath> getSelectedIgnoredFiles() {
        JBIterable<FilePath> jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), ChangesBrowserNode.IGNORED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<VirtualFile> getSelectedModifiedWithoutEditing() {
        JBIterable jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).iterateUserObjects(VirtualFile.class).filter(VirtualFile::isValid);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Change> getSelectedChanges() {
        JBIterable<Change> changes = VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(Change.class);
        JBIterable hijackedChanges = this.getSelectedModifiedWithoutEditing().map(file -> ChangesListView.toHijackedChange(this.myProject, file)).filterNotNull();
        JBIterable jBIterable = changes.append((Iterable)hijackedChanges);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    public static Change toHijackedChange(@NotNull Project project2, @NotNull VirtualFile file) {
        VcsCurrentRevisionProxy before2;
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        if (file == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        if ((before2 = VcsCurrentRevisionProxy.create(file, project2)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath(file));
            return new Change(before2, afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private JBIterable<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        JBIterable<LocallyDeletedChange> jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).iterateUserObjects(LocallyDeletedChange.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        ChangesBrowserNode<?> node;
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        if ((node = this.findNodeInTree(change)) == null) {
            return null;
        }
        ChangesBrowserNode<?> parent = Registry.is((String)"vcs.skip.single.default.changelist") || !ChangeListManager.getInstance(this.myProject).areChangeListsEnabled() ? this.getRoot() : ChangesListView.findParentOfType(node, ChangesBrowserChangeListNode.class);
        if (parent == null) {
            return null;
        }
        return parent.traverseObjectsUnder().filter(Change.class).toList();
    }

    @Nullable
    public List<Change> getAllChangesFromSameAmendNode(@NotNull Change change) {
        ChangesBrowserNode<?> node;
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        if ((node = this.findNodeInTree(change)) == null) {
            return null;
        }
        ChangesBrowserNode<?> parent = ChangesListView.findParentOfType(node, EditedCommitNode.class);
        if (parent == null) {
            return null;
        }
        return parent.traverseObjectsUnder().filter(Change.class).toList();
    }

    @Nullable
    private static ChangesBrowserNode<?> findParentOfType(@NotNull ChangesBrowserNode<?> node, @NotNull Class<? extends ChangesBrowserNode<?>> clazz) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        if (clazz == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        for (TreeNode parent = node.getParent(); parent != null; parent = ((ChangesBrowserNode)parent).getParent()) {
            if (!clazz.isInstance(parent)) continue;
            return parent;
        }
        return null;
    }

    @NotNull
    public JBIterable<ChangesBrowserChangeNode> getChangesNodes() {
        JBIterable jBIterable = VcsTreeModelData.all((JTree)((Object)this)).iterateNodes().filter(ChangesBrowserChangeNode.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> getSelectedChangesNodes() {
        JBIterable<ChangesBrowserNode<?>> jBIterable = VcsTreeModelData.selected((JTree)((Object)this)).iterateNodes();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group2) {
        if (group2 == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group2, (String)"ChangesViewPopup");
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public ChangesBrowserNode<?> findNodeInTree(@Nullable Object userObject) {
        return this.findNodeInTree(userObject, null);
    }

    @Nullable
    public ChangesBrowserNode<?> findNodeInTree(@Nullable Object userObject, @Nullable Object tag) {
        ChangesBrowserNode<?> fromNode;
        if (userObject instanceof LocalChangeList) {
            return (ChangesBrowserNode)this.getRoot().iterateNodeChildren().find(node -> userObject.equals(node.getUserObject()));
        }
        ChangesBrowserNode<?> changesBrowserNode = fromNode = tag != null ? VcsTreeModelData.findTagNode((JTree)((Object)this), tag) : this.getRoot();
        if (fromNode == null) {
            return null;
        }
        if (userObject instanceof ChangeListChange) {
            return (ChangesBrowserNode)VcsTreeModelData.allUnder(fromNode).iterateNodes().find(node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return (ChangesBrowserNode)VcsTreeModelData.allUnder(fromNode).iterateNodes().find(node -> Objects.equals(node.getUserObject(), userObject));
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject) {
        return this.findNodePathInTree(userObject, null);
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject, @Nullable Object tag) {
        ChangesBrowserNode<?> node = this.findNodeInTree(userObject, tag);
        return node != null ? TreeUtil.getPathFromRoot(node) : null;
    }

    public void expandSafe(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        if (node.getChildCount() <= 10000) {
            this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 15, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeSelection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactSelection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slowId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNodes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesNodes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubtreeRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameChangelist";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameAmendNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findParentOfType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "expandSafe";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 10, 11, 12, 15, 20, 21, 23 -> new IllegalStateException(string2);
        };
    }
}

