/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.HistoryCacheBaseKey;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsHistoryCache {
    private final Cache<HistoryCacheBaseKey, CachedHistory> historyCache;
    private final Cache<HistoryCacheWithRevisionKey, Object> annotationCache;
    private final Cache<HistoryCacheWithRevisionKey, VcsRevisionNumber> lastRevisionCache;

    public VcsHistoryCache() {
        boolean preloadEnabled = AdvancedSettings.getBoolean((String)"vcs.annotations.preload") || Registry.is((String)"vcs.code.author.inlay.hints");
        this.historyCache = Caffeine.newBuilder().maximumSize(preloadEnabled ? 50L : 10L).build();
        this.annotationCache = Caffeine.newBuilder().maximumSize(preloadEnabled ? 50L : 10L).build();
        this.lastRevisionCache = Caffeine.newBuilder().maximumSize(50L).build();
    }

    public <C extends Serializable, T extends VcsAbstractHistorySession> void put(@NotNull FilePath filePath, @Nullable FilePath correctedPath, @NotNull VcsKey vcsKey, @NotNull T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(0);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(1);
        }
        if (session == null) {
            VcsHistoryCache.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(3);
        }
        this.historyCache.put((Object)new HistoryCacheBaseKey(filePath, vcsKey), (Object)new CachedHistory(correctedPath == null ? filePath : correctedPath, session.getRevisionList(), session.getCurrentRevisionNumber(), factory.getAdditionallyCachedData(session), isFull));
    }

    public void editCached(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull Consumer<? super List<VcsFileRevision>> consumer2) {
        CachedHistory cachedHistory;
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(4);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            VcsHistoryCache.$$$reportNull$$$0(6);
        }
        if ((cachedHistory = (CachedHistory)this.historyCache.getIfPresent((Object)new HistoryCacheBaseKey(filePath, vcsKey))) != null) {
            consumer2.accept(cachedHistory.getRevisions());
        }
    }

    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getFull(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        CachedHistory cachedHistory;
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(7);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(9);
        }
        if ((cachedHistory = (CachedHistory)this.historyCache.getIfPresent((Object)new HistoryCacheBaseKey(filePath, vcsKey))) == null || !cachedHistory.isIsFull()) {
            return null;
        }
        Serializable customData = (Serializable)cachedHistory.getCustomData();
        return factory.createFromCachedData(customData, cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
    }

    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getMaybePartial(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        CachedHistory cachedHistory;
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(10);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(11);
        }
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(12);
        }
        if ((cachedHistory = (CachedHistory)this.historyCache.getIfPresent((Object)new HistoryCacheBaseKey(filePath, vcsKey))) == null) {
            return null;
        }
        Serializable customData = (Serializable)cachedHistory.getCustomData();
        return factory.createFromCachedData(customData, cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
    }

    public void clearAll() {
        this.clearHistory();
        this.clearAnnotations();
        this.clearLastRevisions();
    }

    public void clearHistory() {
        this.historyCache.asMap().keySet().removeIf(it -> !it.getFilePath().isNonLocal());
    }

    public void putAnnotation(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number, @NotNull Object vcsAnnotation) {
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(13);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(14);
        }
        if (number == null) {
            VcsHistoryCache.$$$reportNull$$$0(15);
        }
        if (vcsAnnotation == null) {
            VcsHistoryCache.$$$reportNull$$$0(16);
        }
        this.annotationCache.put((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, number), vcsAnnotation);
    }

    @Nullable
    public Object getAnnotation(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number) {
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(17);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(18);
        }
        if (number == null) {
            VcsHistoryCache.$$$reportNull$$$0(19);
        }
        return this.annotationCache.getIfPresent((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, number));
    }

    public void clearAnnotations() {
        this.annotationCache.invalidateAll();
    }

    public void putLastRevision(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber currentRevision, @NotNull VcsRevisionNumber lastRevision) {
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(20);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(21);
        }
        if (currentRevision == null) {
            VcsHistoryCache.$$$reportNull$$$0(22);
        }
        if (lastRevision == null) {
            VcsHistoryCache.$$$reportNull$$$0(23);
        }
        this.lastRevisionCache.put((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, currentRevision), (Object)lastRevision);
    }

    @Nullable
    public VcsRevisionNumber getLastRevision(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber currentRevision) {
        if (filePath == null) {
            VcsHistoryCache.$$$reportNull$$$0(24);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(25);
        }
        if (currentRevision == null) {
            VcsHistoryCache.$$$reportNull$$$0(26);
        }
        return (VcsRevisionNumber)this.lastRevisionCache.getIfPresent((Object)new HistoryCacheWithRevisionKey(filePath, vcsKey, currentRevision));
    }

    public void clearLastRevisions() {
        this.lastRevisionCache.invalidateAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsAnnotation";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevision";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastRevision";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "editCached";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFull";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getMaybePartial";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "putAnnotation";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotation";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "putLastRevision";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CachedHistory {
        private final FilePath myPath;
        private final List<VcsFileRevision> myRevisions;
        private final VcsRevisionNumber myCurrentRevision;
        private final Object myCustomData;
        private final boolean myIsFull;

        CachedHistory(FilePath path2, List<VcsFileRevision> revisions, VcsRevisionNumber currentRevision, Object customData, boolean isFull) {
            this.myPath = path2;
            this.myRevisions = revisions;
            this.myCurrentRevision = currentRevision;
            this.myCustomData = customData;
            this.myIsFull = isFull;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public List<VcsFileRevision> getRevisions() {
            return this.myRevisions;
        }

        public VcsRevisionNumber getCurrentRevision() {
            return this.myCurrentRevision;
        }

        public Object getCustomData() {
            return this.myCustomData;
        }

        public boolean isIsFull() {
            return this.myIsFull;
        }
    }
}

