/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.filename.UniqueNameBuilder;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ex.VcsActivationListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.impl.projectlevelman.VcsDefaultMappingUtils;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.util.paths.FilePathMapping;
import com.intellij.openapi.vcs.util.paths.VirtualFileMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NewMappings
implements Disposable {
    private static final Comparator<MappedRoot> ROOT_COMPARATOR = Comparator.comparing(it -> it.root.getPath());
    private static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance(NewMappings.class);
    private final Object myUpdateLock;
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;
    private volatile List<VcsDirectoryMapping> myMappings;
    @NotNull
    private Disposable myFilePointerDisposable;
    private volatile List<MappedRoot> myMappedRoots;
    private volatile RootMapping myMappedRootsMapping;
    private volatile Map<VirtualFile, @NlsSafe String> myMappedRootShortNames;
    private volatile List<AbstractVcs> myActiveVcses;
    private volatile boolean myActivated;
    @NotNull
    private final MergingUpdateQueue myRootUpdateQueue;
    private final VirtualFilePointerListener myFilePointerListener;

    public NewMappings(@NotNull Project project2, @NotNull ProjectLevelVcsManagerImpl vcsManager2) {
        if (project2 == null) {
            NewMappings.$$$reportNull$$$0(0);
        }
        if (vcsManager2 == null) {
            NewMappings.$$$reportNull$$$0(1);
        }
        this.myUpdateLock = new Object();
        this.myMappings = Collections.emptyList();
        this.myFilePointerDisposable = Disposer.newDisposable();
        this.myMappedRoots = Collections.emptyList();
        this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
        this.myMappedRootShortNames = Collections.emptyMap();
        this.myActiveVcses = Collections.emptyList();
        this.myActivated = false;
        this.myProject = project2;
        this.myVcsManager = vcsManager2;
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this);
        this.myRootUpdateQueue = new MergingUpdateQueue("NewMappings", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).usePassThroughInUnitTestMode();
        this.myFilePointerListener = new VirtualFilePointerListener(){

            public void validityChanged(VirtualFilePointer @NotNull [] pointers) {
                if (pointers == null) {
                    1.$$$reportNull$$$0(0);
                }
                NewMappings.this.scheduleMappedRootsUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "validityChanged"));
            }
        };
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleMappedRootsUpdate(), (Disposable)project2);
    }

    @TestOnly
    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    public AbstractVcs @NotNull [] getActiveVcses() {
        AbstractVcs[] abstractVcsArray = this.myActiveVcses.toArray(new AbstractVcs[0]);
        if (abstractVcsArray == null) {
            NewMappings.$$$reportNull$$$0(2);
        }
        return abstractVcsArray;
    }

    public boolean hasActiveVcss() {
        return !this.myActiveVcses.isEmpty();
    }

    public boolean isActivated() {
        return this.myActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
            LOG.debug("activated");
        }
        this.updateActiveVcses(true);
        this.updateMappedRoots(true);
    }

    private boolean updateActiveVcses(boolean forceFireEvent) {
        MyVcsActivator activator = (MyVcsActivator)ReadAction.compute(() -> {
            Object object = this.myUpdateLock;
            synchronized (object) {
                return this.myActivated ? this.createVcsActivator() : null;
            }
        });
        if (activator != null) {
            boolean wasChanged = activator.activate();
            if (forceFireEvent || wasChanged) {
                ((VcsActivationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ProjectLevelVcsManagerEx.VCS_ACTIVATED)).vcsesActivated(this.myActiveVcses);
            }
        }
        return activator != null;
    }

    public void setMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (path2 == null) {
            NewMappings.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setMapping path = '" + path2 + "' vcs = " + activeVcsName, new Throwable());
        }
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path2, activeVcsName);
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getDirectory(), newMapping.getDirectory()));
        newMappings.add(newMapping);
        this.updateVcsMappings(newMappings);
    }

    @TestOnly
    public void waitMappedRootsUpdate() {
        this.myRootUpdateQueue.flush();
    }

    @TestOnly
    public void freezeMappedRootsUpdate(@NotNull Disposable disposable) {
        if (disposable == null) {
            NewMappings.$$$reportNull$$$0(4);
        }
        this.myRootUpdateQueue.setPassThrough(false);
        this.myRootUpdateQueue.suspend();
        Disposer.register((Disposable)disposable, () -> {
            this.myRootUpdateQueue.setPassThrough(false);
            this.myRootUpdateQueue.resume();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedVcsesImmediately() {
        LOG.debug("updateMappingsImmediately");
        if (!this.updateActiveVcses(false)) {
            return;
        }
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = Disposer.newDisposable();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.myMappedRootShortNames = Collections.emptyMap();
            this.dumpMappedRootsToLog();
        }
        this.notifyMappingsChanged();
        this.scheduleMappedRootsUpdate();
    }

    public void scheduleMappedRootsUpdate() {
        this.myRootUpdateQueue.queue((Update)new DisposableUpdate(this, "update"){

            public void doRun() {
                NewMappings.this.updateMappedRoots(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVcsMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(5);
        }
        this.myRootUpdateQueue.cancelAllUpdates();
        List newMappings = List.copyOf(ContainerUtil.sorted(NewMappings.removeDuplicates(mappings), MAPPINGS_COMPARATOR));
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappingsChanged;
            boolean bl = mappingsChanged = !this.myMappings.equals(newMappings);
            if (!mappingsChanged) {
                return;
            }
            this.myMappings = newMappings;
            this.dumpMappingsToLog();
        }
        this.updateActiveVcses(false);
        if (ApplicationManager.getApplication().isDispatchThread() && ContainerUtil.exists(newMappings, it -> it.isDefaultMapping())) {
            this.updateMappedRootsFast();
            this.scheduleMappedRootsUpdate();
        } else {
            this.updateMappedRoots(false);
        }
        this.notifyMappingsChanged();
    }

    private void updateMappedRoots(boolean fireMappingsChangedEvent) {
        this.myRootUpdateQueue.cancelAllUpdates();
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRoots");
        List<VcsDirectoryMapping> mappings = this.myMappings;
        Mappings newMappedRoots = this.collectMappedRoots(mappings, null);
        this.setNewMappedRoots(mappings, newMappedRoots, fireMappingsChangedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappedRootsFast() {
        List<MappedRoot> mappedRoots;
        List<VcsDirectoryMapping> mappings;
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRootsFast");
        Object object = this.myUpdateLock;
        synchronized (object) {
            mappings = this.myMappings;
            mappedRoots = this.myMappedRoots;
        }
        Mappings newMappedRoots = this.collectMappedRoots(mappings, mappedRoots);
        this.setNewMappedRoots(mappings, newMappedRoots, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewMappedRoots(@NotNull List<VcsDirectoryMapping> mappings, @NotNull Mappings newMappedRoots, boolean fireMappingsChangedEvent) {
        boolean mappedRootsChanged;
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(6);
        }
        if (newMappedRoots == null) {
            NewMappings.$$$reportNull$$$0(7);
        }
        Map<VirtualFile, @NlsSafe String> newMappedRootNames = NewMappings.buildMappingShortNameMap(this.myProject, newMappedRoots.mappedRoots);
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myMappings != mappings) {
                Disposer.dispose((Disposable)newMappedRoots.filePointerDisposable);
                return;
            }
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = newMappedRoots.filePointerDisposable;
            boolean bl = mappedRootsChanged = !this.myMappedRoots.equals(newMappedRoots.mappedRoots);
            if (mappedRootsChanged) {
                this.myMappedRoots = newMappedRoots.mappedRoots;
                this.myMappedRootsMapping = new RootMapping(newMappedRoots.mappedRoots);
                this.myMappedRootShortNames = newMappedRootNames;
                this.dumpMappedRootsToLog();
            }
        }
        if (fireMappingsChangedEvent && mappedRootsChanged) {
            this.notifyMappingsChanged();
        }
    }

    private static @NotNull Map<VirtualFile, @NlsSafe String> buildMappingShortNameMap(@NotNull Project project2, @NotNull List<MappedRoot> roots) {
        String basePath;
        if (project2 == null) {
            NewMappings.$$$reportNull$$$0(8);
        }
        if (roots == null) {
            NewMappings.$$$reportNull$$$0(9);
        }
        String builderRoot = (basePath = project2.getBasePath()) != null ? FileUtil.toSystemIndependentName((String)basePath) : "";
        MultiMap nameCollisionMap = new MultiMap();
        for (MappedRoot mappedRoot : roots) {
            VirtualFile root = mappedRoot.root;
            nameCollisionMap.putValue((Object)root.getName(), (Object)root);
        }
        HashMap<VirtualFile, @NlsSafe String> result2 = new HashMap<VirtualFile, String>();
        for (Map.Entry entry2 : nameCollisionMap.entrySet()) {
            Collection collisionRoots = (Collection)entry2.getValue();
            if (collisionRoots.size() == 1) {
                for (VirtualFile root : collisionRoots) {
                    result2.put(root, root.getName());
                }
                continue;
            }
            UniqueNameBuilder builder2 = new UniqueNameBuilder(builderRoot, File.separator);
            for (VirtualFile root : collisionRoots) {
                builder2.addPath((Object)root, root.getPath());
            }
            for (VirtualFile root : collisionRoots) {
                result2.put(root, StringUtil.nullize((String)builder2.getShortPath((Object)root)));
            }
        }
        HashMap<VirtualFile, String> hashMap = result2;
        if (hashMap == null) {
            NewMappings.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private void refreshMainMenu() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ProjectFrameHelper frame = WindowManagerEx.getInstanceEx().getFrameHelper(this.myProject);
            if (frame != null) {
                if (ExperimentalUI.isNewUI()) {
                    frame.rootPane.updateMainMenuActions();
                } else {
                    frame.updateView();
                }
            }
        }, this.myProject.getDisposed());
    }

    @NotNull
    private static List<VcsDirectoryMapping> removeDuplicates(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(11);
        }
        ArrayList<VcsDirectoryMapping> newMapping = new ArrayList<VcsDirectoryMapping>();
        HashSet<String> paths = new HashSet<String>();
        for (VcsDirectoryMapping mapping : ContainerUtil.reverse(mappings)) {
            if (!paths.add(mapping.getDirectory())) continue;
            newMapping.add(mapping);
        }
        ArrayList<VcsDirectoryMapping> arrayList = newMapping;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private Mappings collectMappedRoots(@NotNull List<VcsDirectoryMapping> mappings, @Nullable List<MappedRoot> reuseMappedRoots) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(13);
        }
        HashMap<VirtualFile, MappedRoot> mappedRoots = new HashMap<VirtualFile, MappedRoot>();
        Disposable pointerDisposable = Disposer.newDisposable();
        if (!TrustedProjects.isTrusted((Project)this.myProject)) {
            return new Mappings(Collections.emptyList(), pointerDisposable);
        }
        try {
            for (VcsDirectoryMapping mapping : mappings) {
                MappedRoot mappedRoot;
                if (mapping.isDefaultMapping() || (mappedRoot = this.findDirectMappingFor(mapping, pointerDisposable)) == null) continue;
                mappedRoots.putIfAbsent(mappedRoot.root, mappedRoot);
            }
            for (VcsDirectoryMapping mapping : mappings) {
                List<MappedRoot> defaultMappings;
                if (!mapping.isDefaultMapping()) continue;
                if (reuseMappedRoots != null) {
                    defaultMappings = this.reuseDefaultMappingsFrom(mapping, reuseMappedRoots, pointerDisposable);
                } else {
                    Set directMappingDirs = ContainerUtil.map2Set(mappedRoots.values(), it -> it.root);
                    defaultMappings = this.findDefaultMappingsFor(mapping, directMappingDirs, pointerDisposable);
                }
                for (MappedRoot mappedRoot : defaultMappings) {
                    mappedRoots.putIfAbsent(mappedRoot.root, mappedRoot);
                }
            }
            List result2 = ContainerUtil.sorted(mappedRoots.values(), ROOT_COMPARATOR);
            for (MappedRoot root : result2) {
                if (!this.myVcsManager.isIgnored(VcsUtil.getFilePath(root.root))) continue;
                LOG.warn("Root mapping is under ignored root: " + root.root);
            }
            return new Mappings(result2, pointerDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)pointerDisposable);
            ExceptionUtil.rethrow((Throwable)e);
            if (null == null) {
                NewMappings.$$$reportNull$$$0(14);
            }
            return null;
        }
    }

    @Nullable
    private MappedRoot findDirectMappingFor(@NotNull VcsDirectoryMapping mapping, @NotNull Disposable pointerDisposable) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(15);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(16);
        }
        AbstractVcs vcs = this.getMappingsVcs(mapping);
        String rootPath = mapping.getDirectory();
        return (MappedRoot)ReadAction.compute(() -> {
            VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)rootPath), pointerDisposable, this.myFilePointerListener);
            VirtualFile vcsRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
            if (vcsRoot == null || !vcsRoot.isDirectory()) {
                return null;
            }
            if (this.checkMappedRoot(vcs, vcsRoot)) {
                return new MappedRoot(vcs, mapping, vcsRoot);
            }
            return new MappedRoot(null, mapping, vcsRoot);
        });
    }

    @NotNull
    private List<MappedRoot> findDefaultMappingsFor(@NotNull VcsDirectoryMapping mapping, @NotNull Set<VirtualFile> directMappingDirs, @NotNull Disposable pointerDisposable) {
        AbstractVcs vcs;
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(17);
        }
        if (directMappingDirs == null) {
            NewMappings.$$$reportNull$$$0(18);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(19);
        }
        if ((vcs = this.getMappingsVcs(mapping)) == null) {
            List<MappedRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                NewMappings.$$$reportNull$$$0(20);
            }
            return list2;
        }
        Collection<VirtualFile> defaultRoots = this.detectDefaultRootsFor(vcs, DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(), directMappingDirs);
        ArrayList<MappedRoot> result2 = new ArrayList<MappedRoot>();
        ReadAction.run(() -> {
            for (VirtualFile vcsRoot : defaultRoots) {
                if (vcsRoot == null || !vcsRoot.isDirectory()) continue;
                VirtualFilePointerManager.getInstance().create(vcsRoot, pointerDisposable, this.myFilePointerListener);
                result2.add(new MappedRoot(vcs, mapping, vcsRoot));
            }
        });
        ArrayList<MappedRoot> arrayList = result2;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    private List<MappedRoot> reuseDefaultMappingsFrom(@NotNull VcsDirectoryMapping mapping, @NotNull List<MappedRoot> oldMappedRoots, @NotNull Disposable pointerDisposable) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(22);
        }
        if (oldMappedRoots == null) {
            NewMappings.$$$reportNull$$$0(23);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(24);
        }
        ArrayList<MappedRoot> result2 = new ArrayList<MappedRoot>();
        ReadAction.run(() -> {
            List oldMappings = ContainerUtil.filter((Collection)oldMappedRoots, root -> root.mapping.getVcs().equals(mapping.getVcs()));
            for (MappedRoot root2 : oldMappings) {
                VirtualFilePointerManager.getInstance().create(root2.root, pointerDisposable, this.myFilePointerListener);
                result2.add(new MappedRoot(root2.vcs, mapping, root2.root));
            }
        });
        ArrayList<MappedRoot> arrayList = result2;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    private AbstractVcs getMappingsVcs(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(26);
        }
        return AllVcses.getInstance(this.myProject).getByName(mapping.getVcs());
    }

    private boolean checkMappedRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            NewMappings.$$$reportNull$$$0(27);
        }
        try {
            if (vcs == null) {
                return false;
            }
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            return rootChecker.validateRoot(vcsRoot);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    @NotNull
    private Collection<VirtualFile> detectDefaultRootsFor(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) {
        Set<VirtualFile> set;
        VcsRootChecker rootChecker;
        block13: {
            block12: {
                if (vcs == null) {
                    NewMappings.$$$reportNull$$$0(28);
                }
                if (projectRoots == null) {
                    NewMappings.$$$reportNull$$$0(29);
                }
                if (mappedDirs == null) {
                    NewMappings.$$$reportNull$$$0(30);
                }
                if (!vcs.needsLegacyDefaultMappings()) break block12;
                Collection<VirtualFile> collection = projectRoots;
                if (collection == null) {
                    NewMappings.$$$reportNull$$$0(31);
                }
                return collection;
            }
            rootChecker = this.myVcsManager.getRootChecker(vcs);
            Collection<VirtualFile> checkerFiles = rootChecker.detectProjectMappings(this.myProject, projectRoots, mappedDirs);
            if (checkerFiles == null) break block13;
            Collection<VirtualFile> collection = checkerFiles;
            if (collection == null) {
                NewMappings.$$$reportNull$$$0(32);
            }
            return collection;
        }
        try {
            set = VcsDefaultMappingUtils.detectProjectMappings(this.myProject, rootChecker, projectRoots, mappedDirs);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NewMappings.$$$reportNull$$$0(34);
            }
            return list2;
        }
        if (set == null) {
            NewMappings.$$$reportNull$$$0(33);
        }
        return set;
    }

    public void notifyMappingsChanged() {
        ((VcsMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileWatchRequestsManager.ping();
    }

    private void dumpMappingsToLog() {
        for (VcsDirectoryMapping mapping : this.myMappings) {
            String path2 = mapping.isDefaultMapping() ? "<Project>" : mapping.getDirectory();
            String vcs = mapping.getVcs();
            LOG.info(String.format("VCS Root: [%s] - [%s]", vcs, path2));
        }
    }

    private void dumpMappedRootsToLog() {
        if (LOG.isDebugEnabled()) {
            for (MappedRoot root : this.myMappedRoots) {
                LOG.debug(String.format("Mapped Root: [%s] - [%s]", root.vcs, root.root.getPath()));
            }
        } else if (this.haveDefaultMapping() != null) {
            LOG.info("Mapped Roots: " + this.myMappedRoots.size());
        }
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items2) {
        if (items2 == null) {
            NewMappings.$$$reportNull$$$0(35);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setDirectoryMappings, size: " + items2.size(), new Throwable());
        }
        this.updateVcsMappings(items2);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable FilePath file) {
        if (file == null || file.isNonLocal()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @Nullable
    @NlsSafe
    public String getShortNameFor(@Nullable VirtualFile file) {
        return this.myMappedRootShortNames.get(file);
    }

    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            NewMappings.$$$reportNull$$$0(36);
        }
        List list2 = ContainerUtil.mapNotNull(this.myMappedRoots, root -> vcs.equals(root.vcs) ? root.root : null);
        if (list2 == null) {
            NewMappings.$$$reportNull$$$0(37);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MyVcsActivator activator;
        LOG.debug("disposed");
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappings = Collections.emptyList();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.myMappedRootShortNames = Collections.emptyMap();
            this.myFilePointerDisposable = Disposer.newDisposable();
            activator = this.createVcsActivator();
        }
        activator.activate();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        return ContainerUtil.filter(this.myMappings, mapping -> Objects.equals(mapping.getVcs(), vcsName));
    }

    @Nullable
    public String haveDefaultMapping() {
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(this.myMappings, mapping -> mapping.isDefaultMapping());
        return defaultMapping != null ? defaultMapping.getVcs() : null;
    }

    public boolean isEmpty() {
        return ContainerUtil.all(this.myMappings, mapping -> mapping.isNoneMapping());
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(38);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove mapping: " + mapping.getDirectory(), new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.remove(mapping);
        this.updateVcsMappings(newMappings);
    }

    public void cleanupMappings() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VcsDirectoryMapping> oldMappings = new ArrayList<VcsDirectoryMapping>(this.getDirectoryMappings());
        ArrayList<VcsDirectoryMapping> filteredMappings = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(oldMappings, it -> it.isDefaultMapping());
        if (defaultMapping != null) {
            oldMappings.remove(defaultMapping);
            filteredMappings.add(defaultMapping);
        }
        MultiMap groupedMappings = new MultiMap();
        for (VcsDirectoryMapping mapping : oldMappings) {
            groupedMappings.putValue((Object)mapping.getVcs(), (Object)mapping);
        }
        for (Map.Entry entry2 : groupedMappings.entrySet()) {
            String vcsName = (String)entry2.getKey();
            Collection mappings = (Collection)entry2.getValue();
            List objects = ContainerUtil.mapNotNull((Collection)mappings, dm -> {
                VirtualFile vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                return vf == null ? null : Pair.create((Object)vf, (Object)dm);
            });
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredMappings.addAll(ContainerUtil.map((Collection)objects, (Function)Functions.pairSecond()));
                continue;
            }
            AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
            if (vcs == null) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsBundle.message("impl.notification.content.vcs.plugin.not.found.for.mapping.to", vcsName), MessageType.ERROR, new NamedRunnable[0]);
                filteredMappings.addAll(mappings);
                continue;
            }
            filteredMappings.addAll(ContainerUtil.map(vcs.filterUniqueRoots(objects, pair -> (VirtualFile)pair.getFirst()), (Function)Functions.pairSecond()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("NewMappings.cleanupMappings", new Object[]{this.getDirectoryMappings(), filteredMappings});
        }
        this.updateVcsMappings(filteredMappings);
    }

    @NotNull
    private MyVcsActivator createVcsActivator() {
        Set newVcses = !this.myProject.isDisposed() && TrustedProjects.isTrusted((Project)this.myProject) ? ContainerUtil.map2SetNotNull(this.myMappings, this::getMappingsVcs) : Collections.emptySet();
        List<AbstractVcs> oldVcses = this.myActiveVcses;
        this.myActiveVcses = List.copyOf(newVcses);
        this.refreshMainMenu();
        Collection toAdd = ContainerUtil.subtract(this.myActiveVcses, oldVcses);
        Collection toRemove = ContainerUtil.subtract(oldVcses, this.myActiveVcses);
        return new MyVcsActivator(toAdd, toRemove);
    }

    public boolean haveActiveVcs(String name) {
        return ContainerUtil.exists(this.myActiveVcses, vcs -> Objects.equals(vcs.getName(), name));
    }

    public void beingUnregistered(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beingUnregistered " + name, new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getVcs(), name));
        this.updateVcsMappings(newMappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 12, 14, 20, 21, 25, 31, 32, 33, 34, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMappedRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 26: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerDisposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directMappingDirs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMappedRoots";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoots";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedDirs";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveVcses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMappingShortNameMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMappedRoots";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefaultMappingsFor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseDefaultMappingsFrom";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "detectDefaultRootsFor";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsAsFilesUnderVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "freezeMappedRootsUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateVcsMappings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setNewMappedRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildMappingShortNameMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectMappedRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findDirectMappingFor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultMappingsFor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reuseDefaultMappingsFrom";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsVcs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkMappedRoot";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "detectDefaultRootsFor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsAsFilesUnderVcs";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 10, 12, 14, 20, 21, 25, 31, 32, 33, 34, 37 -> new IllegalStateException(string2);
        };
    }

    private static final class RootMapping {
        private final VirtualFileMapping<MappedRoot> myVFMap;
        private final FilePathMapping<MappedRoot> myPathMapping;

        private RootMapping(@NotNull List<MappedRoot> mappedRoots) {
            if (mappedRoots == null) {
                RootMapping.$$$reportNull$$$0(0);
            }
            this.myVFMap = new VirtualFileMapping();
            this.myPathMapping = new FilePathMapping(SystemInfo.isFileSystemCaseSensitive);
            for (MappedRoot root : mappedRoots) {
                this.myVFMap.add(root.root, root);
                this.myPathMapping.add(root.root.getPath(), root);
            }
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull VirtualFile file) {
            if (file == null) {
                RootMapping.$$$reportNull$$$0(1);
            }
            return this.myVFMap.getMappingFor(file);
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull FilePath filePath) {
            if (filePath == null) {
                RootMapping.$$$reportNull$$$0(2);
            }
            return this.myPathMapping.getMappingFor(filePath.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$RootMapping";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRootFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyVcsActivator {
        @NotNull
        private final Collection<? extends AbstractVcs> myAddVcses;
        @NotNull
        private final Collection<? extends AbstractVcs> myRemoveVcses;

        private MyVcsActivator(@NotNull Collection<? extends AbstractVcs> addVcses, @NotNull Collection<? extends AbstractVcs> removeVcses) {
            if (addVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(0);
            }
            if (removeVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(1);
            }
            this.myAddVcses = addVcses;
            this.myRemoveVcses = removeVcses;
        }

        public boolean activate() {
            for (AbstractVcs abstractVcs : this.myAddVcses) {
                try {
                    abstractVcs.doActivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
            for (AbstractVcs abstractVcs : this.myRemoveVcses) {
                try {
                    abstractVcs.doDeactivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
            return !this.myAddVcses.isEmpty() || !this.myRemoveVcses.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addVcses";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removeVcses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MyVcsActivator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Mappings {
        @NotNull
        public final List<MappedRoot> mappedRoots;
        @NotNull
        public final Disposable filePointerDisposable;

        private Mappings(@NotNull List<MappedRoot> mappedRoots, @NotNull Disposable filePointerDisposable) {
            if (mappedRoots == null) {
                Mappings.$$$reportNull$$$0(0);
            }
            if (filePointerDisposable == null) {
                Mappings.$$$reportNull$$$0(1);
            }
            this.mappedRoots = mappedRoots;
            this.filePointerDisposable = filePointerDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointerDisposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$Mappings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MappedRoot {
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsDirectoryMapping mapping;
        @NotNull
        public final VirtualFile root;

        private MappedRoot(@Nullable AbstractVcs vcs, @NotNull VcsDirectoryMapping mapping, @NotNull VirtualFile root) {
            if (mapping == null) {
                MappedRoot.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MappedRoot.$$$reportNull$$$0(1);
            }
            this.vcs = vcs;
            this.mapping = mapping;
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRoot other = (MappedRoot)o;
            return Objects.equals(this.vcs, other.vcs) && this.mapping.equals(other.mapping) && this.root.equals(other.root);
        }

        public int hashCode() {
            return Objects.hash(this.vcs, this.mapping, this.root);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MappedRoot";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

