/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.VcsDirectoryRenamesProvider;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorageBackend myIndexStorageBackend;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    @NotNull
    private final VcsDirectoryRenamesProvider myDirectoryRenamesProvider;
    private final boolean myIsProjectLog;

    public IndexDataGetter(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorageBackend indexStorageBackend, @NotNull VcsLogStorage logStorage, @NotNull VcsLogErrorHandler errorHandler2) {
        if (project2 == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (providers == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorageBackend == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (errorHandler2 == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myProviders = providers;
        this.myIndexStorageBackend = indexStorageBackend;
        this.myLogStorage = logStorage;
        this.myErrorHandler = errorHandler2;
        this.myDirectoryRenamesProvider = VcsDirectoryRenamesProvider.getInstance(this.myProject);
        this.myIsProjectLog = Arrays.stream(ProjectLevelVcsManager.getInstance(project2).getAllVcsRoots()).map(VcsRoot::getPath).collect(Collectors.toSet()).containsAll(this.myProviders.keySet());
    }

    void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor2) {
        if (processor2 == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        this.executeAndCatch(() -> this.myIndexStorageBackend.iterateIndexedCommits(limit, processor2));
    }

    @Nullable
    public VcsUser getAuthor(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorForCommit(commit2));
    }

    @Nullable
    public Map<Integer, VcsUser> getAuthor(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(6);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorForCommits(commitIds));
    }

    @Nullable
    public VcsUser getCommitter(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitterForCommit(commit2));
    }

    @NotNull
    public Map<Integer, VcsUser> getCommitter(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        Map<Integer, VcsUser> map2 = this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitterForCommits(commitIds), Collections.emptyMap());
        if (map2 == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @Nullable
    public Long getAuthorTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            long[] time = this.myIndexStorageBackend.getTimestamp(commit2);
            return time == null ? null : Long.valueOf(time[0]);
        });
    }

    @Nullable
    public Map<Integer, Long> getAuthorTime(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorTime(commitIds));
    }

    @Nullable
    public Long getCommitTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            long[] time = this.myIndexStorageBackend.getTimestamp(commit2);
            return time == null ? null : Long.valueOf(time[1]);
        });
    }

    @Nullable
    public Map<Integer, Long> getCommitTime(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitTime(commitIds));
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> this.myIndexStorageBackend.getMessage(index));
    }

    @Nullable
    public Map<Integer, String> getFullMessage(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(11);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getMessages(commitIds));
    }

    @Nullable
    public List<Hash> getParents(int index) {
        return (List)this.executeAndCatch(() -> {
            int[] parentsIndexes = this.myIndexStorageBackend.getParents(index);
            if (parentsIndexes == null) {
                return null;
            }
            return PhmVcsLogStorageBackendKt.getHashes(this.myLogStorage, parentsIndexes);
        });
    }

    @Nullable
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(12);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getParents(commitIds));
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(13);
        }
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter2 -> {
            if (filter2 instanceof VcsLogTextFilter || filter2 instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter2 instanceof VcsLogStructureFilter) {
                Collection<FilePath> files2 = ((VcsLogStructureFilter)filter2).getFiles();
                return ContainerUtil.find(files2, file -> file.isDirectory() && this.myProviders.containsKey(file.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(14);
        }
        IntSet intSet = this.filter(detailsFilters, null);
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        return intSet;
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable IntSet candidates) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(16);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        IntSet filteredByUser = null;
        if (userFilter != null) {
            HashSet<VcsUser> users = new HashSet<VcsUser>();
            for (VirtualFile root : this.myProviders.keySet()) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        IntSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        IntSet filteredByUserAndPath = IntCollectionUtil.intersect(filteredByUser, filteredByPath, candidates);
        if (textFilter == null) {
            Object object = filteredByUserAndPath == null ? IntSets.EMPTY_SET : filteredByUserAndPath;
            if (object == null) {
                IndexDataGetter.$$$reportNull$$$0(17);
            }
            return object;
        }
        return this.filterMessages(textFilter, filteredByUserAndPath);
    }

    @NotNull
    private IntSet filterUsers(@NotNull Set<? extends VcsUser> users) {
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(18);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitsForUsers(users), new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterPaths(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> {
            IntOpenHashSet result2 = new IntOpenHashSet();
            for (FilePath path2 : paths) {
                result2.addAll((IntCollection)this.createFileHistoryData(path2).build().getCommits());
                ProgressManager.checkCanceled();
            }
            return result2;
        }, new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(21);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterMessages(@NotNull VcsLogTextFilter filter2, @Nullable IntSet candidates) {
        if (filter2 == null) {
            IndexDataGetter.$$$reportNull$$$0(22);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        this.filterMessages(filter2, candidates, arg_0 -> ((IntSet)result2).add(arg_0));
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        return intOpenHashSet;
    }

    public void filterMessages(@NotNull VcsLogTextFilter filter2, @NotNull IntConsumer consumer2) {
        if (filter2 == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        if (consumer2 == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        this.filterMessages(filter2, null, consumer2);
    }

    private void filterMessages(@NotNull VcsLogTextFilter filter2, @Nullable IntSet candidates, @NotNull IntConsumer consumer2) {
        if (filter2 == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        if (consumer2 == null) {
            IndexDataGetter.$$$reportNull$$$0(27);
        }
        if (!filter2.isRegex() || filter2 instanceof VcsLogMultiplePatternsTextFilter) {
            this.executeAndCatch(() -> {
                List<String> trigramSources = filter2 instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter2).getPatterns() : Collections.singletonList(filter2.getText());
                ArrayList<String> noTrigramSources = new ArrayList<String>();
                for (String string2 : trigramSources) {
                    this.myIndexStorageBackend.getCommitsForSubstring(string2, candidates, noTrigramSources, consumer2, filter2);
                }
                if (!noTrigramSources.isEmpty()) {
                    VcsLogTextFilter noTrigramFilter = VcsLogFilterObject.fromPatternsList(noTrigramSources, filter2.matchesCase());
                    this.filter((IntIterable)candidates, noTrigramFilter::matches, consumer2);
                }
            });
        } else {
            this.executeAndCatch(() -> this.filter((IntIterable)candidates, filter2::matches, consumer2));
        }
    }

    private void filter(@Nullable IntIterable candidates, @NotNull Predicate<String> condition, @NotNull IntConsumer consumer2) throws IOException {
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(28);
        }
        if (consumer2 == null) {
            IndexDataGetter.$$$reportNull$$$0(29);
        }
        if (candidates == null) {
            this.myIndexStorageBackend.processMessages((Function2<? super Integer, ? super String, Boolean>)((Function2)(commit2, message2) -> {
                if (message2 != null && condition.test((String)message2)) {
                    consumer2.accept((int)commit2);
                }
                return true;
            }));
        } else {
            IntIterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                int commit3 = iterator.nextInt();
                String value2 = this.myIndexStorageBackend.getMessage(commit3);
                if (value2 == null || !condition.test(value2)) continue;
                consumer2.accept(commit3);
            }
        }
    }

    @NotNull
    private Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
        if (path2 == null) {
            IndexDataGetter.$$$reportNull$$$0(30);
        }
        Int2ObjectOpenHashMap affectedCommits = new Int2ObjectOpenHashMap();
        VirtualFile root = this.getRoot(path2);
        if (this.myProviders.containsKey(root) && root != null) {
            this.executeAndCatch(() -> this.lambda$getAffectedCommits$22(root, path2, (Int2ObjectMap)affectedCommits));
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = affectedCommits;
        if (int2ObjectOpenHashMap == null) {
            IndexDataGetter.$$$reportNull$$$0(31);
        }
        return int2ObjectOpenHashMap;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull FilePath path2) {
        if (path2 == null) {
            IndexDataGetter.$$$reportNull$$$0(32);
        }
        FileHistoryData fileHistoryData = this.createFileHistoryData(Collections.singletonList(path2));
        if (fileHistoryData == null) {
            IndexDataGetter.$$$reportNull$$$0(33);
        }
        return fileHistoryData;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(34);
        }
        if (paths.size() == 1 && ((FilePath)ContainerUtil.getFirstItem(paths)).isDirectory()) {
            return new DirectoryHistoryData((FilePath)ContainerUtil.getFirstItem(paths));
        }
        return new FileHistoryDataImpl(paths);
    }

    @NotNull
    public VcsLogStorage getLogStorage() {
        VcsLogStorage vcsLogStorage = this.myLogStorage;
        if (vcsLogStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(35);
        }
        return vcsLogStorage;
    }

    @NotNull
    VcsLogStorageBackend getIndexStorageBackend() {
        VcsLogStorageBackend vcsLogStorageBackend = this.myIndexStorageBackend;
        if (vcsLogStorageBackend == null) {
            IndexDataGetter.$$$reportNull$$$0(36);
        }
        return vcsLogStorageBackend;
    }

    @NotNull
    Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            IndexDataGetter.$$$reportNull$$$0(37);
        }
        return project2;
    }

    @Nullable
    private VirtualFile getRoot(@NotNull FilePath path2) {
        if (path2 == null) {
            IndexDataGetter.$$$reportNull$$$0(38);
        }
        if (this.myIsProjectLog) {
            return VcsLogUtil.getActualRoot(this.myProject, path2);
        }
        return VcsLogUtil.getActualRoot(this.myProject, this.myProviders, path2);
    }

    private void executeAndCatch(@NotNull Throwable2Runnable<IOException, StorageException> runnable) {
        if (runnable == null) {
            IndexDataGetter.$$$reportNull$$$0(39);
        }
        this.executeAndCatch(() -> {
            runnable.run();
            return null;
        }, null);
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(40);
        }
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<? extends T, IOException, StorageException> computable, @Nullable T defaultValue) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(41);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException | UncheckedIOException e) {
            this.myIndexStorageBackend.markCorrupted();
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(42);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            LOG.error("Unknown exception in Vcs Log index processing", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.myIndexStorageBackend.markCorrupted();
        this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
    }

    private /* synthetic */ Object lambda$getAffectedCommits$22(VirtualFile root, FilePath path2, Int2ObjectMap affectedCommits) throws IOException, StorageException {
        this.myIndexStorageBackend.iterateChangesInCommits(root, path2, (changes, commit2) -> this.executeAndCatch(() -> {
            int[] parents = this.myIndexStorageBackend.getParents(commit2);
            if (parents == null) {
                throw new CorruptedDataException("No parents for commit " + commit2);
            }
            Int2ObjectOpenHashMap changeMap = new Int2ObjectOpenHashMap(parents.length);
            if (parents.length == 0 && !changes.isEmpty()) {
                changeMap.put(commit2, (Object)((VcsLogPathsIndex.ChangeKind)((Object)((Object)((Object)ContainerUtil.getFirstItem((List)changes))))));
            } else {
                if (parents.length != changes.size()) {
                    throw new CorruptedDataException("Commit " + commit2 + " has " + parents.length + " parents, but " + changes.size() + " changes.");
                }
                int length = parents.length;
                for (int i = 0; i < length; ++i) {
                    changeMap.put(parents[i], (Object)((VcsLogPathsIndex.ChangeKind)((Object)((Object)((Object)changes.get(i))))));
                }
            }
            affectedCommits.put(commit2, (Object)changeMap);
            return null;
        }));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 17, 19, 21, 23, 31, 33, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageBackend";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIds";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 30: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitter";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedCommits";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileHistoryData";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogStorage";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexStorageBackend";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexedCommits";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAuthor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommitter";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorTime";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFullMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedCommits";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createFileHistoryData";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 15, 17, 19, 21, 23, 31, 33, 35, 36, 37 -> new IllegalStateException(string2);
        };
    }

    @FunctionalInterface
    private static interface Throwable2Runnable<E1 extends Throwable, E2 extends Throwable> {
        public void run() throws E1, E2;
    }

    private final class DirectoryHistoryData
    extends FileHistoryDataImpl {
        private final Map<EdgeData<Integer>, EdgeData<FilePath>> renamesMap;

        private DirectoryHistoryData(FilePath startPath) {
            if (startPath == null) {
                DirectoryHistoryData.$$$reportNull$$$0(0);
            }
            super(startPath);
            this.renamesMap = new HashMap<EdgeData<Integer>, EdgeData<FilePath>>();
            for (Map.Entry<EdgeData<CommitId>, EdgeData<FilePath>> entry2 : IndexDataGetter.this.myDirectoryRenamesProvider.getRenamesMap().entrySet()) {
                EdgeData<CommitId> commits2 = entry2.getKey();
                EdgeData<FilePath> rename = entry2.getValue();
                if (!VcsFileUtil.isAncestor((FilePath)rename.child, startPath, false)) continue;
                FilePath renamedPath = VcsUtil.getFilePath(((FilePath)rename.parent).getPath() + "/" + VcsFileUtil.relativePath((FilePath)rename.child, startPath), true);
                this.renamesMap.put(new EdgeData<Integer>(IndexDataGetter.this.myLogStorage.getCommitIndex(((CommitId)commits2.parent).getHash(), ((CommitId)commits2.parent).getRoot()), IndexDataGetter.this.myLogStorage.getCommitIndex(((CommitId)commits2.child).getHash(), ((CommitId)commits2.child).getRoot())), new EdgeData<FilePath>(renamedPath, startPath));
            }
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(1);
            }
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> affectedCommits = super.getAffectedCommits(path2);
            if (!path2.isDirectory()) {
                Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = affectedCommits;
                if (int2ObjectMap == null) {
                    DirectoryHistoryData.$$$reportNull$$$0(2);
                }
                return int2ObjectMap;
            }
            this.hackAffectedCommits(path2, affectedCommits);
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = affectedCommits;
            if (int2ObjectMap == null) {
                DirectoryHistoryData.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        private void hackAffectedCommits(@NotNull FilePath path2, @NotNull Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> affectedCommits) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(4);
            }
            if (affectedCommits == null) {
                DirectoryHistoryData.$$$reportNull$$$0(5);
            }
            for (Map.Entry<EdgeData<Integer>, EdgeData<FilePath>> entry2 : this.renamesMap.entrySet()) {
                VcsLogPathsIndex.ChangeKind newKind;
                int childCommit = (Integer)entry2.getKey().child;
                if (!affectedCommits.containsKey(childCommit)) continue;
                EdgeData<FilePath> rename = entry2.getValue();
                if (FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)((FilePath)rename.child), (Object)path2)) {
                    newKind = VcsLogPathsIndex.ChangeKind.ADDED;
                } else {
                    if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)((FilePath)rename.parent), (Object)path2)) continue;
                    newKind = VcsLogPathsIndex.ChangeKind.REMOVED;
                }
                Int2ObjectMap changesMap = (Int2ObjectMap)affectedCommits.get(childCommit);
                changesMap.keySet().forEach(key2 -> changesMap.put(key2, (Object)newKind));
            }
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(6);
            }
            if (path2.isDirectory()) {
                return this.findFolderRename(parent, child, path2, isChildPath);
            }
            return super.findRename(parent, child, path2, isChildPath);
        }

        @Nullable
        private EdgeData<FilePath> findFolderRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            EdgeData<FilePath> rename;
            if (path2 == null) {
                DirectoryHistoryData.$$$reportNull$$$0(7);
            }
            if ((rename = this.renamesMap.get(new EdgeData<Integer>(parent, child))) == null) {
                return null;
            }
            return FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)(isChildPath ? (FilePath)rename.child : (FilePath)rename.parent), (Object)path2) ? rename : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hackAffectedCommits";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findFolderRename";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private class FileHistoryDataImpl
    extends FileHistoryData {
        private FileHistoryDataImpl(FilePath startPath) {
            if (startPath == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(0);
            }
            super(startPath);
        }

        private FileHistoryDataImpl(Collection<? extends FilePath> startPaths) {
            if (startPaths == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(1);
            }
            super(startPaths);
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path2) {
            if (path2 == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(2);
            }
            Int2ObjectMap<Int2ObjectMap<VcsLogPathsIndex.ChangeKind>> int2ObjectMap = IndexDataGetter.this.getAffectedCommits(path2);
            if (int2ObjectMap == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path2, boolean isChildPath) {
            if (path2 == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(4);
            }
            VirtualFile root = Objects.requireNonNull(IndexDataGetter.this.getRoot(path2));
            return (EdgeData)IndexDataGetter.this.executeAndCatch(() -> IndexDataGetter.this.myIndexStorageBackend.findRename(parent, child, root, path2, isChildPath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPaths";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message2) {
            if (message2 == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }
}

