/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.ObjectBinder;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteIntPreparedStatement;
import org.jetbrains.sqlite.StatementCollection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0018H\u0002J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/vcs/log/data/index/SqliteVcsLogWriter;", "Lcom/intellij/vcs/log/data/index/VcsLogWriter;", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "(Lorg/jetbrains/sqlite/SqliteConnection;Lcom/intellij/vcs/log/data/VcsLogStorage;)V", "changeStatement", "Lorg/jetbrains/sqlite/SqliteIntPreparedStatement;", "logBatch", "Lorg/jetbrains/sqlite/ObjectBinder;", "parentDeleteStatement", "parentStatement", "renameDeleteStatement", "renameStatement", "statementCollection", "Lorg/jetbrains/sqlite/StatementCollection;", "userBatch", "close", "", "performCommit", "", "collectChangesAndPutRenames", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind;", "details", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$CompressedDetails;", "flush", "interrupt", "putCommit", "commitId", "", "putParents", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "parents", "Lcom/intellij/vcs/log/Hash;", "putPathChanges", "putRename", "parent", "child", "renames", "", "intellij.platform.vcs.log.impl"})
final class SqliteVcsLogWriter
implements VcsLogWriter {
    @NotNull
    private final SqliteConnection connection;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final StatementCollection statementCollection;
    @NotNull
    private final ObjectBinder logBatch;
    @NotNull
    private final ObjectBinder userBatch;
    @NotNull
    private final SqliteIntPreparedStatement parentDeleteStatement;
    @NotNull
    private final SqliteIntPreparedStatement parentStatement;
    @NotNull
    private final SqliteIntPreparedStatement renameDeleteStatement;
    @NotNull
    private final SqliteIntPreparedStatement renameStatement;
    @NotNull
    private final SqliteIntPreparedStatement changeStatement;

    public SqliteVcsLogWriter(@NotNull SqliteConnection connection, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.connection = connection;
        this.storage = storage;
        this.connection.beginTransaction();
        this.statementCollection = new StatementCollection(this.connection);
        this.logBatch = (ObjectBinder)this.statementCollection.prepareStatement("\n    insert into log(commitId, message, authorTime, commitTime, isCommitter) \n    values(?, ?, ?, ?, ?) \n    on conflict(commitId) do update set message=excluded.message\n    ", (Binder)new ObjectBinder(5, 1024)).getBinder();
        this.userBatch = (ObjectBinder)this.statementCollection.prepareStatement("\n    insert into user(commitId, isCommitter, name, email) \n    values(?, ?, ?, ?) \n    ", (Binder)new ObjectBinder(4, 256)).getBinder();
        this.parentDeleteStatement = this.statementCollection.prepareIntStatement("delete from parent where commitId = ?");
        this.parentStatement = this.statementCollection.prepareIntStatement("insert into parent(commitId, parent) values(?, ?)");
        this.renameDeleteStatement = this.statementCollection.prepareIntStatement("delete from rename where parent = ? and child = ?");
        this.renameStatement = this.statementCollection.prepareIntStatement("insert into rename(parent, child, rename) values(?, ?, ?)");
        this.changeStatement = this.statementCollection.prepareIntStatement("insert into path_change(commitId, pathId, kind) values(?, ?, ?)");
    }

    @Override
    public void putCommit(int commitId2, @NotNull VcsLogIndexer.CompressedDetails details) {
        int isCommitter;
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.putPathChanges(commitId2, details);
        VirtualFile virtualFile = details.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        List list2 = details.getParents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParents(...)");
        this.putParents(commitId2, virtualFile, list2);
        int n = isCommitter = Intrinsics.areEqual((Object)details.getAuthor(), (Object)details.getCommitter()) ? 0 : 1;
        if (isCommitter == 1) {
            this.userBatch.bind(commitId2, isCommitter, details.getCommitter().getName(), details.getCommitter().getEmail());
            this.userBatch.addBatch();
        }
        this.userBatch.bind(commitId2, 0, details.getAuthor().getName(), details.getAuthor().getEmail());
        this.userBatch.addBatch();
        this.logBatch.bind(commitId2, details.getFullMessage(), details.getAuthorTime(), details.getCommitTime(), isCommitter);
        this.logBatch.addBatch();
    }

    private final void putParents(int commitId2, VirtualFile root, List<? extends Hash> parents) {
        this.parentDeleteStatement.getBinder().bind(commitId2);
        this.parentDeleteStatement.addBatch();
        for (Hash hash2 : parents) {
            this.parentStatement.getBinder().bind(commitId2, this.storage.getCommitIndex(hash2, root));
            this.parentStatement.addBatch();
        }
    }

    private final void putRename(int parent, int child, int[] renames2) {
        this.renameDeleteStatement.getBinder().bind(parent, child);
        this.renameDeleteStatement.addBatch();
        for (int rename : renames2) {
            this.renameStatement.getBinder().bind(parent, child, rename);
            this.renameStatement.addBatch();
        }
    }

    private final void putPathChanges(int commitId2, VcsLogIndexer.CompressedDetails details) {
        Int2ObjectOpenHashMap<List<VcsLogPathsIndex.ChangeKind>> changesToStore = this.collectChangesAndPutRenames(details);
        this.changeStatement.ensureCapacity(changesToStore.size());
        for (Int2ObjectMap.Entry entry2 : changesToStore.int2ObjectEntrySet()) {
            int pathId = entry2.getIntKey();
            List changes = (List)entry2.getValue();
            for (VcsLogPathsIndex.ChangeKind change : changes) {
                this.changeStatement.getBinder().bind(commitId2, pathId, change.id);
                this.changeStatement.addBatch();
            }
        }
    }

    private final Int2ObjectOpenHashMap<List<VcsLogPathsIndex.ChangeKind>> collectChangesAndPutRenames(VcsLogIndexer.CompressedDetails details) {
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        int parentsCount = details.getParents().isEmpty() ? 1 : details.getParents().size();
        for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
            ObjectSet entries2 = details.getRenamedPaths(parentIndex).int2IntEntrySet();
            Intrinsics.checkNotNull((Object)entries2);
            if (!((Collection)entries2).isEmpty()) {
                int[] renames2 = new int[entries2.size() * 2];
                int index = 0;
                for (Int2IntMap.Entry entry2 : entries2) {
                    renames2[index++] = entry2.getIntKey();
                    renames2[index++] = entry2.getIntValue();
                    VcsLogPathsIndex.PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<VcsLogPathsIndex.ChangeKind>>)((Int2ObjectMap)result2), entry2.getIntKey(), parentsCount).set(parentIndex, VcsLogPathsIndex.ChangeKind.REMOVED);
                    VcsLogPathsIndex.PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<VcsLogPathsIndex.ChangeKind>>)((Int2ObjectMap)result2), entry2.getIntValue(), parentsCount).set(parentIndex, VcsLogPathsIndex.ChangeKind.ADDED);
                }
                Object Id2 = details.getId();
                Intrinsics.checkNotNullExpressionValue(Id2, (String)"getId(...)");
                Hash hash2 = (Hash)Id2;
                VirtualFile virtualFile = details.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                int commit2 = this.storage.getCommitIndex(hash2, virtualFile);
                Object Id3 = details.getParents().get(parentIndex);
                Intrinsics.checkNotNullExpressionValue(Id3, (String)"get(...)");
                Hash hash3 = (Hash)Id3;
                VirtualFile virtualFile2 = details.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                int parent = this.storage.getCommitIndex(hash3, virtualFile2);
                this.putRename(parent, commit2, renames2);
            }
            for (Int2ObjectMap.Entry entry3 : details.getModifiedPaths(parentIndex).int2ObjectEntrySet()) {
                VcsLogPathsIndex.PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<VcsLogPathsIndex.ChangeKind>>)((Int2ObjectMap)result2), entry3.getIntKey(), parentsCount).set(parentIndex, VcsLogPathsIndex.PathIndexer.createChangeData((Change.Type)((Object)entry3.getValue())));
            }
        }
        return result2;
    }

    @Override
    public void flush() {
        this.statementCollection.executeBatch();
        this.connection.commit();
        this.connection.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean performCommit) {
        try {
            this.statementCollection.close(performCommit);
        }
        finally {
            if (performCommit) {
                this.connection.commit();
            } else {
                this.connection.rollback();
            }
        }
    }

    @Override
    public void interrupt() {
        this.connection.interruptAndClose();
    }
}

