/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    @NotNull
    private final VcsLogTabLocation myLocation;

    protected OpenAnotherLogTabAction(@NotNull VcsLogTabLocation location) {
        if (location == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(0);
        }
        super(AllIcons.Actions.OpenNewTab);
        this.getTemplatePresentation().setText(() -> this.getText(VcsLogBundle.message("vcs", new Object[0])));
        this.getTemplatePresentation().setDescription(() -> this.getDescription(VcsLogBundle.message("vcs", new Object[0])));
        this.myLocation = location;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        VcsLogManager logManager2 = (VcsLogManager)ObjectUtils.chooseNotNull((Object)((VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER)), (Object)projectLog.getLogManager());
        if (logManager2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(projectLog.getLogManager() == logManager2);
        String vcsName = VcsLogUtil.getVcsDisplayName(project2, logManager2);
        e.getPresentation().setText(this.getText(vcsName));
        e.getPresentation().setDescription(this.getDescription(vcsName));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getDescription(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(2);
        }
        String string2 = VcsLogBundle.message("vcs.log.action.description.open.new.tab.with.log", vcsName);
        if (string2 == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getText(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(4);
        }
        String string2 = VcsLogBundle.message("vcs.log.action.open.new.tab.with.log", vcsName);
        if (string2 == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(6);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogFilterCollection filters = Registry.is((String)"vcs.log.copy.filters.to.new.tab") && logUi2 != null ? logUi2.getFilterUi().getFilters() : VcsLogFilterObject.collection(new VcsLogFilter[0]);
        VcsProjectLog.getInstance(project2).openLogTab(filters, this.myLocation);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(7);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 7 -> new IllegalStateException(string2);
        };
    }

    public static class InEditor
    extends OpenAnotherLogTabAction {
        protected InEditor() {
            super(VcsLogTabLocation.EDITOR);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                InEditor.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (!Registry.is((String)"vcs.log.open.editor.tab")) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        protected String getDescription(@Nls @NotNull String vcsName) {
            if (vcsName == null) {
                InEditor.$$$reportNull$$$0(1);
            }
            String string2 = VcsLogBundle.message("vcs.log.action.description.open.new.tab.with.log.in.editor", vcsName);
            if (string2 == null) {
                InEditor.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        @Nls(capitalization=Nls.Capitalization.Title)
        protected String getText(@Nls @NotNull String vcsName) {
            if (vcsName == null) {
                InEditor.$$$reportNull$$$0(3);
            }
            String string2 = VcsLogBundle.message("vcs.log.action.open.new.tab.with.log.in.editor", vcsName);
            if (string2 == null) {
                InEditor.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 4 -> new IllegalStateException(string2);
            };
        }
    }

    public static class InToolWindow
    extends OpenAnotherLogTabAction {
        protected InToolWindow() {
            super(VcsLogTabLocation.TOOL_WINDOW);
        }
    }
}

