/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.intellij.webSymbols.WebSymbolOrigin;
import com.intellij.webSymbols.WebSymbolTypeSupport;
import com.intellij.webSymbols.context.WebSymbolsContext;
import com.intellij.webSymbols.context.WebSymbolsContextKindRules;
import com.intellij.webSymbols.customElements.CustomElementsJsonOrigin;
import com.intellij.webSymbols.customElements.json.CustomElementClassOrMixinDeclaration;
import com.intellij.webSymbols.customElements.json.CustomElementsJsonUtilsKt;
import com.intellij.webSymbols.customElements.json.CustomElementsManifest;
import com.intellij.webSymbols.customElements.json.CustomElementsPackage;
import com.intellij.webSymbols.customElements.json.JavaScriptModule;
import com.intellij.webSymbols.customElements.json.SourceReference;
import com.intellij.webSymbols.impl.StaticWebSymbolsScopeBase;
import com.intellij.webSymbols.query.WebSymbolNameConversionRules;
import com.intellij.webSymbols.query.WebSymbolNameConversionRulesProvider;
import com.intellij.webSymbols.utils.HtmlMarkdownUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0005J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00022\u000e\u0010\r\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0014J\u0010\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0016H&J\u0018\u0010\u0017\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\r\u001a\u00060\bj\u0002`\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/webSymbols/customElements/CustomElementsManifestScopeBase;", "Lcom/intellij/webSymbols/impl/StaticWebSymbolsScopeBase;", "Lcom/intellij/webSymbols/customElements/json/CustomElementsManifest;", "", "Lcom/intellij/webSymbols/customElements/CustomElementsJsonOrigin;", "()V", "registeredContexts", "", "", "adaptAllContributions", "Lkotlin/sequences/Sequence;", "Lcom/intellij/webSymbols/impl/StaticWebSymbolsScopeBase$StaticSymbolContributionAdapter;", "contribution", "framework", "Lcom/intellij/webSymbols/FrameworkId;", "origin", "adaptAllRootContributions", "root", "addCustomElementsManifest", "", "manifest", "createPointer", "Lcom/intellij/model/Pointer;", "getContextRules", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/context/WebSymbolsContextKindRules;", "getNameConversionRulesProvider", "Lcom/intellij/webSymbols/query/WebSymbolNameConversionRulesProvider;", "matchContext", "", "context", "Lcom/intellij/webSymbols/context/WebSymbolsContext;", "removeCustomElementsManifest", "CustomElementsManifestJsonOriginImpl", "intellij.platform.webSymbols"})
public abstract class CustomElementsManifestScopeBase
extends StaticWebSymbolsScopeBase<CustomElementsManifest, Object, CustomElementsJsonOrigin> {
    @NotNull
    private final Set<String> registeredContexts = new LinkedHashSet();

    @Override
    @NotNull
    public abstract Pointer<? extends CustomElementsManifestScopeBase> createPointer();

    protected void addCustomElementsManifest(@NotNull CustomElementsManifest manifest, @NotNull CustomElementsJsonOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (!this.registeredContexts.add(origin.getLibrary())) {
            throw new IllegalStateException("Manifest for " + origin.getLibrary() + " is already registered.");
        }
        this.addRoot$intellij_platform_webSymbols(manifest, (WebSymbolOrigin)origin);
    }

    protected void removeCustomElementsManifest(@NotNull CustomElementsManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Collection collection = this.registeredContexts;
        CustomElementsJsonOrigin customElementsJsonOrigin = (CustomElementsJsonOrigin)this.getRootOrigin$intellij_platform_webSymbols(manifest);
        String string2 = customElementsJsonOrigin != null ? customElementsJsonOrigin.getLibrary() : null;
        TypeIntrinsics.asMutableCollection((Object)collection).remove(string2);
        this.removeRoot$intellij_platform_webSymbols(manifest);
    }

    @Override
    @NotNull
    protected Sequence<StaticWebSymbolsScopeBase.StaticSymbolContributionAdapter> adaptAllRootContributions(@NotNull CustomElementsManifest root, @Nullable String framework, @NotNull CustomElementsJsonOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return CustomElementsJsonUtilsKt.adaptAllContributions(root, origin, this);
    }

    @Override
    @NotNull
    protected Sequence<StaticWebSymbolsScopeBase.StaticSymbolContributionAdapter> adaptAllContributions(@NotNull Object contribution, @Nullable String framework, @NotNull CustomElementsJsonOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)contribution, (String)"contribution");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Object object = contribution;
        return object instanceof CustomElementsPackage ? CustomElementsJsonUtilsKt.adaptAllContributions((CustomElementsPackage)contribution, origin, this) : (object instanceof JavaScriptModule ? CustomElementsJsonUtilsKt.adaptAllContributions((JavaScriptModule)contribution, origin, this) : (object instanceof CustomElementClassOrMixinDeclaration ? CustomElementsJsonUtilsKt.adaptAllContributions((CustomElementClassOrMixinDeclaration)contribution, origin) : SequencesKt.emptySequence()));
    }

    @Override
    protected boolean matchContext(@NotNull CustomElementsJsonOrigin origin, @NotNull WebSymbolsContext context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public MultiMap<String, WebSymbolsContextKindRules> getContextRules() {
        MultiMap multiMap = MultiMap.empty();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
        return multiMap;
    }

    @Override
    @NotNull
    public WebSymbolNameConversionRulesProvider getNameConversionRulesProvider(@NotNull String framework) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        return new WebSymbolNameConversionRulesProvider(){

            @NotNull
            public WebSymbolNameConversionRules getNameConversionRules() {
                return WebSymbolNameConversionRules.Companion.empty();
            }

            @NotNull
            public Pointer<? extends WebSymbolNameConversionRulesProvider> createPointer() {
                Pointer pointer = Pointer.hardPointer((Object)this);
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
                return pointer;
            }

            public long getModificationCount() {
                return 0L;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0004\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012:\b\u0002\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\b\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u001c\u0010\u0011\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R@\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/webSymbols/customElements/CustomElementsManifestScopeBase$CustomElementsManifestJsonOriginImpl;", "Lcom/intellij/webSymbols/customElements/CustomElementsJsonOrigin;", "library", "", "version", "typeSupport", "Lcom/intellij/webSymbols/WebSymbolTypeSupport;", "sourceSymbolResolver", "Lkotlin/Function2;", "Lcom/intellij/webSymbols/customElements/json/SourceReference;", "Lkotlin/ParameterName;", "name", "source", "Lcom/intellij/openapi/util/UserDataHolderEx;", "cacheHolder", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/webSymbols/WebSymbolTypeSupport;Lkotlin/jvm/functions/Function2;)V", "framework", "Lcom/intellij/webSymbols/FrameworkId;", "getFramework", "()Ljava/lang/String;", "getLibrary", "getTypeSupport", "()Lcom/intellij/webSymbols/WebSymbolTypeSupport;", "getVersion", "renderDescription", "description", "resolveSourceSymbol", "toString", "intellij.platform.webSymbols"})
    protected static final class CustomElementsManifestJsonOriginImpl
    implements CustomElementsJsonOrigin {
        @NotNull
        private final String library;
        @Nullable
        private final String version;
        @Nullable
        private final WebSymbolTypeSupport typeSupport;
        @NotNull
        private final Function2<SourceReference, UserDataHolderEx, PsiElement> sourceSymbolResolver;
        @Nullable
        private final String framework;

        public CustomElementsManifestJsonOriginImpl(@NotNull String library, @Nullable String version, @Nullable WebSymbolTypeSupport typeSupport, @NotNull Function2<? super SourceReference, ? super UserDataHolderEx, ? extends PsiElement> sourceSymbolResolver) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter(sourceSymbolResolver, (String)"sourceSymbolResolver");
            this.library = library;
            this.version = version;
            this.typeSupport = typeSupport;
            this.sourceSymbolResolver = sourceSymbolResolver;
        }

        public /* synthetic */ CustomElementsManifestJsonOriginImpl(String string2, String string3, WebSymbolTypeSupport webSymbolTypeSupport, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                webSymbolTypeSupport = null;
            }
            if ((n & 8) != 0) {
                function2 = 1.INSTANCE;
            }
            this(string2, string3, webSymbolTypeSupport, (Function2<? super SourceReference, ? super UserDataHolderEx, ? extends PsiElement>)function2);
        }

        @Override
        @NotNull
        public String getLibrary() {
            return this.library;
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Override
        @Nullable
        public WebSymbolTypeSupport getTypeSupport() {
            return this.typeSupport;
        }

        @Override
        @Nullable
        public String getFramework() {
            return this.framework;
        }

        @Override
        @Nullable
        public PsiElement resolveSourceSymbol(@NotNull SourceReference source2, @NotNull UserDataHolderEx cacheHolder) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)cacheHolder, (String)"cacheHolder");
            return (PsiElement)this.sourceSymbolResolver.invoke((Object)source2, (Object)cacheHolder);
        }

        @Override
        @NotNull
        public String renderDescription(@NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            Object object = HtmlMarkdownUtils.toHtml(description2, false);
            if (object == null) {
                object = "<p>" + description2;
            }
            return object;
        }

        @NotNull
        public String toString() {
            return this.getLibrary() + "@" + this.getVersion();
        }
    }
}

