/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import org.apache.commons.collections.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;
    private static final long serialVersionUID = 2197433140769957051L;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int i) {
        super(i);
        this.maximumSize = i;
    }

    public Object get(Object key2) {
        if (!this.containsKey(key2)) {
            return null;
        }
        Object value2 = this.remove(key2);
        super.put(key2, value2);
        return value2;
    }

    public Object put(Object key2, Object value2) {
        int mapSize = this.size();
        Object retval = null;
        if (mapSize >= this.maximumSize && !this.containsKey(key2)) {
            this.removeLRU();
        }
        retval = super.put(key2, value2);
        return retval;
    }

    protected void removeLRU() {
        Object key2 = this.getFirstKey();
        Object value2 = super.get(key2);
        this.remove(key2);
        this.processRemovedLRU(key2, value2);
    }

    protected void processRemovedLRU(Object key2, Object value2) {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.maximumSize = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key2 = in.readObject();
            Object value2 = in.readObject();
            this.put(key2, value2);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.maximumSize);
        out.writeInt(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object key2 = iterator.next();
            out.writeObject(key2);
            Object value2 = super.get(key2);
            out.writeObject(value2);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
        while (this.size() > maximumSize) {
            this.removeLRU();
        }
    }
}

