/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.ecmascript;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.util.SmartList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.intention.CheckRegExpForm;
import org.jetbrains.annotations.Nullable;

public class EcmaScriptRegExpMatcherProvider
implements RegExpMatcherProvider {
    private static final Logger LOG = Logger.getInstance(EcmaScriptRegExpMatcherProvider.class);

    @Override
    @Nullable
    public RegExpMatchResult matches(String regExp, PsiFile regExpFile, PsiElement elementInHost, String sampleText, long timeoutMillis) {
        ScriptEngine engine;
        Object modifiers = "";
        if (elementInHost instanceof PsiLiteralValue) {
            int slash;
            String text2 = elementInHost.getText();
            int n = slash = StringUtil.isQuotedString((String)text2) ? -1 : text2.lastIndexOf(47);
            if (slash > 0) {
                if (text2.indexOf(105, slash) > 0) {
                    modifiers = (String)modifiers + "i";
                }
                if (text2.indexOf(109, slash) > 0) {
                    modifiers = (String)modifiers + "m";
                }
                if (text2.indexOf(117, slash) > 0) {
                    modifiers = (String)modifiers + "u";
                }
            }
        }
        if ((engine = new ScriptEngineManager().getEngineByName("nashorn")) == null) {
            LOG.warn("Nashorn JS scripting engine not found, falling back to Java regex evaluation");
            return null;
        }
        try {
            String script = "var regexp = RegExp(\"" + StringUtil.escapeStringCharacters((String)regExp) + "\",'g" + (String)modifiers + "');\nvar str = \"" + StringUtil.escapeStringCharacters((String)sampleText) + "\";\nvar match;\n\nvar RegExpMatch = Java.type(\"org.intellij.lang.regexp.RegExpMatch\");\nvar prev = null;\nwhile ((match = regexp.exec(str)) !== null) {\n  var r = new RegExpMatch(match.index, regexp.lastIndex);\n  if (r.equals(prev)) break;\n  prev = r;\n  result.add(r);\n}\nresult";
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("result", (Object)new SmartList());
            List result2 = (List)engine.eval(script, (Bindings)bindings);
            CheckRegExpForm.setMatches(regExpFile, result2);
            return result2.isEmpty() ? RegExpMatchResult.NO_MATCH : RegExpMatchResult.FOUND;
        }
        catch (Exception e) {
            return RegExpMatchResult.BAD_REGEXP;
        }
    }
}

