/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconInternWrapper;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolCachedImageIcon;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/icons/CachedImageIcon;", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "readIcon", "", "url", "Ljava/net/URL;", "dark", "", "retina", "intellij.rd.ui"})
public final class ImageIconConverter
implements ProtocolIconConverter<CachedImageIcon, ImageIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull ImageIconModel model, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String path = model.getWrapper().getPath();
        Icon icon2 = IconLoader.findIcon((String)path, AllIcons.class, (boolean)false, (boolean)false);
        if (icon2 != null && !(icon2 instanceof CachedImageIcon)) {
            return icon2;
        }
        return registry.cacheIcon(model.getWrapper().getIdentity(), (Function1<? super Long, ? extends Icon>)((Function1)new Function1<Long, Icon>(model, icon2, path){
            final /* synthetic */ ImageIconModel $model;
            final /* synthetic */ Icon $icon;
            final /* synthetic */ String $path;
            {
                this.$model = $model;
                this.$icon = $icon;
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Icon invoke(long it) {
                List<IconSource> sources = this.$model.getWrapper().getSources();
                Icon icon2 = this.$icon;
                return (Icon)((Object)new ProtocolCachedImageIcon(icon2 instanceof CachedImageIcon ? (CachedImageIcon)icon2 : null, this.$path, null, sources));
            }
        }));
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull CachedImageIcon icon2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return registry.cacheModel((Icon)icon2, (Function1<? super Long, ? extends IconModel>)((Function1)new Function1<Long, IconModel>(icon2, this){
            final /* synthetic */ CachedImageIcon $icon;
            final /* synthetic */ ImageIconConverter this$0;
            {
                this.$icon = $icon;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IconModel invoke(long identity) {
                Object object;
                boolean bl;
                List sources;
                String ext2;
                String name;
                String path;
                block21: {
                    String string;
                    Logger logger;
                    String originalPath;
                    CachedImageIcon darkIcon;
                    CachedImageIcon whiteIcon;
                    block25: {
                        block24: {
                            block23: {
                                String string2;
                                block22: {
                                    String string3;
                                    String string4;
                                    void $this$trace$iv;
                                    CachedImageIcon cachedImageIcon = this.$icon.getDarkIcon(false);
                                    Intrinsics.checkNotNull((Object)cachedImageIcon, (String)"null cannot be cast to non-null type com.intellij.ui.icons.CachedImageIcon");
                                    whiteIcon = cachedImageIcon;
                                    CachedImageIcon cachedImageIcon2 = this.$icon.getDarkIcon(true);
                                    Intrinsics.checkNotNull((Object)cachedImageIcon2, (String)"null cannot be cast to non-null type com.intellij.ui.icons.CachedImageIcon");
                                    darkIcon = cachedImageIcon2;
                                    originalPath = this.$icon.getOriginalPath();
                                    Logger logger2 = ImageIconConverterKt.access$getLogger$p();
                                    CachedImageIcon cachedImageIcon3 = this.$icon;
                                    boolean $i$f$trace = false;
                                    if ($this$trace$iv.isTraceEnabled()) {
                                        logger = $this$trace$iv;
                                        boolean bl2 = false;
                                        URL uRL = cachedImageIcon3.getUrl();
                                        logger.trace("originalPath=" + originalPath + ", icon.url.path=" + (uRL != null ? uRL.getPath() : null));
                                    }
                                    if ((string4 = originalPath) == null) {
                                        URL uRL = this.$icon.getUrl();
                                        string4 = uRL != null ? uRL.getPath() : null;
                                    }
                                    if (string4 != null) {
                                        String string5;
                                        String it = string4;
                                        boolean bl3 = false;
                                        Pair pair = URLUtil.splitJarUrl((String)it);
                                        String string6 = string5 = pair != null ? (String)pair.second : null;
                                        if (string6 == null) {
                                            string3 = it;
                                        } else {
                                            Intrinsics.checkNotNull((Object)string6);
                                            string3 = string5;
                                        }
                                    } else {
                                        string3 = null;
                                    }
                                    if ((string2 = (path = string3)) == null) break block22;
                                    String it = string2;
                                    boolean bl4 = false;
                                    String string7 = FileUtilRt.getNameWithoutExtension((String)it);
                                    string2 = string7;
                                    if (string7 != null) break block23;
                                }
                                string2 = name = "protocol_icon_no_path";
                            }
                            if ((string = path) == null) break block24;
                            String it = string;
                            boolean bl5 = false;
                            String string8 = FileUtilRt.getExtension((String)it);
                            string = string8;
                            if (string8 != null) break block25;
                        }
                        string = "png";
                    }
                    ext2 = string;
                    Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                    boolean $i$f$trace22 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl6 = false;
                        logger.trace("path=" + path + ", name=" + name + ", ext=" + ext2);
                    }
                    if (originalPath == null) {
                        ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + name + "." + ext2 + " as a fallback");
                    }
                    Object[] $i$f$trace22 = new IconSource[]{new IconSource(name + "." + ext2, ImageIconConverter.access$readIcon(this.this$0, whiteIcon.getUrl(), false, false)), new IconSource(name + "@2x." + ext2, ImageIconConverter.access$readIcon(this.this$0, whiteIcon.getUrl(), false, true)), new IconSource(name + "_dark." + ext2, ImageIconConverter.access$readIcon(this.this$0, darkIcon.getUrl(), true, false)), new IconSource(name + "@2x_dark." + ext2, ImageIconConverter.access$readIcon(this.this$0, darkIcon.getUrl(), true, true))};
                    sources = CollectionsKt.listOf((Object[])$i$f$trace22);
                    Iterable $this$all$iv = sources;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            IconSource it = (IconSource)element$iv;
                            boolean bl7 = false;
                            if (it.getBody() == null) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ImageIconConverterKt.access$getLogger$p().error("Failed to read icon:'" + path + "'");
                }
                if ((object = path) == null) {
                    object = name + "." + ext2;
                }
                return new ImageIconModel(new ImageIconInternWrapper(identity, (String)object, sources));
            }
        }));
    }

    private final byte[] readIcon(URL url, boolean dark, boolean retina) {
        byte[] byArray;
        URL uRL = url;
        String string = uRL != null ? uRL.getPath() : null;
        if (string == null) {
            return null;
        }
        String path = string;
        String nameWithWithoutExtension = StringsKt.substringBeforeLast$default((String)path, (String)".", null, (int)2, null);
        String extension = StringsKt.substringAfterLast$default((String)path, (String)".", null, (int)2, null);
        String normalizedName = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)nameWithWithoutExtension, (CharSequence)"@2x_dark"), (CharSequence)"@2x"), (CharSequence)"_dark");
        String newFile = normalizedName + (retina ? "@2x" : "") + (dark ? "_dark" : "") + "." + extension;
        URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), newFile);
        try {
            byArray = TextStreamsKt.readBytes((URL)newUrl);
        }
        catch (IOException ex) {
            byArray = null;
        }
        byte[] bytes = byArray;
        if (bytes == null && dark && retina) {
            byte[] byArray2;
            String fallbackPath = normalizedName + "_dark@2x." + extension;
            URL fallbackUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), fallbackPath);
            try {
                byArray2 = TextStreamsKt.readBytes((URL)fallbackUrl);
            }
            catch (IOException ex) {
                byArray2 = null;
            }
            return byArray2;
        }
        return bytes;
    }

    public static final /* synthetic */ byte[] access$readIcon(ImageIconConverter $this, URL url, boolean dark, boolean retina) {
        return $this.readIcon(url, dark, retina);
    }
}

