/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.editor;

import com.intellij.collaboration.ui.codereview.editor.ReviewInEditorUtil;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.LineStatusMarkerColorScheme;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupActions;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopup;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.ui.EditorTextField;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.mergerequest.GitLabMergeRequestsPreferences;
import org.jetbrains.plugins.gitlab.mergerequest.ui.editor.GitLabMergeRequestEditorReviewUIModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.editor.GitLabMergeRequestReviewChangesGutterRendererKt;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0006$%&'()B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J8\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup;", "model", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestEditorReviewUIModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestEditorReviewUIModel;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;)V", "createErrorStripeTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "diffType", "", "createPopupEditor", "project", "Lcom/intellij/openapi/project/Project;", "mainEditor", "vcsContent", "", "createPopupPanel", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "paintGutterMarkers", "", "ranges", "", "g", "Ljava/awt/Graphics;", "showLineDiff", "preferences", "Lorg/jetbrains/plugins/gitlab/mergerequest/GitLabMergeRequestsPreferences;", "popupEditor", "", "CopyLineStatusRangeAction", "ReviewChangesTextAttributes", "ShowDiffAction", "ShowNextChangeMarkerAction", "ShowPrevChangeMarkerAction", "ToggleByWordDiffAction", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestReviewChangesGutterRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestReviewChangesGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n30#2,3:258\n1#3:261\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestReviewChangesGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer\n*L\n68#1:258,3\n*E\n"})
public final class GitLabMergeRequestReviewChangesGutterRenderer
extends LineStatusMarkerRendererWithPopup {
    @NotNull
    private final GitLabMergeRequestEditorReviewUIModel model;
    @NotNull
    private final Editor editor;

    public GitLabMergeRequestReviewChangesGutterRenderer(@NotNull GitLabMergeRequestEditorReviewUIModel model, @NotNull Editor editor, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Project project = editor.getProject();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        super(project, document, (LineStatusMarkerRangesSource)model, disposable, arg_0 -> GitLabMergeRequestReviewChangesGutterRenderer._init_$lambda$0(editor, arg_0), false, 32, null);
        this.model = model;
        this.editor = editor;
    }

    protected void paintGutterMarkers(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        LineStatusMarkerDrawUtil.paintDefault((Editor)editor, (Graphics)g, ranges, (VisibleRangeMerger.FlagsProvider)DefaultFlagsProvider.DEFAULT, (LineStatusMarkerColorScheme)ReviewInEditorUtil.INSTANCE.getREVIEW_STATUS_MARKER_COLOR_SCHEME(), (int)0);
    }

    @NotNull
    protected TextAttributes createErrorStripeTextAttributes(byte diffType) {
        return new ReviewChangesTextAttributes();
    }

    @NotNull
    protected LineStatusMarkerPopupPanel createPopupPanel(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable disposable) {
        JComponent jComponent;
        GitLabMergeRequestsPreferences gitLabMergeRequestsPreferences;
        Object $this$service$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        String string = this.model.getOriginalContent(new LineRange(range.getVcsLine1(), range.getVcsLine2()));
        String vcsContent = string != null ? StringsKt.removeSuffix((String)string, (CharSequence)"\n") : null;
        Project project = this.getProject();
        if (project != null) {
            $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitLabMergeRequestsPreferences> serviceClass$iv = GitLabMergeRequestsPreferences.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            gitLabMergeRequestsPreferences = (GitLabMergeRequestsPreferences)((Object)object);
        } else {
            gitLabMergeRequestsPreferences = null;
        }
        GitLabMergeRequestsPreferences preferences = gitLabMergeRequestsPreferences;
        $this$service$iv = vcsContent;
        if (!($this$service$iv == null || $this$service$iv.length() == 0)) {
            Editor popupEditor = this.createPopupEditor(this.getProject(), editor, vcsContent, disposable);
            if (preferences != null) {
                this.showLineDiff(preferences, editor, popupEditor, range, vcsContent, disposable);
            }
            jComponent = LineStatusMarkerPopupPanel.createEditorComponent((Editor)editor, (JComponent)popupEditor.getComponent());
        } else {
            jComponent = null;
        }
        JComponent editorComponent = jComponent;
        Object[] $i$f$service = new AnAction[]{new ShowPrevChangeMarkerAction(range), new ShowNextChangeMarkerAction(range), new CopyLineStatusRangeAction(range), new ShowDiffAction(range)};
        List actions = CollectionsKt.mutableListOf((Object[])$i$f$service);
        if (preferences != null) {
            actions.add(new ToggleByWordDiffAction(preferences));
        }
        ActionToolbar actionToolbar = LineStatusMarkerPopupPanel.buildToolbar((Editor)editor, (List)actions, (Disposable)disposable);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"buildToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        LineStatusMarkerPopupPanel lineStatusMarkerPopupPanel = LineStatusMarkerPopupPanel.create((Editor)editor, (ActionToolbar)toolbar, (JComponent)editorComponent, null);
        Intrinsics.checkNotNullExpressionValue((Object)lineStatusMarkerPopupPanel, (String)"create(...)");
        return lineStatusMarkerPopupPanel;
    }

    private final Editor createPopupEditor(Project project, Editor mainEditor, String vcsContent, Disposable disposable) {
        EditorFactory factory = EditorFactory.getInstance();
        Editor editor = factory.createViewer(factory.createDocument((CharSequence)vcsContent), project, EditorKind.DIFF);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        ReadAction.run(() -> GitLabMergeRequestReviewChangesGutterRenderer.createPopupEditor$lambda$3(editor2, mainEditor, project));
        DisposerUtilKt.whenDisposed((Disposable)disposable, (Function0)((Function0)new Function0<Unit>(factory, editor2){
            final /* synthetic */ EditorFactory $factory;
            final /* synthetic */ EditorEx $editor;
            {
                this.$factory = $factory;
                this.$editor = $editor;
                super(0);
            }

            public final void invoke() {
                this.$factory.releaseEditor((Editor)this.$editor);
            }
        }));
        return (Editor)editor2;
    }

    private final void showLineDiff(GitLabMergeRequestsPreferences preferences, Editor editor, Editor popupEditor, Range range, CharSequence vcsContent, Disposable disposable) {
        Ref.ObjectRef highlightersDisposable = new Ref.ObjectRef();
        preferences.addListener(disposable, arg_0 -> GitLabMergeRequestReviewChangesGutterRenderer.showLineDiff$lambda$7(highlightersDisposable, vcsContent, editor, range, popupEditor, disposable, arg_0));
        GitLabMergeRequestReviewChangesGutterRenderer.showLineDiff$update((Ref.ObjectRef<Disposable>)highlightersDisposable, vcsContent, editor, range, popupEditor, disposable, preferences.getHighlightDiffLinesInEditor());
    }

    private static final boolean _init_$lambda$0(Editor $editor, Editor it) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == $editor;
    }

    private static final void createPopupEditor$lambda$3(EditorEx $editor, Editor $mainEditor, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$mainEditor, (String)"$mainEditor");
        EditorEx $this$createPopupEditor_u24lambda_u243_u24lambda_u242 = $editor;
        boolean bl = false;
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setCaretEnabled(false);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.getContentComponent().setFocusCycleRoot(false);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setRendererMode(true);
        EditorTextField.setupTextFieldEditor((EditorEx)$this$createPopupEditor_u24lambda_u243_u24lambda_u242);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setVerticalScrollbarVisible(true);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setHorizontalScrollbarVisible(true);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setBorder(null);
        EditorSettings $this$createPopupEditor_u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$createPopupEditor_u24lambda_u243_u24lambda_u242.getSettings();
        boolean bl2 = false;
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242_u24lambda_u241.setUseSoftWraps(false);
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242_u24lambda_u241.setTabSize($mainEditor.getSettings().getTabSize($project));
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242_u24lambda_u241.setUseTabCharacter($mainEditor.getSettings().isUseTabCharacter($project));
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setColorsScheme($mainEditor.getColorsScheme());
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.setBackgroundColor(LineStatusMarkerPopupPanel.getEditorBackgroundColor((Editor)$mainEditor));
        $this$createPopupEditor_u24lambda_u243_u24lambda_u242.getSelectionModel().removeSelection();
    }

    private static final List showLineDiff$update$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void showLineDiff$update(Ref.ObjectRef<Disposable> highlightersDisposable, CharSequence $vcsContent, Editor $editor, Range $range, Editor $popupEditor, Disposable $disposable, boolean show2) {
        if (show2 && highlightersDisposable.element == null) {
            Object object;
            if ($vcsContent.length() == 0) {
                return;
            }
            CharSequence charSequence = DiffUtil.getLinesContent((Document)$editor.getDocument(), (int)$range.getLine1(), (int)$range.getLine2());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLinesContent(...)");
            CharSequence currentContent = charSequence;
            if (currentContent.length() == 0) {
                return;
            }
            Disposable it = object = Disposer.newDisposable();
            boolean bl = false;
            Disposer.register((Disposable)$disposable, (Disposable)it);
            Disposable disposable = object;
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"also(...)");
            Disposable newDisposable = disposable;
            highlightersDisposable.element = newDisposable;
            List lineDiff2 = (List)BackgroundTaskUtil.tryComputeFast(arg_0 -> GitLabMergeRequestReviewChangesGutterRenderer.showLineDiff$update$lambda$5((Function1)new Function1<ProgressIndicator, List<LineFragment>>($vcsContent, currentContent){
                final /* synthetic */ CharSequence $vcsContent;
                final /* synthetic */ CharSequence $currentContent;
                {
                    this.$vcsContent = $vcsContent;
                    this.$currentContent = $currentContent;
                    super(1);
                }

                public final List<LineFragment> invoke(@Nullable ProgressIndicator indicator) {
                    ComparisonManager comparisonManager = ComparisonManager.getInstance();
                    ProgressIndicator progressIndicator = indicator;
                    Intrinsics.checkNotNull((Object)progressIndicator);
                    return comparisonManager.compareLines(this.$vcsContent, this.$currentContent, ComparisonPolicy.DEFAULT, progressIndicator);
                }
            }, arg_0), (long)200L);
            if (lineDiff2 == null) {
                return;
            }
            LineStatusMarkerPopupPanel.installMasterEditorWordHighlighters((Editor)$editor, (int)$range.getLine1(), (int)$range.getLine2(), (List)lineDiff2, (Disposable)newDisposable);
            it = object = LineStatusMarkerPopupPanel.installEditorDiffHighlighters((Editor)$popupEditor, (List)lineDiff2);
            boolean bl2 = false;
            DisposerUtilKt.whenDisposed((Disposable)newDisposable, (Function0)((Function0)new Function0<Unit>((List<RangeHighlighter>)it){
                final /* synthetic */ List<RangeHighlighter> $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    List<RangeHighlighter> list = this.$it;
                    Intrinsics.checkNotNullExpressionValue(list, (String)"$it");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        RangeHighlighter p0 = (RangeHighlighter)element$iv;
                        boolean bl = false;
                        p0.dispose();
                    }
                }
            }));
        } else {
            Disposable disposable = (Disposable)highlightersDisposable.element;
            if (disposable != null) {
                Disposable p0 = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            highlightersDisposable.element = null;
        }
    }

    private static final void showLineDiff$lambda$7(Ref.ObjectRef $highlightersDisposable, CharSequence $vcsContent, Editor $editor, Range $range, Editor $popupEditor, Disposable $disposable, GitLabMergeRequestsPreferences.SettingsState state) {
        Intrinsics.checkNotNullParameter((Object)$highlightersDisposable, (String)"$highlightersDisposable");
        Intrinsics.checkNotNullParameter((Object)$vcsContent, (String)"$vcsContent");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$range, (String)"$range");
        Intrinsics.checkNotNullParameter((Object)$popupEditor, (String)"$popupEditor");
        Intrinsics.checkNotNullParameter((Object)$disposable, (String)"$disposable");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        GitLabMergeRequestReviewChangesGutterRenderer.showLineDiff$update((Ref.ObjectRef<Disposable>)$highlightersDisposable, $vcsContent, $editor, $range, $popupEditor, $disposable, state.getHighlightDiffLinesInEditor());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$CopyLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabled", "", "intellij.vcs.gitlab"})
    private final class CopyLineStatusRangeAction
    extends LineStatusMarkerPopupActions.RangeMarkerAction
    implements LightEditCompatible {
        public CopyLineStatusRangeAction(Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(GitLabMergeRequestReviewChangesGutterRenderer.this.editor, GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource(), range, "$Copy");
        }

        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return range.hasVcsLines();
        }

        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            String content = GitLabMergeRequestReviewChangesGutterRenderer.this.model.getOriginalContent(new LineRange(range.getVcsLine1(), range.getVcsLine2()));
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$ReviewChangesTextAttributes;", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;)V", "getErrorStripeColor", "Ljava/awt/Color;", "intellij.vcs.gitlab"})
    private final class ReviewChangesTextAttributes
    extends TextAttributes {
        @NotNull
        public Color getErrorStripeColor() {
            return (Color)ReviewInEditorUtil.INSTANCE.getREVIEW_CHANGES_STATUS_COLOR();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$ShowDiffAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabled", "", "intellij.vcs.gitlab"})
    private final class ShowDiffAction
    extends LineStatusMarkerPopupActions.RangeMarkerAction
    implements LightEditCompatible {
        public ShowDiffAction(Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(GitLabMergeRequestReviewChangesGutterRenderer.this.editor, GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource(), range, "Vcs.ShowDiffChangedLines");
            ShortcutSet[] shortcutSetArray = new ShortcutSet[]{KeymapUtil.getActiveKeymapShortcuts((String)"Vcs.ShowDiffChangedLines"), KeymapUtil.getActiveKeymapShortcuts((String)"Diff.ShowDiff")};
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(shortcutSetArray));
            Presentation $this$_init__u24lambda_u240 = this.getTemplatePresentation();
            boolean bl = false;
            $this$_init__u24lambda_u240.setText(GitLabBundle.message("action.GitLab.Merge.Request.Review.Editor.Show.Diff.text", new Object[0]));
            $this$_init__u24lambda_u240.setDescription(GitLabBundle.message("action.GitLab.Merge.Request.Review.Editor.Show.Diff.description", new Object[0]));
        }

        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return editor.getUserData(GitLabMergeRequestEditorReviewUIModel.Companion.getKEY()) != null;
        }

        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                GitLabMergeRequestEditorReviewUIModel gitLabMergeRequestEditorReviewUIModel = (GitLabMergeRequestEditorReviewUIModel)editor.getUserData(GitLabMergeRequestEditorReviewUIModel.Companion.getKEY());
                if (gitLabMergeRequestEditorReviewUIModel == null) break block0;
                gitLabMergeRequestEditorReviewUIModel.showDiff(range.getLine1());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$ShowNextChangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getNextRange", "line", "", "isEnabled", "", "intellij.vcs.gitlab"})
    private final class ShowNextChangeMarkerAction
    extends LineStatusMarkerPopupActions.RangeMarkerAction
    implements LightEditCompatible {
        public ShowNextChangeMarkerAction(Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(GitLabMergeRequestReviewChangesGutterRenderer.this.editor, GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource(), range, "VcsShowNextChangeMarker");
        }

        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return this.getNextRange(range.getLine1()) != null;
        }

        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Range targetRange = this.getNextRange(range.getLine1());
            if (targetRange != null) {
                GitLabMergeRequestReviewChangesGutterRenderer.this.scrollAndShow(editor, targetRange);
            }
        }

        private final Range getNextRange(int line2) {
            List list = GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource().getRanges();
            if (list == null) {
                return null;
            }
            List ranges = list;
            return GitLabMergeRequestReviewChangesGutterRendererKt.access$getNextRange(ranges, line2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$ShowPrevChangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPrevRange", "line", "", "isEnabled", "", "intellij.vcs.gitlab"})
    private final class ShowPrevChangeMarkerAction
    extends LineStatusMarkerPopupActions.RangeMarkerAction
    implements LightEditCompatible {
        public ShowPrevChangeMarkerAction(Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(GitLabMergeRequestReviewChangesGutterRenderer.this.editor, GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource(), range, "VcsShowPrevChangeMarker");
        }

        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return this.getPrevRange(range.getLine1()) != null;
        }

        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Range targetRange = this.getPrevRange(range.getLine1());
            if (targetRange != null) {
                GitLabMergeRequestReviewChangesGutterRenderer.this.scrollAndShow(editor, targetRange);
            }
        }

        private final Range getPrevRange(int line2) {
            List list = GitLabMergeRequestReviewChangesGutterRenderer.this.getRangesSource().getRanges();
            if (list == null || (list = CollectionsKt.reversed((Iterable)list)) == null) {
                return null;
            }
            List ranges = list;
            return GitLabMergeRequestReviewChangesGutterRendererKt.access$getNextRange(ranges, line2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewChangesGutterRenderer$ToggleByWordDiffAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "preferences", "Lorg/jetbrains/plugins/gitlab/mergerequest/GitLabMergeRequestsPreferences;", "(Lorg/jetbrains/plugins/gitlab/mergerequest/GitLabMergeRequestsPreferences;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.vcs.gitlab"})
    private static final class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware,
    LightEditCompatible {
        @NotNull
        private final GitLabMergeRequestsPreferences preferences;

        public ToggleByWordDiffAction(@NotNull GitLabMergeRequestsPreferences preferences) {
            Intrinsics.checkNotNullParameter((Object)((Object)preferences), (String)"preferences");
            super(GitLabBundle.message("action.highlight.lines.text", new Object[0]), null, AllIcons.Actions.Highlighting);
            this.preferences = preferences;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.preferences.getHighlightDiffLinesInEditor();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.preferences.setHighlightDiffLinesInEditor(state);
        }
    }
}

