/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.timeline;

import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.text.JBDateFormat;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001f\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineUIUtil;", "", "()V", "createTitleTextPane", "Ljavax/swing/JComponent;", "author", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "date", "Ljava/util/Date;", "getTitleHtml", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestTimelineUIUtil {
    @NotNull
    public static final GitLabMergeRequestTimelineUIUtil INSTANCE = new GitLabMergeRequestTimelineUIUtil();

    private GitLabMergeRequestTimelineUIUtil() {
    }

    @NotNull
    public final JComponent createTitleTextPane(@NotNull GitLabUserDTO author, @Nullable Date date) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        String titleText = this.getTitleHtml(author, date);
        JEditorPane $this$createTitleTextPane_u24lambda_u240 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane((String)titleText);
        boolean bl = false;
        $this$createTitleTextPane_u24lambda_u240.setForeground(UIUtil.getContextHelpForeground());
        JEditorPane titleTextPane = jEditorPane;
        return titleTextPane;
    }

    private final String getTitleHtml(GitLabUserDTO author, Date date) {
        HtmlChunk.Element element = HtmlChunk.link((String)author.getWebUrl(), (String)author.getName()).wrapWith(HtmlChunk.font((String)ColorUtil.toHtmlColor((Color)UIUtil.getLabelForeground()))).bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"bold(...)");
        HtmlChunk.Element userNameLink = element;
        HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)userNameLink);
        if (date != null) {
            builder.append(HtmlChunk.nbsp()).append(JBDateFormat.getFormatter().formatPrettyDateTime(date));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

