/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.clone;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtension;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionStatusLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.GitlabIcons;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.ui.clone.GitLabCloneComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneDialogExtension;", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtension;", "()V", "accountManager", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "nameWithServer", "", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "getNameWithServer", "(Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;)Ljava/lang/String;", "createMainComponent", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionComponent;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "getAdditionalStatusLines", "", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionStatusLine;", "getIcon", "Ljavax/swing/Icon;", "getName", "Companion", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabCloneDialogExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCloneDialogExtension.kt\norg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneDialogExtension\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n43#2,3:48\n1549#3:51\n1620#3,3:52\n*S KotlinDebug\n*F\n+ 1 GitLabCloneDialogExtension.kt\norg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneDialogExtension\n*L\n18#1:48,3\n29#1:51\n29#1:52,3\n*E\n"})
public final class GitLabCloneDialogExtension
implements VcsCloneDialogExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitLabAccountManager accountManager;
    @NotNull
    private static final String SERVICE_DISPLAY_NAME = "GitLab";

    public GitLabCloneDialogExtension() {
        boolean $i$f$service = false;
        Class<GitLabAccountManager> serviceClass$iv = GitLabAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.accountManager = (GitLabAccountManager)object;
    }

    @NotNull
    public String getName() {
        return SERVICE_DISPLAY_NAME;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GitlabIcons.GitLabLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GitLabLogo");
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VcsCloneDialogExtensionStatusLine> getAdditionalStatusLines() {
        List list;
        Set accounts = (Set)this.accountManager.getAccountsState().getValue();
        if (accounts.isEmpty()) {
            String string = CollaborationToolsBundle.message((String)"clone.dialog.label.no.accounts", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            list = CollectionsKt.listOf((Object)VcsCloneDialogExtensionStatusLine.Companion.greyText(string));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = accounts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void account;
                GitLabAccount gitLabAccount = (GitLabAccount)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VcsCloneDialogExtensionStatusLine.Companion.greyText(this.getNameWithServer((GitLabAccount)account)));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public VcsCloneDialogExtensionComponent createMainComponent(@NotNull Project project, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        return new GitLabCloneComponent(project, modalityState, this.accountManager);
    }

    private final String getNameWithServer(GitLabAccount $this$nameWithServer) {
        String serverPrefix = $this$nameWithServer.getServer().isDefault() ? "" : $this$nameWithServer.getServer().getUri() + "/";
        return serverPrefix + $this$nameWithServer.getName();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneDialogExtension$Companion;", "", "()V", "SERVICE_DISPLAY_NAME", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

