/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.marker.ui.basic;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.marker.MarkerBar;
import com.michaelbaranov.microba.marker.ui.MarkerBarListener;
import com.michaelbaranov.microba.marker.ui.MarkerBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicMarkerBarUI
extends MarkerBarUI {
    private Color selectionColor;
    private Color shadowColor;
    private Color focusColor;
    private Color disabledColor;
    private Color normalColor;
    private Color textColor;

    public static ComponentUI createUI(JComponent c) {
        return new BasicMarkerBarUI();
    }

    @Override
    public void installUI(JComponent component) {
        this.installListeners((MarkerBar)component);
        this.installKeyboardActions((MarkerBar)component);
        this.installDefaults((MarkerBar)component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        this.uninstallListeners((MarkerBar)component);
        this.uninstallKeyboardActions((MarkerBar)component);
    }

    protected void installDefaults(MarkerBar bar) {
        LookAndFeel.installBorder(bar, "Slider.border");
        LookAndFeel.installColors(bar, "Slider.background", "Slider.foreground");
        this.selectionColor = UIManager.getColor("ComboBox.selectionBackground");
        this.disabledColor = UIManager.getColor("ComboBox.disabledBackground");
        this.normalColor = UIManager.getColor("ComboBox.background");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.textColor = UIManager.getColor("textText");
    }

    protected void installKeyboardActions(MarkerBar bar) {
        MarkerBarListener listener = this.lookupListsner(bar);
        if (listener != null) {
            listener.installKeyboardActions(bar);
        }
    }

    protected void uninstallKeyboardActions(MarkerBar bar) {
        MarkerBarListener listener = this.lookupListsner(bar);
        if (listener != null) {
            listener.uninstallKeyboardActions(bar);
        }
    }

    protected void installListeners(MarkerBar markerBar) {
        MarkerBarListener listener = this.createListener(markerBar);
        if (markerBar.getDataModel() != null) {
            markerBar.getDataModel().addTableModelListener(listener);
        }
        if (markerBar.getSelectionModel() != null) {
            markerBar.getSelectionModel().addListSelectionListener(listener);
        }
        markerBar.addMouseListener(listener);
        markerBar.addMouseMotionListener(listener);
        markerBar.addFocusListener(listener);
        markerBar.addPropertyChangeListener(listener);
        markerBar.addComponentListener(listener);
    }

    protected void uninstallListeners(MarkerBar markerBar) {
        MarkerBarListener listener = this.lookupListsner(markerBar);
        if (listener != null) {
            if (markerBar.getDataModel() != null) {
                markerBar.getDataModel().removeTableModelListener(listener);
            }
            if (markerBar.getSelectionModel() != null) {
                markerBar.getSelectionModel().removeListSelectionListener(listener);
            }
            markerBar.removeMouseListener(listener);
            markerBar.removeMouseMotionListener(listener);
            markerBar.removeFocusListener(listener);
            markerBar.removePropertyChangeListener(listener);
            markerBar.addComponentListener(listener);
        }
    }

    protected MarkerBarListener lookupListsner(MarkerBar markerBar) {
        MouseMotionListener[] listeners = markerBar.getMouseMotionListeners();
        if (listeners != null) {
            for (int counter = 0; counter < listeners.length; ++counter) {
                if (!(listeners[counter] instanceof MarkerBarListener)) continue;
                return (MarkerBarListener)listeners[counter];
            }
        }
        return null;
    }

    protected MarkerBarListener createListener(MarkerBar markerBar) {
        return new MarkerBarListener(this, markerBar);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isMovable;
        BoundedTableModel dataModel;
        MarkerBar bar = (MarkerBar)c;
        this.calculateViewRectAndBaseline(bar);
        if (bar.isFocusOwner()) {
            this.drawFocusRect(g, this.viewRect);
        }
        if ((dataModel = bar.getDataModel()) == null) {
            return;
        }
        int numAreas = dataModel.getRowCount();
        Polygon[] areas = this.calculateMarkerAreas(bar);
        ListSelectionModel selectionModel = bar.getSelectionModel();
        for (int i = 0; i < numAreas; ++i) {
            boolean isLeadSelect;
            isMovable = dataModel.isCellEditable(i, bar.getPositionColumn());
            boolean bl = selectionModel == null || selectionModel.isSelectionEmpty() ? false : (isLeadSelect = selectionModel.getLeadSelectionIndex() == i);
            if (isLeadSelect) continue;
            this.drawMarker(g, areas[i], false, (Color)dataModel.getValueAt(i, bar.getColorColumn()));
        }
        if (selectionModel != null && !selectionModel.isSelectionEmpty()) {
            int selectedIndex = selectionModel.getLeadSelectionIndex();
            isMovable = dataModel.isCellEditable(selectedIndex, bar.getPositionColumn());
            if (selectedIndex < numAreas) {
                this.drawMarker(g, areas[selectedIndex], true, (Color)dataModel.getValueAt(selectedIndex, bar.getColorColumn()));
            } else {
                throw new IllegalStateException("Selection model inconsistent with data model: element at " + selectedIndex + " selected, but does not exist.");
            }
        }
    }

    protected void drawFocusRect(Graphics g, Rectangle viewRect) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, viewRect.x, viewRect.y, viewRect.width, viewRect.height);
    }

    protected void drawMarker(Graphics g, Polygon p, boolean isSelected, Color color) {
        Color innerColor = color != null ? color : this.getNormalColor();
        Color selColor = isSelected ? this.getTextColor() : innerColor;
        g.setColor(innerColor);
        g.fillPolygon(p);
        if (isSelected) {
            int[] xx = new int[3];
            int[] yy = new int[3];
            xx[0] = p.xpoints[0];
            xx[1] = p.xpoints[1];
            xx[2] = p.xpoints[p.npoints - 1];
            yy[0] = p.ypoints[0];
            yy[1] = p.ypoints[1];
            yy[2] = p.ypoints[p.npoints - 1];
            Polygon bickP = new Polygon(xx, yy, 3);
            g.setColor(selColor);
            g.fillPolygon(bickP);
            g.drawPolygon(bickP);
        }
        g.setColor(this.getTextColor());
        g.drawPolygon(p);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        MarkerBar bar = (MarkerBar)c;
        Insets ins = bar.getInsets();
        if (bar.getOrientation() == 0) {
            return new Dimension(this.MARKER_BODY_WIDTH + ins.left + ins.right + 1, this.MARKER_BODY_HEIGHT + ins.top + ins.bottom + 1);
        }
        return new Dimension(this.MARKER_BODY_HEIGHT + ins.top + ins.bottom + 1, this.MARKER_BODY_WIDTH + ins.left + ins.right + 1);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        MarkerBar bar = (MarkerBar)c;
        BoundedTableModel dataModel = bar.getDataModel();
        Insets ins = bar.getInsets();
        int r = dataModel == null ? 1 : dataModel.getUpperBound() - dataModel.getLowerBound();
        if (bar.getOrientation() == 0) {
            return new Dimension(r * 2 + this.MARKER_BODY_WIDTH + ins.left + ins.right + 1, this.MARKER_BODY_HEIGHT + this.MARKER_BICK_HEIGHT + ins.top + ins.bottom + 1);
        }
        return new Dimension(this.MARKER_BODY_HEIGHT + this.MARKER_BICK_HEIGHT + ins.top + ins.bottom + 1, r * 2 + this.MARKER_BODY_WIDTH + ins.left + ins.right + 1);
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public Color getNormalColor() {
        return this.normalColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }
}

