/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;

final class MaxScoreBulkScorer
extends BulkScorer {
    static final int INNER_WINDOW_SIZE = 2048;
    private final int maxDoc;
    private final DisiWrapper[] allScorers;
    private final DisiWrapper[] scratch;
    private final DisiPriorityQueue essentialQueue;
    private int firstEssentialScorer;
    private final long cost;
    private float minCompetitiveScore;
    private boolean minCompetitiveScoreUpdated;
    private ScoreAndDoc scorable = new ScoreAndDoc();
    private final double[] maxScoreSums;
    private final long[] windowMatches = new long[FixedBitSet.bits2words(2048)];
    private final double[] windowScores = new double[2048];

    MaxScoreBulkScorer(int maxDoc, List<Scorer> scorers) throws IOException {
        this.maxDoc = maxDoc;
        this.allScorers = new DisiWrapper[scorers.size()];
        this.scratch = new DisiWrapper[this.allScorers.length];
        int i = 0;
        long cost = 0L;
        for (Scorer scorer : scorers) {
            DisiWrapper w = new DisiWrapper(scorer);
            cost += w.cost;
            this.allScorers[i++] = w;
        }
        this.cost = cost;
        this.essentialQueue = new DisiPriorityQueue(this.allScorers.length);
        this.maxScoreSums = new double[this.allScorers.length];
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.scorable);
        int outerWindowMin = min;
        block0: while (outerWindowMin < max) {
            int outerWindowMax = this.updateMaxWindowScores(outerWindowMin);
            outerWindowMax = Math.min(outerWindowMax, max);
            if (!this.partitionScorers()) {
                outerWindowMin = outerWindowMax;
                continue;
            }
            DisiWrapper top = this.essentialQueue.top();
            while (top.doc < outerWindowMin) {
                top.doc = top.iterator.advance(outerWindowMin);
                top = this.essentialQueue.updateTop();
            }
            while (top.doc < outerWindowMax) {
                this.scoreInnerWindow(collector, acceptDocs, outerWindowMax);
                top = this.essentialQueue.top();
                if (!this.minCompetitiveScoreUpdated) continue;
                this.minCompetitiveScoreUpdated = false;
                if (!this.partitionScorers()) {
                    outerWindowMin = outerWindowMax;
                    continue block0;
                }
                int nextCandidateMatch = top.doc;
                top = this.essentialQueue.top();
                while (top.doc < nextCandidateMatch) {
                    top.doc = top.iterator.advance(nextCandidateMatch);
                    top = this.essentialQueue.updateTop();
                }
            }
            outerWindowMin = outerWindowMax;
        }
        return this.nextCandidate(max);
    }

    private void scoreInnerWindow(LeafCollector collector, Bits acceptDocs, int max) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        DisiWrapper top2 = this.essentialQueue.top2();
        if (top2 == null) {
            this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, max);
        } else if (top2.doc - 1024 >= top.doc) {
            this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, Math.min(max, top2.doc));
        } else {
            this.scoreInnerWindowMultipleEssentialClauses(collector, acceptDocs, max);
        }
    }

    private void scoreInnerWindowSingleEssentialClause(LeafCollector collector, Bits acceptDocs, int upTo) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        int doc = top.doc;
        while (doc < upTo) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                this.scoreNonEssentialClauses(collector, doc, top.scorer.score());
                if (this.minCompetitiveScoreUpdated) {
                    top.iterator.nextDoc();
                    break;
                }
            }
            doc = top.iterator.nextDoc();
        }
        top.doc = top.iterator.docID();
        this.essentialQueue.updateTop();
    }

    private void scoreInnerWindowMultipleEssentialClauses(LeafCollector collector, Bits acceptDocs, int max) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        int innerWindowMin = top.doc;
        int innerWindowMax = (int)Math.min((long)max, (long)innerWindowMin + 2048L);
        do {
            int doc = top.doc;
            while (doc < innerWindowMax) {
                if (acceptDocs == null || acceptDocs.get(doc)) {
                    int i = doc - innerWindowMin;
                    int n = i >>> 6;
                    this.windowMatches[n] = this.windowMatches[n] | 1L << i;
                    int n2 = i;
                    this.windowScores[n2] = this.windowScores[n2] + (double)top.scorer.score();
                }
                doc = top.iterator.nextDoc();
            }
            top.doc = top.iterator.docID();
            top = this.essentialQueue.updateTop();
        } while (top.doc < innerWindowMax);
        for (int wordIndex = 0; wordIndex < this.windowMatches.length; ++wordIndex) {
            int ntz;
            this.windowMatches[wordIndex] = 0L;
            for (long bits = this.windowMatches[wordIndex]; bits != 0L; bits ^= 1L << ntz) {
                ntz = Long.numberOfTrailingZeros(bits);
                int index = wordIndex << 6 | ntz;
                int doc = innerWindowMin + index;
                double score = this.windowScores[index];
                this.windowScores[index] = 0.0;
                this.scoreNonEssentialClauses(collector, doc, score);
            }
        }
    }

    private int updateMaxWindowScores(int windowMin) throws IOException {
        int firstWindowLead = Math.min(this.firstEssentialScorer, this.allScorers.length - 1);
        for (int i = 0; i < firstWindowLead; ++i) {
            DisiWrapper scorer = this.allScorers[i];
            if (scorer.doc >= windowMin) continue;
            scorer.scorer.advanceShallow(windowMin);
        }
        int windowMax = Integer.MAX_VALUE;
        for (int i = firstWindowLead; i < this.allScorers.length; ++i) {
            DisiWrapper scorer = this.allScorers[i];
            int upTo = scorer.scorer.advanceShallow(Math.max(scorer.doc, windowMin));
            windowMax = (int)Math.min((long)windowMax, (long)upTo + 1L);
        }
        windowMax = Math.max(windowMax, (int)Math.min(Integer.MAX_VALUE, (long)windowMin + 2048L));
        for (DisiWrapper scorer : this.allScorers) {
            scorer.maxWindowScore = scorer.doc < windowMax ? scorer.scorer.getMaxScore(windowMax - 1) : 0.0f;
        }
        return windowMax;
    }

    private void scoreNonEssentialClauses(LeafCollector collector, int doc, double essentialScore) throws IOException {
        double score = essentialScore;
        for (int i = this.firstEssentialScorer - 1; i >= 0; --i) {
            float maxPossibleScore = (float)MathUtil.sumUpperBound(score + this.maxScoreSums[i], this.allScorers.length);
            if (maxPossibleScore < this.minCompetitiveScore) {
                return;
            }
            DisiWrapper scorer = this.allScorers[i];
            if (scorer.doc < doc) {
                scorer.doc = scorer.iterator.advance(doc);
            }
            if (scorer.doc != doc) continue;
            score += (double)scorer.scorer.score();
        }
        this.scorable.doc = doc;
        this.scorable.score = (float)score;
        collector.collect(doc);
    }

    private boolean partitionScorers() {
        int i;
        System.arraycopy(this.allScorers, 0, this.scratch, 0, this.allScorers.length);
        Arrays.sort(this.scratch, Comparator.comparingDouble(scorer -> (double)scorer.maxWindowScore / (double)Math.max(1L, scorer.cost)));
        double maxScoreSum = 0.0;
        this.firstEssentialScorer = 0;
        for (i = 0; i < this.allScorers.length; ++i) {
            DisiWrapper w = this.scratch[i];
            double newMaxScoreSum = maxScoreSum + (double)w.maxWindowScore;
            float maxScoreSumFloat = (float)MathUtil.sumUpperBound(newMaxScoreSum, this.firstEssentialScorer + 1);
            if (maxScoreSumFloat < this.minCompetitiveScore) {
                maxScoreSum = newMaxScoreSum;
                this.allScorers[this.firstEssentialScorer] = w;
                this.maxScoreSums[this.firstEssentialScorer] = maxScoreSum;
                ++this.firstEssentialScorer;
                continue;
            }
            this.allScorers[this.allScorers.length - 1 - (i - this.firstEssentialScorer)] = w;
        }
        if (this.firstEssentialScorer == this.allScorers.length) {
            return false;
        }
        this.essentialQueue.clear();
        for (i = this.firstEssentialScorer; i < this.allScorers.length; ++i) {
            this.essentialQueue.add(this.allScorers[i]);
        }
        return true;
    }

    private int nextCandidate(int rangeEnd) {
        if (rangeEnd >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        int next = Integer.MAX_VALUE;
        for (DisiWrapper scorer : this.allScorers) {
            if (scorer.doc < rangeEnd) {
                return rangeEnd;
            }
            next = Math.min(next, scorer.doc);
        }
        return next;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private class ScoreAndDoc
    extends Scorable {
        float score;
        int doc = -1;

        private ScoreAndDoc() {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float score() {
            return this.score;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            MaxScoreBulkScorer.this.minCompetitiveScore = minScore;
            MaxScoreBulkScorer.this.minCompetitiveScoreUpdated = true;
        }
    }
}

