/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Axiomatic;
import org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF2EXP
extends Axiomatic {
    public AxiomaticF2EXP(float s, float k) {
        super(s, 1, k);
    }

    public AxiomaticF2EXP(float s) {
        this(s, 0.35f);
    }

    public AxiomaticF2EXP() {
    }

    @Override
    public String toString() {
        return "F2EXP";
    }

    @Override
    protected double tf(BasicStats stats2, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double ln(BasicStats stats2, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double tfln(BasicStats stats2, double freq, double docLen) {
        return freq / (freq + (double)this.s + (double)this.s * docLen / stats2.getAvgFieldLength());
    }

    @Override
    protected double idf(BasicStats stats2, double freq, double docLen) {
        return Math.pow(((double)stats2.getNumberOfDocuments() + 1.0) / (double)stats2.getDocFreq(), this.k);
    }

    @Override
    protected double gamma(BasicStats stats2, double freq, double docLen) {
        return 0.0;
    }

    @Override
    protected Explanation tfExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tf(stats2, freq, docLen)), "tf, term frequency, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation lnExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.ln(stats2, freq, docLen)), "ln, document length, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation tflnExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tfln(stats2, freq, docLen)), "tfln, mixed term frequency and document length, computed as freq / (freq + s + s * dl / avgdl) from:", Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)stats2.getAvgFieldLength()), "avgdl, average length of field across all documents", new Explanation[0]));
    }

    @Override
    protected Explanation idfExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.idf(stats2, freq, docLen)), "idf, inverted document frequency computed as Math.pow((N + 1) / n, k) from:", Explanation.match((Number)Float.valueOf(stats2.getNumberOfDocuments()), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats2.getDocFreq()), "n, number of documents containing term", new Explanation[0]));
    }
}

