/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.ProgressManagerQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfiguration;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManagerKt;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.branchConfig.SvnBranchMapperManager;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@State(name="SvnBranchConfigurationManager")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\b\u0001\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0002H\u0016J\"\u0010\"\u001a\u00020\u001f2\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0%0$H\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0%0)H\u0002J2\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0%0/H\u0002J\u0016\u00100\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager$ConfigurationBean;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "branchesLoader", "Lcom/intellij/vcs/ProgressManagerQueue;", "configurationBean", "isInitialized", "", "supportValue", "", "getSupportValue", "()Ljava/lang/Long;", "svnBranchConfigManager", "Lorg/jetbrains/idea/svn/branchConfig/NewRootBunch;", "getSvnBranchConfigManager", "()Lorg/jetbrains/idea/svn/branchConfig/NewRootBunch;", "addUserInfo", "Lorg/jetbrains/idea/svn/api/Url;", "urlValue", "", "smartParse", "userInfo", "get", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getState", "initialize", "", "loadState", "state", "preloadBranches", "branchPoints", "", "Lkotlin/Pair;", "removeUserInfo", "url", "resolveAllBranchPoints", "", "resolveConfiguration", "root", "persistedConfiguration", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfiguration;", "branchPointsToLoad", "", "setConfiguration", "configuration", "Companion", "ConfigurationBean", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nSvnBranchConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnBranchConfigurationManager.kt\norg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1#2:193\n1549#3:179\n1620#3,3:180\n1603#3,9:183\n1855#3:192\n1856#3:194\n1612#3:195\n*S KotlinDebug\n*F\n+ 1 SvnBranchConfigurationManager.kt\norg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager\n*L\n116#1:193\n64#1:179\n64#1:180,3\n116#1:183,9\n116#1:192\n116#1:194\n116#1:195\n*E\n"})
public final class SvnBranchConfigurationManager
implements PersistentStateComponent<ConfigurationBean> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProgressManagerQueue branchesLoader;
    @NotNull
    private final NewRootBunch svnBranchConfigManager;
    private boolean isInitialized;
    @NotNull
    private ConfigurationBean configurationBean;

    public SvnBranchConfigurationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.branchesLoader = new ProgressManagerQueue(this.project, SvnBundle.message("progress.title.svn.branches.preloader", new Object[0]));
        this.svnBranchConfigManager = new NewRootBunch(this.project, this.branchesLoader);
        this.configurationBean = new ConfigurationBean();
    }

    @NotNull
    public final NewRootBunch getSvnBranchConfigManager() {
        return this.svnBranchConfigManager;
    }

    @Nullable
    public final Long getSupportValue() {
        return this.configurationBean.myVersion;
    }

    @NotNull
    public final SvnBranchConfigurationNew get(@NotNull VirtualFile vcsRoot) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        return this.svnBranchConfigManager.getConfig(vcsRoot);
    }

    public final void setConfiguration(@NotNull VirtualFile vcsRoot, @NotNull SvnBranchConfigurationNew configuration) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.svnBranchConfigManager.updateForRoot(vcsRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.setByUser), true);
        SvnBranchMapperManager.getInstance().notifyBranchesChanged(this.project, vcsRoot, configuration);
        ((VcsConfigurationChangeListener.Notification)BackgroundTaskUtil.syncPublisher((Project)this.project, (Topic)VcsConfigurationChangeListener.BRANCHES_CHANGED)).execute(this.project, vcsRoot);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public ConfigurationBean getState() {
        $this$getState_u24lambda_u243 = var1_1 = new ConfigurationBean();
        $i$a$-apply-SvnBranchConfigurationManager$getState$1 = false;
        $this$getState_u24lambda_u243.myVersion = this.configurationBean.myVersion;
        for (VirtualFile root : this.svnBranchConfigManager.getMapCopy().keySet()) {
            configuration = this.svnBranchConfigManager.getConfig(root);
            var7_7 = new SvnBranchConfiguration();
            $this$getState_u24lambda_u243_u24lambda_u242 = var7_7;
            $i$a$-apply-SvnBranchConfigurationManager$getState$1$configurationToPersist$1 = false;
            v0 = configuration.getTrunk();
            var10_10 = v0 != null ? v0.getUserInfo() : null;
            $this$getState_u24lambda_u243_u24lambda_u242.setUserinfoInUrl((var10_10 == null || var10_10.length() == 0) == false);
            v1 = $this$getState_u24lambda_u243_u24lambda_u242;
            v2 = configuration.getTrunk();
            if (v2 == null) ** GOTO lbl-1000
            var11_11 = v2;
            var12_12 = v1;
            $i$a$-let-SvnBranchConfigurationManager$getState$1$configurationToPersist$1$1 = false;
            v3 = this.removeUserInfo((Url)p0);
            v1 = var12_12;
            v2 = v3;
            if (v3 != null) {
                v4 = v2.toDecodedString();
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v1.setTrunkUrl(v4);
            var10_10 = configuration.getBranchLocations();
            var12_12 = $this$getState_u24lambda_u243_u24lambda_u242;
            $i$f$map = false;
            var15_15 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var18_18 = (Url)item$iv$iv;
                var19_19 = destination$iv$iv;
                $i$a$-map-SvnBranchConfigurationManager$getState$1$configurationToPersist$1$2 = false;
                var19_19.add(this.removeUserInfo(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (Url)item$iv$iv;
                var19_19 = destination$iv$iv;
                $i$a$-map-SvnBranchConfigurationManager$getState$1$configurationToPersist$1$3 = false;
                var19_19.add(p0.toString());
            }
            var12_12.setBranchUrls((List)destination$iv$iv);
            configurationToPersist = var7_7;
            var7_7 = $this$getState_u24lambda_u243.myConfigurationMap;
            v5 = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getPath(...)");
            var7_7.put(v5, configurationToPersist);
        }
        return var1_1;
    }

    public void loadState(@NotNull ConfigurationBean state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.configurationBean = state;
    }

    private final synchronized void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.preloadBranches((Collection<? extends Pair<? extends VirtualFile, SvnBranchConfigurationNew>>)this.resolveAllBranchPoints());
        }
    }

    private final Set<Pair<VirtualFile, SvnBranchConfigurationNew>> resolveAllBranchPoints() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        Set branchPointsToLoad = new LinkedHashSet();
        for (Map.Entry<String, SvnBranchConfiguration> entry : this.configurationBean.myConfigurationMap.entrySet()) {
            String path = entry.getKey();
            SvnBranchConfiguration persistedConfiguration = entry.getValue();
            VirtualFile root = lfs.refreshAndFindFileByPath(path);
            if (root != null) {
                SvnBranchConfigurationNew configuration = this.resolveConfiguration(root, persistedConfiguration, branchPointsToLoad);
                this.svnBranchConfigManager.updateForRoot(root, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.setByUser), false);
                continue;
            }
            SvnBranchConfigurationManagerKt.access$getLOG$p().info("root not found: " + path);
        }
        return branchPointsToLoad;
    }

    /*
     * WARNING - void declaration
     */
    private final SvnBranchConfigurationNew resolveConfiguration(VirtualFile root, SvnBranchConfiguration persistedConfiguration, Set<Pair<VirtualFile, SvnBranchConfigurationNew>> branchPointsToLoad) {
        void $this$mapNotNullTo$iv$iv;
        Url url;
        Iterable it;
        String string;
        SvnBranchConfigurationNew svnBranchConfigurationNew;
        Url url2;
        String userInfo = persistedConfiguration.isUserinfoInUrl() ? ((url2 = SvnVcs.getInstance(this.project).getSvnFileUrlMapping().getUrlForFile(VfsUtilCore.virtualToIoFile((VirtualFile)root))) != null ? url2.getUserInfo() : null) : null;
        SvnBranchConfigurationNew $this$resolveConfiguration_u24lambda_u245 = svnBranchConfigurationNew = new SvnBranchConfigurationNew();
        boolean bl = false;
        SvnBranchConfigurationNew svnBranchConfigurationNew2 = $this$resolveConfiguration_u24lambda_u245;
        String string2 = string = persistedConfiguration.getTrunkUrl();
        if (string2 != null) {
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string;
            SvnBranchConfigurationNew svnBranchConfigurationNew3 = svnBranchConfigurationNew2;
            boolean bl2 = false;
            url = this.addUserInfo((String)((Object)it), true, userInfo);
            svnBranchConfigurationNew2 = svnBranchConfigurationNew3;
        } else {
            url = null;
        }
        svnBranchConfigurationNew2.setTrunk(url);
        $this$resolveConfiguration_u24lambda_u245.setUserInfoInUrl(persistedConfiguration.isUserinfoInUrl());
        SvnBranchConfigurationNew result = svnBranchConfigurationNew;
        SvnLoadedBranchesStorage storage = SvnLoadedBranchesStorage.Companion.getInstance(this.project);
        List<String> list = persistedConfiguration.getBranchUrls();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getBranchUrls(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Url it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            String it2 = (String)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it2);
            if (this.addUserInfo(it2, false, userInfo) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (Url branchLocation : (List)destination$iv$iv) {
            List storedBranches;
            List list2 = storage.get(branchLocation);
            if (list2 == null || (list2 = CollectionsKt.sorted((Iterable)list2)) == null) {
                list2 = new ArrayList();
            }
            result.addBranches(branchLocation, new InfoStorage<List<SvnBranchItem>>(storedBranches, !((Collection)(storedBranches = list2)).isEmpty() ? InfoReliability.setByUser : InfoReliability.empty));
            if (!storedBranches.isEmpty()) continue;
            branchPointsToLoad.add((Pair<VirtualFile, SvnBranchConfigurationNew>)TuplesKt.to((Object)root, (Object)result));
        }
        return result;
    }

    private final void preloadBranches(Collection<? extends Pair<? extends VirtualFile, SvnBranchConfigurationNew>> branchPoints) {
        ProjectLevelVcsManager.getInstance((Project)this.project).runAfterInitialization(() -> SvnBranchConfigurationManager.preloadBranches$lambda$8(branchPoints, this));
    }

    private final Url removeUserInfo(Url url) {
        Object object;
        Object object2 = url.getUserInfo();
        if (object2 == null || object2.length() == 0) {
            object = url;
        } else {
            try {
                object2 = url.setUserInfo(null);
            }
            catch (SvnBindException e) {
                SvnBranchConfigurationManagerKt.access$getLOG$p().info("Could not remove user info " + url.getUserInfo() + " from url " + url.toDecodedString(), (Throwable)((Object)e));
                object2 = url;
            }
            object = object2;
        }
        return object;
    }

    private final Url addUserInfo(String urlValue, boolean smartParse, String userInfo) {
        Object object;
        Url result = null;
        try {
            Url url = SvnUtil.createUrl(urlValue, !smartParse || StringsKt.contains$default((CharSequence)urlValue, (char)'%', (boolean)false, (int)2, null));
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"createUrl(...)");
            result = url;
        }
        catch (SvnBindException e) {
            SvnBranchConfigurationManagerKt.access$getLOG$p().info("Could not parse url " + urlValue, (Throwable)((Object)e));
            return null;
        }
        Object object2 = userInfo;
        if (object2 == null || object2.length() == 0) {
            object = result;
        } else {
            try {
                object2 = result.setUserInfo(userInfo);
            }
            catch (SvnBindException e) {
                SvnBranchConfigurationManagerKt.access$getLOG$p().info("Could not add user info " + userInfo + " to url " + urlValue, (Throwable)((Object)e));
                object2 = result;
            }
            object = object2;
        }
        return object;
    }

    private static final void preloadBranches$lambda$8$lambda$7(Collection $branchPoints, SvnBranchConfigurationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$branchPoints, (String)"$branchPoints");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ SvnBranchConfigurationManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!SvnBranchConfigurationManager.access$getProject$p(this.this$0).isDisposed()) {
                    SvnBranchConfigurationManager.access$getBranchesLoader$p(this.this$0).start();
                }
            }
        }));
        for (Pair pair : $branchPoints) {
            VirtualFile root = (VirtualFile)pair.component1();
            SvnBranchConfigurationNew configuration = (SvnBranchConfigurationNew)pair.component2();
            this$0.svnBranchConfigManager.reloadBranches(root, null, configuration);
        }
    }

    private static final void preloadBranches$lambda$8(Collection $branchPoints, SvnBranchConfigurationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$branchPoints, (String)"$branchPoints");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApplicationManager.getApplication().executeOnPooledThread(() -> SvnBranchConfigurationManager.preloadBranches$lambda$8$lambda$7($branchPoints, this$0));
    }

    @JvmStatic
    @NotNull
    public static final SvnBranchConfigurationManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(SvnBranchConfigurationManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ ProgressManagerQueue access$getBranchesLoader$p(SvnBranchConfigurationManager $this) {
        return $this.branchesLoader;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nSvnBranchConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnBranchConfigurationManager.kt\norg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SvnBranchConfigurationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(SvnBranchConfigurationManager.class);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            SvnBranchConfigurationManager $this$getInstance_u24lambda_u240 = (SvnBranchConfigurationManager)object2;
            boolean bl = false;
            $this$getInstance_u24lambda_u240.initialize();
            return (SvnBranchConfigurationManager)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager$ConfigurationBean;", "", "()V", "myConfigurationMap", "", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfiguration;", "myVersion", "", "Ljava/lang/Long;", "intellij.vcs.svn"})
    public static final class ConfigurationBean {
        @JvmField
        @NotNull
        public Map<String, SvnBranchConfiguration> myConfigurationMap = new TreeMap();
        @JvmField
        @Nullable
        public Long myVersion;
    }
}

