/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif.model.taint;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.text.StrBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.sarif.model.taint.TaintProblemKt;
import org.jetbrains.qodana.sarif.model.taint.TaintSink;
import org.jetbrains.qodana.sarif.model.taint.TaintSource;
import org.jetbrains.qodana.sarif.model.taint.Validation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006J\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0003*\u00020\u0003H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/sarif/model/taint/TaintSink;", "Lorg/jetbrains/qodana/sarif/model/taint/Validation;", "text", "", "fqn", "vulnerabilities", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFqn", "()Ljava/lang/String;", "setFqn", "(Ljava/lang/String;)V", "getText", "setText", "getVulnerabilities", "()Ljava/util/List;", "setVulnerabilities", "(Ljava/util/List;)V", "comment", "sources", "Lorg/jetbrains/qodana/sarif/model/taint/TaintSource;", "type", "validate", "", "toReadableType", "Companion", "sarif-converter"})
public final class TaintSink
implements Validation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String text;
    @Nullable
    private String fqn;
    @Nullable
    private List<String> vulnerabilities;

    public TaintSink(@Nullable String text2, @Nullable String fqn, @Nullable List<String> vulnerabilities) {
        this.text = text2;
        this.fqn = fqn;
        this.vulnerabilities = vulnerabilities;
    }

    public /* synthetic */ TaintSink(String string, String string2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        this(string, string2, list2);
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    @Nullable
    public final String getFqn() {
        return this.fqn;
    }

    public final void setFqn(@Nullable String string) {
        this.fqn = string;
    }

    @Nullable
    public final List<String> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public final void setVulnerabilities(@Nullable List<String> list2) {
        this.vulnerabilities = list2;
    }

    @Override
    public boolean validate() {
        return this.text != null && this.fqn != null && this.vulnerabilities != null;
    }

    @NotNull
    public final String comment(@NotNull List<TaintSource> sources) {
        String string;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        StrBuilder sb = new StrBuilder();
        String string2 = this.fqn;
        Intrinsics.checkNotNull((Object)string2);
        if (StringsKt.startsWith$default((String)string2, (String)"\\", (boolean)false, (int)2, null)) {
            String string3 = this.fqn;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = string3.substring(1);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = this.fqn;
        }
        String printingFQN = string;
        sb.append("Tainted flow to the '" + printingFQN + "': '" + this.text + "' parameter");
        if (!((Collection)sources).isEmpty()) {
            sb.append(" from: ");
            sb.append(CollectionsKt.joinToString$default((Iterable)sources, (CharSequence)", ", null, null, (int)0, null, (Function1)comment.1.INSTANCE, (int)30, null));
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"sb.toString()");
        return string5;
    }

    @NotNull
    public final String type() {
        List<String> list2 = this.vulnerabilities;
        Intrinsics.checkNotNull(list2);
        String string = (String)CollectionsKt.firstOrNull(list2);
        if (string == null) {
            string = "Taint analysis";
        }
        return this.toReadableType(string);
    }

    private final String toReadableType(String $this$toReadableType) {
        String string;
        switch ($this$toReadableType) {
            case "Code": {
                string = "Label";
                break;
            }
            case "XSS": {
                string = "XSS";
                break;
            }
            case "SQL": {
                string = "SQL injection";
                break;
            }
            case "XPATH": {
                string = "XPath injection";
                break;
            }
            case "LDAP": {
                string = "LDAP injection";
                break;
            }
            case "HEADER": {
                string = "HTTP header injection";
                break;
            }
            case "RCE": {
                string = "Remote code execution";
                break;
            }
            case "SESSION": {
                string = "Session hijacking";
                break;
            }
            case "DIRECT_REF": {
                string = "Insecure Direct object reference";
                break;
            }
            case "INCLUSION": {
                string = "File Inclusion";
                break;
            }
            case "DISCLOSURE": {
                string = "Information disclosure (directory traversal)";
                break;
            }
            default: {
                string = $this$toReadableType;
            }
        }
        return string;
    }

    public TaintSink() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/qodana/sarif/model/taint/TaintSink$Companion;", "", "()V", "readTaintSink", "Lorg/jetbrains/qodana/sarif/model/taint/TaintSink;", "sink", "", "", "validation", "", "sarif-converter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaintSink readTaintSink(@NotNull Map<String, ? extends Object> sink, boolean validation) {
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            TaintSink taintSink = new TaintSink(null, null, null, 7, null);
            taintSink.setText((String)sink.get("text"));
            taintSink.setFqn((String)sink.get("fqn"));
            Object object = sink.get("vulnerabilities");
            taintSink.setVulnerabilities(object != null ? TaintProblemKt.access$asStrings(object) : null);
            if (validation && !taintSink.validate()) {
                throw new Exception("Failed call validation for TaintSink");
            }
            return taintSink;
        }

        public static /* synthetic */ TaintSink readTaintSink$default(Companion companion, Map map2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.readTaintSink(map2, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

